/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class SteamVentBlock
extends class_2248
implements class_3737 {
    public static final class_2754<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 PARTICLES_ENABLED = class_2746.method_11825((String)"particles_enabled");
    private static final Map<FurnitureUtil.VerticalConnectingType, Supplier<class_265>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.VerticalConnectingType, Supplier<class_265>>();
    private static final Map<FurnitureUtil.VerticalConnectingType, class_265> SHAPES = new EnumMap<FurnitureUtil.VerticalConnectingType, class_265>(FurnitureUtil.VerticalConnectingType.class);

    public SteamVentBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)PARTICLES_ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TYPE, WATERLOGGED, PARTICLES_ENABLED});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 blockState = this.method_9564();
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        blockState = (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)this.getType(blockState, world.method_8320(clickedPos.method_10084()), world.method_8320(clickedPos.method_10074()))));
        return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(clickedPos).method_15772() == class_3612.field_15910));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.method_8320(pos.method_10084()), world.method_8320(pos.method_10074()));
        if (state.method_11654(TYPE) != type) {
            state = (class_2680)state.method_11657(TYPE, (Comparable)((Object)type));
        }
        world.method_8652(pos, state, 3);
    }

    public FurnitureUtil.VerticalConnectingType getType(class_2680 state, class_2680 above, class_2680 below) {
        boolean shapeBelowSame;
        boolean shapeAboveSame = above.method_26204() == state.method_26204();
        boolean bl = shapeBelowSame = below.method_26204() == state.method_26204();
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.method_11654(TYPE));
        return SHAPES.get((Object)type);
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            boolean particlesEnabled = (Boolean)state.method_11654((class_2769)PARTICLES_ENABLED);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)PARTICLES_ENABLED, (Comparable)Boolean.valueOf(!particlesEnabled)), 3);
            String messageKey = particlesEnabled ? "tooltip.furniture.vent_disabled" : "tooltip.furniture.vent_enabled";
            player.method_7353((class_2561)class_2561.method_43471((String)messageKey), true);
        }
        return class_1269.field_5812;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)PARTICLES_ENABLED)).booleanValue() && (state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.NONE || state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.BOTTOM)) {
            double x = (double)pos.method_10263() + 0.5;
            double y = pos.method_10264() - 1;
            double z = (double)pos.method_10260() + 0.5;
            double vx = 0.0;
            double vy = 0.02 + random.method_43058() * 0.02;
            double vz = 0.0;
            world.method_8406((class_2394)class_2398.field_11204, x, y, z, vx, vy, vz);
        }
    }

    private static class_265 makeTopShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.9375, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeBottomShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeSingleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeMiddleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.9375, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    }

    static {
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.NONE, SteamVentBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.MIDDLE, SteamVentBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.TOP, SteamVentBlock::makeTopShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.BOTTOM, SteamVentBlock::makeBottomShape);
        for (Map.Entry<FurnitureUtil.VerticalConnectingType, Supplier<class_265>> entry : SHAPES_SUPPLIERS.entrySet()) {
            SHAPES.put(entry.getKey(), entry.getValue().get());
        }
    }
}

