/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2383;
import net.minecraft.class_247;
import net.minecraft.class_2544;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class StreetLanternBlock
extends class_2383
implements class_3737 {
    public static final class_2754<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 BULBS = class_2758.method_11867((String)"bulbs", (int)0, (int)1);
    public static final class_2746 LIT = class_2741.field_12548;
    private static final Supplier<class_265> SINGLE_SHAPE_SUPPLIER = StreetLanternBlock::makeSingleShape;
    private static final Supplier<class_265> DOUBLE_SHAPE_SUPPLIER = StreetLanternBlock::makeDoubleShape;
    private static final Supplier<class_265> MIDDLE_SHAPE_SUPPLIER = StreetLanternBlock::makeMiddleShape;
    private static final Supplier<class_265> BOTTOM_SHAPE_SUPPLIER = StreetLanternBlock::makeBottomShape;
    public static final Map<class_2350, class_265> SINGLE_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, SINGLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<class_2350, class_265> DOUBLE_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, DOUBLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<class_2350, class_265> MIDDLE_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, MIDDLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<class_2350, class_265> BOTTOM_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(class_2350.field_11043, direction, BOTTOM_SHAPE_SUPPLIER.get()));
        }
    });

    public StreetLanternBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BULBS, (Comparable)Integer.valueOf(0))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11177, TYPE, WATERLOGGED, BULBS, LIT});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2338 clickedPos = context.method_8037();
        class_2338 belowPos = clickedPos.method_10074();
        class_2680 belowBlockState = context.method_8045().method_8320(belowPos);
        if (!(belowBlockState.method_27852((class_2248)this) || belowBlockState.method_26204() instanceof class_2544 || belowBlockState.method_26204() instanceof class_2354 || belowBlockState.method_26206((class_1922)context.method_8045(), belowPos, class_2350.field_11036))) {
            return null;
        }
        class_2680 blockState = context.method_8045().method_8320(clickedPos);
        if (blockState.method_27852((class_2248)this) && (blockState.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.TOP || blockState.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.NONE)) {
            return (class_2680)blockState.method_11657((class_2769)BULBS, (Comparable)Integer.valueOf(Math.min(1, (Integer)blockState.method_11654((class_2769)BULBS) + 1)));
        }
        boolean flag = context.method_8045().method_8316(clickedPos).method_15772() == class_3612.field_15910;
        class_2350 direction = context.method_8042().method_10153();
        blockState = (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction);
        blockState = (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)this.getType(blockState, context.method_8045().method_8320(clickedPos.method_10084()), context.method_8045().method_8320(clickedPos.method_10074()))));
        return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = world.method_8320(belowPos);
        return belowState.method_27852((class_2248)this) || belowState.method_26204() instanceof class_2544 || belowState.method_26204() instanceof class_2354 || belowState.method_26206((class_1922)world, belowPos, class_2350.field_11036);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.method_8320(pos.method_10084()), world.method_8320(pos.method_10074()));
        if (state.method_11654(TYPE) != type) {
            state = (class_2680)state.method_11657(TYPE, (Comparable)((Object)type));
        }
        world.method_8652(pos, state, 3);
    }

    public FurnitureUtil.VerticalConnectingType getType(class_2680 state, class_2680 above, class_2680 below) {
        boolean shapeBelowSame;
        boolean shapeAboveSame = above.method_26204() == state.method_26204();
        boolean bl = shapeBelowSame = below.method_26204() == state.method_26204();
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    private static class_265 makeDoubleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.5625, (double)0.3125, (double)0.375, (double)1.0, (double)0.6875), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.625, (double)0.5625, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.5, (double)0.375, (double)0.3125, (double)0.5625, (double)0.625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.6875, (double)0.5, (double)0.375, (double)0.9375, (double)0.5625, (double)0.625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.125, (double)0.625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.25, (double)0.5, (double)0.875, (double)0.5, (double)0.5), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeBottomShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeSingleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.3125, (double)0.5, (double)0.3125, (double)0.6875, (double)0.9375, (double)0.6875), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.375, (double)0.4375, (double)0.375, (double)0.625, (double)0.5, (double)0.625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.125, (double)0.625), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeMiddleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (class_247)class_247.field_1366);
        return shape;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.method_11654(TYPE));
        if ((Integer)state.method_11654((class_2769)BULBS) == 1) {
            return DOUBLE_SHAPE.get(direction);
        }
        return switch (type) {
            case FurnitureUtil.VerticalConnectingType.MIDDLE -> MIDDLE_SHAPE.get(direction);
            case FurnitureUtil.VerticalConnectingType.BOTTOM -> BOTTOM_SHAPE.get(direction);
            default -> SINGLE_SHAPE.get(direction);
        };
    }

    public boolean method_9616(class_2680 state, class_1750 useContext) {
        return useContext.method_8046() && useContext.method_8041().method_31574(this.method_8389()) && (Integer)state.method_11654((class_2769)BULBS) < 1 || super.method_9616(state, useContext);
    }

    public static boolean canProvideLight(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LIT) != false && (state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.TOP || state.method_11654(TYPE) == FurnitureUtil.VerticalConnectingType.NONE);
    }

    public static int vanillaLightLevel(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LIT) != false ? 15 : 0;
    }
}

