/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block.entity;

import com.berksire.furniture.registry.EntityTypeRegistry;
import com.berksire.furniture.registry.ObjectRegistry;
import com.berksire.furniture.registry.SoundRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2387;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2770;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3829;
import net.minecraft.class_5712;

public class GramophoneBlockEntity
extends class_2586
implements class_3829 {
    private class_1799 recordItem = class_1799.field_8037;
    private long tickCount;
    private long recordStartedTick;
    private boolean isPlaying;
    private boolean repeat;

    public GramophoneBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)EntityTypeRegistry.GRAMOPHONE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("RecordItem")) {
            this.recordItem = class_1799.method_7915((class_2487)tag.method_10562("RecordItem"));
        }
        this.isPlaying = tag.method_10577("IsPlaying");
        this.recordStartedTick = tag.method_10537("RecordStartTick");
        this.tickCount = tag.method_10537("TickCount");
        this.repeat = tag.method_10577("Repeat");
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (!this.recordItem.method_7960()) {
            tag.method_10566("RecordItem", (class_2520)this.recordItem.method_7953(new class_2487()));
        }
        tag.method_10556("IsPlaying", this.isPlaying);
        tag.method_10544("RecordStartTick", this.recordStartedTick);
        tag.method_10544("TickCount", this.tickCount);
        tag.method_10556("Repeat", this.repeat);
    }

    public boolean isRecordPlaying() {
        return !this.recordItem.method_7960() && this.isPlaying && (Boolean)this.method_11010().method_11654((class_2769)class_2387.field_11180) != false;
    }

    private void startPlaying() {
        this.recordStartedTick = this.tickCount;
        this.isPlaying = true;
        assert (this.field_11863 != null);
        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
        this.field_11863.method_8444(null, 1010, this.field_11867, class_1792.method_7880((class_1792)this.recordItem.method_7909()));
        this.method_5431();
    }

    public static void playRecordTick(class_1937 level, class_2338 pos, class_2680 state, GramophoneBlockEntity blockEntity) {
        blockEntity.tick(level, pos, state);
    }

    public void tick(class_1937 level, class_2338 pos, class_2680 state) {
        class_1799 item;
        class_1792 class_17922;
        if (this.isRecordPlaying() && (class_17922 = (item = this.recordItem).method_7909()) instanceof class_1813) {
            class_1813 recordItem = (class_1813)class_17922;
            if (this.tickCount >= this.recordStartedTick + (long)recordItem.method_44369() + 20L) {
                if (this.repeat) {
                    this.startPlaying();
                } else {
                    this.stopPlaying();
                }
            } else if (this.tickCount % 20L == 0L) {
                level.method_43276(class_5712.field_39485, pos, class_5712.class_7397.method_43287((class_2680)state));
                this.spawnMusicParticles(level, pos);
            }
        }
        ++this.tickCount;
    }

    private void spawnMusicParticles(class_1937 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_243 vec3 = class_243.method_24955((class_2382)pos).method_1031(-0.25, 2.0, -0.25);
            float f = (float)level.method_8409().method_43048(4) / 24.0f;
            serverLevel.method_14199((class_2394)class_2398.field_11224, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), 0, (double)f, 0.0, 0.0, 1.0);
        }
    }

    public void popOutRecord() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            class_2338 blockPos = this.method_11016();
            class_1799 itemStack = this.recordItem;
            if (!itemStack.method_7960()) {
                System.out.println("Popping out record: " + itemStack);
                this.recordItem = class_1799.field_8037;
                this.stopPlaying();
                class_243 vec3 = class_243.method_49273((class_2382)blockPos, (double)0.5, (double)1.01, (double)0.5).method_49272(this.field_11863.field_9229, 0.7f);
                class_1542 itemEntity = new class_1542(this.field_11863, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), itemStack.method_7972());
                itemEntity.method_6988();
                this.field_11863.method_8649((class_1297)itemEntity);
                this.method_5431();
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                if (this.field_11863.method_8320(this.field_11867).method_27852(class_2246.field_10124)) {
                    return;
                }
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(false)), 3);
                this.field_11863.method_8452(this.field_11867, state.method_26204());
            }
        }
    }

    public void method_11012() {
        this.stopPlaying();
        super.method_11012();
    }

    public void setRecord(class_1799 record) {
        this.recordItem = record;
        this.setHasRecordBlockState(true);
        this.startPlaying();
        this.method_5431();
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
        this.method_5431();
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    private void setHasRecordBlockState(boolean hasRecord) {
        if (this.field_11863 != null && !this.field_11863.method_8320(this.field_11867).method_27852(class_2246.field_10124)) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(hasRecord)), 3);
            this.field_11863.method_8452(this.field_11867, state.method_26204());
        }
    }

    public void stopPlaying() {
        if (this.isPlaying) {
            this.isPlaying = false;
            assert (this.field_11863 != null);
            if (!(this.field_11863.field_9236 || this.recordItem.method_7960() || this.recordItem.method_7909() != ObjectRegistry.CPHS_PRIDE.get() && this.recordItem.method_7909() != ObjectRegistry.LETSDO_THEME.get())) {
                ((class_3218)this.field_11863).method_18766(player -> player.method_5649((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260()) < 64.0).forEach(player -> {
                    for (class_3419 source : class_3419.values()) {
                        player.field_13987.method_14364((class_2596)new class_2770(((class_3414)SoundRegistry.CPHS_PRIDE.get()).method_14833(), source));
                        player.field_13987.method_14364((class_2596)new class_2770(((class_3414)SoundRegistry.LETSDO_THEME.get()).method_14833(), source));
                    }
                });
            }
            this.field_11863.method_43276(class_5712.field_39486, this.field_11867, class_5712.class_7397.method_43287((class_2680)this.method_11010()));
            this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
            this.field_11863.method_20290(1011, this.field_11867, 0);
            this.method_5431();
        }
    }

    public void method_5448() {
        this.recordItem = class_1799.field_8037;
        this.setHasRecordBlockState(false);
        this.stopPlaying();
    }

    public class_1799 getFirstItem() {
        return this.recordItem;
    }
}

