/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client;

import com.berksire.furniture.client.model.ClockModel;
import com.berksire.furniture.client.model.FishTankModel;
import com.berksire.furniture.client.model.GramophoneModel;
import com.berksire.furniture.client.model.GrandfatherClockModel;
import com.berksire.furniture.client.render.CanvasRenderer;
import com.berksire.furniture.client.render.ChairRenderer;
import com.berksire.furniture.client.render.ClockRenderer;
import com.berksire.furniture.client.render.CofferRenderer;
import com.berksire.furniture.client.render.DisplayRenderer;
import com.berksire.furniture.client.render.FishTankRenderer;
import com.berksire.furniture.client.render.GramophoneRenderer;
import com.berksire.furniture.client.render.GrandfatherClockRenderer;
import com.berksire.furniture.client.render.PellsRenderer;
import com.berksire.furniture.registry.EntityTypeRegistry;
import com.berksire.furniture.registry.ObjectRegistry;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_5601;

@Environment(value=EnvType.CLIENT)
public class FurnitureClient {
    public static void onInitializeClient() {
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.BIN.get(), (class_2248)ObjectRegistry.GRAMOPHONE.get(), (class_2248)ObjectRegistry.CASH_REGISTER.get(), (class_2248)ObjectRegistry.BOAT_IN_A_JAR.get(), (class_2248)ObjectRegistry.STREET_LANTERN.get(), (class_2248)ObjectRegistry.STREET_WALL_LANTERN.get(), (class_2248)ObjectRegistry.PLATED_STREET_LANTERN.get(), (class_2248)ObjectRegistry.PLATED_STREET_WALL_LANTERN.get(), (class_2248)ObjectRegistry.DISPLAY.get(), (class_2248)ObjectRegistry.TERRARIUM.get()});
        for (RegistrySupplier<class_2248> block : Stream.concat(Stream.concat(ObjectRegistry.LAMPS.values().stream(), ObjectRegistry.WALL_LAMPS.values().stream()), Stream.concat(ObjectRegistry.BENCHES.values().stream(), Stream.concat(ObjectRegistry.DESKS.values().stream(), ObjectRegistry.DESK_CHAIRS.values().stream()))).toList()) {
            RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)block.get()});
        }
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.GRANDFATHER_CLOCK_BLOCK_ENTITY.get()), GrandfatherClockRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.CLOCK_BLOCK_ENTITY.get()), ClockRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.GRAMOPHONE_BLOCK_ENTITY.get()), GramophoneRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.COFFER_BLOCK_ENTITY.get()), CofferRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.DISPLAY_BLOCK_ENTITY.get()), context -> new DisplayRenderer());
    }

    public static void preInitClient() {
        FurnitureClient.registerEntityModelLayer();
        FurnitureClient.registerEntityRenderers();
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.CHAIR, ChairRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.CANVAS, CanvasRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.PELLS, PellsRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.FAKE_FISH_TANK, FishTankRenderer::new);
    }

    public static void registerEntityModelLayer() {
        EntityModelLayerRegistry.register((class_5601)GrandfatherClockModel.LAYER_LOCATION, GrandfatherClockModel::getTexturedModelData);
        EntityModelLayerRegistry.register((class_5601)ClockModel.LAYER_LOCATION, ClockModel::getTexturedModelData);
        EntityModelLayerRegistry.register((class_5601)GramophoneModel.LAYER_LOCATION, GramophoneModel::getTexturedModelData);
        EntityModelLayerRegistry.register((class_5601)FishTankModel.LAYER_LOCATION, FishTankModel::getTexturedModelData);
        EntityModelLayerRegistry.register((class_5601)CofferRenderer.LAYER_LOCATION, CofferRenderer::getTexturedModelData);
    }
}

