/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.block.ClockBlock;
import com.berksire.furniture.block.entity.ClockBlockEntity;
import com.berksire.furniture.client.model.ClockModel;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_827;
import org.joml.Quaternionf;

public class ClockRenderer
implements class_827<ClockBlockEntity> {
    private static final Map<ClockBlock.WoodType, class_2960> TEXTURES = new EnumMap<ClockBlock.WoodType, class_2960>(ClockBlock.WoodType.class);
    private final ClockModel<class_1297> model;

    public ClockRenderer(class_5614.class_5615 context) {
        class_630 root = context.method_32140(ClockModel.LAYER_LOCATION);
        this.model = new ClockModel(root);
    }

    public void render(ClockBlockEntity blockEntity, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int combinedLight, int combinedOverlay) {
        long gameTime = Objects.requireNonNull(blockEntity.method_10997()).method_8532() % 24000L;
        int hours = (int)((gameTime / 1000L + 6L) % 24L);
        int minutes = (int)(gameTime % 1000L * 60L / 1000L);
        this.model.minutes.field_3674 = (float)((double)minutes * Math.PI / 30.0);
        this.model.hours.field_3674 = (float)((double)hours * Math.PI / 6.0);
        class_2680 blockstate = blockEntity.method_11010();
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22907(new Quaternionf().rotateZ((float)Math.toRadians(180.0)));
        class_2350 direction = (class_2350)blockstate.method_11654((class_2769)class_2741.field_12481);
        float rotation = direction.method_10153().method_10144();
        poseStack.method_22907(new Quaternionf().rotateYXZ((float)Math.toRadians(rotation), 0.0f, 0.0f));
        ClockBlock block = (ClockBlock)blockEntity.method_11010().method_26204();
        ClockBlock.WoodType woodType = block.getWoodType();
        class_2960 texture = TEXTURES.get((Object)woodType);
        this.renderModel(poseStack, bufferSource.getBuffer(class_1921.method_23576((class_2960)texture)), combinedLight, combinedOverlay);
        poseStack.method_22909();
    }

    private void renderModel(class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay) {
        this.model.method_2828(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    static {
        TEXTURES.put(ClockBlock.WoodType.OAK, new class_2960("furniture", "textures/entity/oak_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.SPRUCE, new class_2960("furniture", "textures/entity/spruce_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.BIRCH, new class_2960("furniture", "textures/entity/birch_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.JUNGLE, new class_2960("furniture", "textures/entity/jungle_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.ACACIA, new class_2960("furniture", "textures/entity/acacia_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.DARK_OAK, new class_2960("furniture", "textures/entity/dark_oak_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.MANGROVE, new class_2960("furniture", "textures/entity/mangrove_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.CHERRY, new class_2960("furniture", "textures/entity/cherry_clock.png"));
    }
}

