/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.block.FishTankBlock;
import com.berksire.furniture.block.entity.FishTankBlockEntity;
import com.berksire.furniture.client.entity.FakeFishTankEntity;
import com.berksire.furniture.client.model.FishTankModel;
import com.berksire.furniture.client.render.FluidRenderer;
import com.berksire.furniture.registry.ObjectRegistry;
import dev.architectury.fluid.FluidStack;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Quaternionf;

public class FishTankRenderer
extends class_897<FakeFishTankEntity> {
    private final FishTankModel model;
    private static final class_2960 NORMAL_TEXTURE = new class_2960("furniture", "textures/entity/copper_fish_tank.png");
    private static final class_2960 IRON_TEXTURE = new class_2960("furniture", "textures/entity/iron_fish_tank.png");

    public FishTankRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new FishTankModel(context.method_32167(FishTankModel.LAYER_LOCATION));
    }

    private static boolean assertNonNullOrPop(Object nullable, class_4587 stack) {
        if (nullable == null) {
            stack.method_22909();
            return true;
        }
        return false;
    }

    public void render(FakeFishTankEntity entity, float f, float g, class_4587 poseStack, class_4597 bufferSource, int combinedLight) {
        poseStack.method_22903();
        FishTankBlockEntity blockEntity = entity.getNearestTankEntity().orElse(null);
        if (FishTankRenderer.assertNonNullOrPop((Object)blockEntity, poseStack)) {
            return;
        }
        assert (blockEntity != null);
        class_2350 direction = (class_2350)blockEntity.method_11010().method_11654((class_2769)FishTankBlock.FACING);
        float rotation = -direction.method_10144();
        Quaternionf theGreatRotator = new Quaternionf().rotateY((float)Math.toRadians(rotation));
        poseStack.method_22907(theGreatRotator);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        class_2960 texture = blockEntity.method_11010().method_26204() == ObjectRegistry.IRON_FISH_TANK.get() ? IRON_TEXTURE : NORMAL_TEXTURE;
        class_4588 vertexConsumer = bufferSource.getBuffer(this.model.method_23500(texture));
        class_638 world = class_310.method_1551().field_1687;
        if (FishTankRenderer.assertNonNullOrPop(world, poseStack)) {
            return;
        }
        assert (world != null);
        float renderTick = (float)(world.method_8510() % 24000L) + class_310.method_1551().method_1488();
        this.model.setupAnim(entity, f, g, renderTick, 0.0f, 0.0f);
        if (((Boolean)blockEntity.method_11010().method_11654((class_2769)FishTankBlock.HAS_COD)).booleanValue()) {
            this.model.cod_1.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            this.model.cod_2.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            this.model.cod_3.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            this.model.cod_4.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (((Boolean)blockEntity.method_11010().method_11654((class_2769)FishTankBlock.HAS_PUFFERFISH)).booleanValue()) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, -0.6, 0.0);
            this.model.pufferfish_1.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_22904(0.9, -0.8, 0.1);
            this.model.pufferfish_2.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
        }
        if (((Boolean)blockEntity.method_11010().method_11654((class_2769)FishTankBlock.HAS_SALMON)).booleanValue()) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.0, 0.05);
            this.model.salmon_1.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
            this.model.salmon_2.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.model.tank.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        this.model.decoration.method_22699(poseStack, vertexConsumer, combinedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_22907(theGreatRotator);
        poseStack.method_22907(new Quaternionf().rotateY((float)Math.toRadians(90.0)));
        poseStack.method_22904(-0.5, 0.0, -0.5);
        FluidRenderer.renderFluidBox(FluidStack.create((class_3611)class_3612.field_15910, (long)100L), 0.0703125f, 0.125f, 0.0703125f, 0.9296875f, 0.85f, 1.9296875f, bufferSource, poseStack, combinedLight, false);
        poseStack.method_22909();
    }

    public class_2960 getTextureLocation(FakeFishTankEntity entity) {
        return null;
    }
}

