/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.block.GrandfatherClockBlock;
import com.berksire.furniture.block.entity.GrandfatherClockBlockEntity;
import com.berksire.furniture.client.model.GrandfatherClockModel;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_827;
import org.joml.Quaternionf;

public class GrandfatherClockRenderer
implements class_827<GrandfatherClockBlockEntity> {
    private static final Map<GrandfatherClockBlock.WoodType, class_2960> TEXTURES = new EnumMap<GrandfatherClockBlock.WoodType, class_2960>(GrandfatherClockBlock.WoodType.class);
    private final GrandfatherClockModel<class_1297> model;

    public GrandfatherClockRenderer(class_5614.class_5615 context) {
        class_630 root = context.method_32140(GrandfatherClockModel.LAYER_LOCATION);
        this.model = new GrandfatherClockModel(root);
    }

    public void render(GrandfatherClockBlockEntity blockEntity, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int combinedLight, int combinedOverlay) {
        class_2680 blockstate = blockEntity.method_11010();
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        class_2350 direction = (class_2350)blockstate.method_11654((class_2769)class_2741.field_12481);
        float rotation = direction.method_10153().method_10144();
        poseStack.method_22907(new Quaternionf().rotateYXZ((float)Math.toRadians(rotation), 0.0f, 0.0f));
        long totalTime = System.currentTimeMillis();
        float smoothTime = (float)(totalTime % 60000L) / 50.0f;
        this.model.pendulum.field_3674 = (float)Math.sin((double)smoothTime * Math.PI / 30.0) * 0.15f;
        long gameTime = Objects.requireNonNull(blockEntity.method_10997()).method_8532() % 24000L;
        int hours = (int)((gameTime / 1000L + 6L) % 24L);
        int minutes = (int)(gameTime % 1000L * 60L / 1000L);
        this.model.minutes.field_3674 = (float)((double)minutes * Math.PI / 30.0);
        this.model.hours.field_3674 = (float)((double)hours * Math.PI / 6.0);
        GrandfatherClockBlock.WoodType woodType = ((GrandfatherClockBlock)blockstate.method_26204()).getWoodType();
        class_2960 texture = TEXTURES.get((Object)woodType);
        if (texture == null) {
            texture = TEXTURES.get((Object)GrandfatherClockBlock.WoodType.OAK);
        }
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23576((class_2960)texture));
        this.model.method_2828(poseStack, vertexConsumer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
    }

    static {
        TEXTURES.put(GrandfatherClockBlock.WoodType.OAK, new class_2960("furniture", "textures/entity/oak_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.SPRUCE, new class_2960("furniture", "textures/entity/spruce_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.BIRCH, new class_2960("furniture", "textures/entity/birch_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.JUNGLE, new class_2960("furniture", "textures/entity/jungle_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.ACACIA, new class_2960("furniture", "textures/entity/acacia_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.DARK_OAK, new class_2960("furniture", "textures/entity/dark_oak_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.MANGROVE, new class_2960("furniture", "textures/entity/mangrove_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.CHERRY, new class_2960("furniture", "textures/entity/cherry_grandfatherclock.png"));
    }
}

