/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.client.entity.PellsEntity;
import com.berksire.furniture.client.model.PellsModel;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.class_1308;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PellsRenderer
extends class_927<PellsEntity, PellsModel<PellsEntity>> {
    protected static final class_2960 TEXTURE = new class_2960("furniture", "textures/entity/pells.png");
    private static final DecimalFormat FORMAT = new DecimalFormat("###.##", new DecimalFormatSymbols(Locale.GERMAN));

    public PellsRenderer(class_5617.class_5618 context) {
        super(context, new PellsModel(PellsModel.createBodyLayer().method_32109()), 0.0f);
    }

    @NotNull
    public class_2960 getTextureLocation(PellsEntity entity) {
        return TEXTURE;
    }

    public void render(PellsEntity entityIn, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferIn, int packedLightIn) {
        super.method_4072((class_1308)entityIn, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        float lastDamage = entityIn.getLastDamage();
        if (lastDamage > 0.0f) {
            Color color = this.getColorByDamage(lastDamage);
            this.renderText(entityIn, FORMAT.format(lastDamage), stack, bufferIn, packedLightIn, color);
        }
    }

    private Color getColorByDamage(float damage) {
        if (damage >= 0.0f && damage <= 2.0f) {
            return Color.GREEN;
        }
        if (damage >= 3.0f && damage <= 6.0f) {
            return Color.WHITE;
        }
        if (damage >= 7.0f && damage <= 12.0f) {
            return Color.YELLOW;
        }
        if (damage >= 13.0f && damage <= 19.0f) {
            return Color.ORANGE;
        }
        return Color.RED;
    }

    protected void renderText(PellsEntity entityIn, String text, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, Color textColor) {
        if (entityIn.field_6235 > 0) {
            float partialTicks = class_310.method_1551().method_1488();
            class_5250 component = class_2561.method_43470((String)text);
            entityIn.lastDamageOffsetPrev = entityIn.lastDamageOffset = class_3532.method_16439((float)partialTicks, (float)entityIn.lastDamageOffsetPrev, (float)((float)Math.abs(Math.sin((float)entityIn.field_6235 / 4.0f))));
            float alpha = entityIn.lastDamageOffset;
            matrixStackIn.method_22903();
            matrixStackIn.method_22904(0.0, (double)(entityIn.method_17682() + entityIn.lastDamageOffset), 0.0);
            matrixStackIn.method_22907(this.field_4676.method_24197());
            matrixStackIn.method_22905(-entityIn.lastDamageOffset / 20.0f, -entityIn.lastDamageOffset / 20.0f, entityIn.lastDamageOffset / 20.0f);
            Matrix4f matrix4f = matrixStackIn.method_23760().method_23761();
            class_327 font = this.method_3932();
            Color color = new Color((float)textColor.getRed() / 255.0f, (float)textColor.getGreen() / 255.0f, (float)textColor.getBlue() / 255.0f, alpha);
            font.method_30882((class_2561)component, (float)(-font.method_27525((class_5348)component) / 2) * entityIn.lastDamageOffset, entityIn.lastDamageOffset, color.getRGB(), false, matrix4f, bufferIn, class_327.class_6415.field_33993, 0, packedLightIn);
            matrixStackIn.method_22909();
        }
    }
}

