/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.util;

import com.berksire.furniture.client.entity.ChairEntity;
import com.berksire.furniture.registry.EntityTypeRegistry;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class FurnitureUtil {
    private static final Map<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>> CHAIRS = new HashMap<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>>();
    public static final class_2754<LineConnectingType> LINE_CONNECTING_TYPE = class_2754.method_11850((String)"type", LineConnectingType.class);

    public static <T extends class_2248> RegistrySupplier<T> registerWithItem(DeferredRegister<class_2248> registerB, Registrar<class_2248> registrarB, DeferredRegister<class_1792> registerI, Registrar<class_1792> registrarI, class_2960 name, Supplier<T> block) {
        RegistrySupplier toReturn = FurnitureUtil.registerWithoutItem(registerB, registrarB, name, block);
        FurnitureUtil.registerItem(registerI, registrarI, name, () -> new class_1747((class_2248)toReturn.get(), new class_1792.class_1793()));
        return toReturn;
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithoutItem(DeferredRegister<class_2248> register, Registrar<class_2248> registrar, class_2960 path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.method_12832(), block) : registrar.register(path, block);
    }

    public static <T extends class_1792> RegistrySupplier<T> registerItem(DeferredRegister<class_1792> register, Registrar<class_1792> registrar, class_2960 path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.method_12832(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1082((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (class_247)class_247.field_1366);
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    public static class_1269 onUse(class_1937 world, class_1657 player, class_1268 hand, class_3965 hit, double extraHeight) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (player.method_5715()) {
            return class_1269.field_5811;
        }
        if (FurnitureUtil.isPlayerSitting(player)) {
            return class_1269.field_5811;
        }
        if (hit.method_17780() == class_2350.field_11033) {
            return class_1269.field_5811;
        }
        class_2338 hitPos = hit.method_17777();
        if (!FurnitureUtil.isOccupied(world, hitPos) && player.method_5998(hand).method_7960()) {
            ChairEntity chair = (ChairEntity)((class_1299)EntityTypeRegistry.CHAIR.get()).method_5883(world);
            assert (chair != null);
            chair.method_5808((double)hitPos.method_10263() + 0.5, (double)hitPos.method_10264() + 0.25 + extraHeight, (double)hitPos.method_10260() + 0.5, 0.0f, 0.0f);
            if (FurnitureUtil.addChairEntity(world, hitPos, chair, player.method_24515())) {
                world.method_8649((class_1297)chair);
                player.method_5804((class_1297)chair);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static void onStateReplaced(class_1937 world, class_2338 pos) {
        ChairEntity entity;
        if (!world.field_9236 && (entity = FurnitureUtil.getChairEntity(world, pos)) != null) {
            FurnitureUtil.removeChairEntity(world, pos);
            entity.method_5772();
        }
    }

    public static boolean addChairEntity(class_1937 world, class_2338 blockPos, ChairEntity entity, class_2338 playerPos) {
        if (!world.field_9236) {
            class_2960 id = FurnitureUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, class_2338>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static void removeChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.field_9236 && CHAIRS.containsKey(id = FurnitureUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
        }
    }

    public static ChairEntity getChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.method_8608() && CHAIRS.containsKey(id = FurnitureUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static class_2338 getPreviousPlayerPosition(class_1657 player, ChairEntity chairEntity) {
        class_2960 id;
        if (!player.method_37908().method_8608() && CHAIRS.containsKey(id = FurnitureUtil.getDimensionTypeId(player.method_37908()))) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (class_2338)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(class_1937 world, class_2338 pos) {
        class_2960 id = FurnitureUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(class_1657 player) {
        for (class_2960 i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).method_5626((class_1297)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static class_2960 getDimensionTypeId(class_1937 world) {
        return world.method_44013().method_29177();
    }

    public static enum LineConnectingType implements class_3542
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }

    public static enum SmokeType implements class_3542
    {
        HEAVY_SMOKE("heavy_smoke"),
        SMOKE("smoke"),
        NO_SMOKE("no_smoke");

        private final String name;

        private SmokeType(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public SmokeType getNext() {
            return switch (this) {
                case HEAVY_SMOKE -> SMOKE;
                case SMOKE -> NO_SMOKE;
                default -> HEAVY_SMOKE;
            };
        }

        public String getTranslationKey() {
            return "tooltip.furniture.smoke_type." + this.name;
        }
    }

    public static enum VerticalConnectingType implements class_3542
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom"),
        NONE("none");

        private final String name;
        public static final class_2754<VerticalConnectingType> VERTICAL_CONNECTING_TYPE;

        private VerticalConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        static {
            VERTICAL_CONNECTING_TYPE = class_2754.method_11850((String)"type", VerticalConnectingType.class);
        }
    }
}

