/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import satisfy.herbalbrews.HerbalBrews;
import satisfy.herbalbrews.effects.ArmorEffect;
import satisfy.herbalbrews.effects.BalancedEffect;
import satisfy.herbalbrews.effects.DamageEffect;
import satisfy.herbalbrews.effects.ExcavationEffect;
import satisfy.herbalbrews.effects.FeralEffect;
import satisfy.herbalbrews.effects.FortuneEffect;
import satisfy.herbalbrews.effects.PoisonousbreathEffect;
import satisfy.herbalbrews.effects.RenewalEffect;
import satisfy.herbalbrews.effects.RevitalizingEffect;
import satisfy.herbalbrews.effects.ToughEffect;
import satisfy.herbalbrews.util.HerbalBrewsIdentifier;

public class EffectRegistry {
    private static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"herbalbrews", (class_5321)class_7924.field_41208);
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<class_1291> BALANCED;
    public static final RegistrySupplier<class_1291> FERAL;
    public static final RegistrySupplier<class_1291> ARMOR;
    public static final RegistrySupplier<class_1291> DAMAGE;
    public static final RegistrySupplier<class_1291> FORTUNE;
    public static final RegistrySupplier<class_1291> EXCAVATION;
    public static final RegistrySupplier<class_1291> POISONOUSBREATH;
    public static final RegistrySupplier<class_1291> RENEWAL;
    public static final RegistrySupplier<class_1291> REVITALIZING;
    public static final RegistrySupplier<class_1291> TOUGH;

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new HerbalBrewsIdentifier(name), effect);
    }

    public static void init() {
        HerbalBrews.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        RENEWAL = EffectRegistry.registerEffect("renewal", RenewalEffect::new);
        BALANCED = EffectRegistry.registerEffect("balanced", BalancedEffect::new);
        FORTUNE = EffectRegistry.registerEffect("fortune", FortuneEffect::new);
        FERAL = EffectRegistry.registerEffect("feral", FeralEffect::new);
        ARMOR = EffectRegistry.registerEffect("armor", ArmorEffect::new);
        DAMAGE = EffectRegistry.registerEffect("damage", DamageEffect::new);
        EXCAVATION = EffectRegistry.registerEffect("excavation", ExcavationEffect::new);
        TOUGH = EffectRegistry.registerEffect("tough", ToughEffect::new);
        REVITALIZING = EffectRegistry.registerEffect("revitalizing", RevitalizingEffect::new);
        POISONOUSBREATH = EffectRegistry.registerEffect("poisonous", PoisonousbreathEffect::new);
    }
}

