/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.registry;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.Util;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7696;
import net.minecraft.class_7924;
import net.minecraft.class_8177;
import satisfy.herbalbrews.blocks.BonemealableFlower;
import satisfy.herbalbrews.blocks.CauldronBlock;
import satisfy.herbalbrews.blocks.CoffeeCropBlock;
import satisfy.herbalbrews.blocks.JugBlock;
import satisfy.herbalbrews.blocks.RooibosCropBlock;
import satisfy.herbalbrews.blocks.StoveBlock;
import satisfy.herbalbrews.blocks.TeaCropBlock;
import satisfy.herbalbrews.blocks.TeaCupBlock;
import satisfy.herbalbrews.blocks.TeaKettleBlock;
import satisfy.herbalbrews.blocks.TeaLeafBlock;
import satisfy.herbalbrews.blocks.YerbaMateCropBlock;
import satisfy.herbalbrews.items.DrinkBlockItem;
import satisfy.herbalbrews.items.DrinkItem;
import satisfy.herbalbrews.items.HatItem;
import satisfy.herbalbrews.items.HerbalbrewsStandardItem;
import satisfy.herbalbrews.items.JugItem;
import satisfy.herbalbrews.registry.EffectRegistry;
import satisfy.herbalbrews.util.FoodComponent;
import satisfy.herbalbrews.util.HerbalBrewsIdentifier;

public class ObjectRegistry {
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"herbalbrews", (class_5321)class_7924.field_41197);
    public static final Registrar<class_1792> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"herbalbrews", (class_5321)class_7924.field_41254);
    public static final Registrar<class_2248> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<class_2248> STOVE = ObjectRegistry.registerWithItem("stove", () -> new StoveBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10104).method_9631(state -> (Boolean)state.method_11654((class_2769)StoveBlock.LIT) != false ? 13 : 0).method_9640()));
    public static final RegistrySupplier<class_2248> TEA_LEAF_CRATE = ObjectRegistry.registerWithItem("tea_leaf_crate", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_10314)));
    public static final RegistrySupplier<class_2248> GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("green_tea_leaf_block", () -> new TeaLeafBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10098)));
    public static final RegistrySupplier<class_2248> DRIED_GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("dried_green_tea_leaf_block", () -> new TeaLeafBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10098)));
    public static final RegistrySupplier<class_2248> DRIED_OUT_GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("dried_out_green_tea_leaf_block", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_10098)));
    public static final RegistrySupplier<class_2248> BLACK_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("black_tea_leaf_block", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_10098)));
    public static final RegistrySupplier<class_2248> MIXED_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("mixed_tea_leaf_block", () -> new TeaLeafBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10098)));
    public static final RegistrySupplier<class_2248> OOLONG_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("oolong_tea_leaf_block", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_10098)));
    public static final RegistrySupplier<class_2248> WILD_COFFEE_PLANT = ObjectRegistry.registerWithItem("wild_coffee_plant", () -> new class_2356(class_1294.field_5915, 1, class_4970.class_2251.method_9630((class_4970)class_2246.field_10182)));
    public static final RegistrySupplier<class_2248> COFFEE_PLANT = ObjectRegistry.registerWithoutItem("coffee_plant", () -> new CoffeeCropBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16999)));
    public static final RegistrySupplier<class_2248> WILD_ROOIBOS_PLANT = ObjectRegistry.registerWithItem("wild_rooibos_plant", () -> new class_2356(class_1294.field_5915, 1, class_4970.class_2251.method_9630((class_4970)class_2246.field_10182)));
    public static final RegistrySupplier<class_2248> ROOIBOS_PLANT = ObjectRegistry.registerWithoutItem("rooibos_plant", () -> new RooibosCropBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16999)));
    public static final RegistrySupplier<class_2248> WILD_YERBA_MATE_PLANT = ObjectRegistry.registerWithItem("wild_yerba_mate_plant", () -> new class_2356(class_1294.field_5915, 1, class_4970.class_2251.method_9630((class_4970)class_2246.field_10182)));
    public static final RegistrySupplier<class_2248> YERBA_MATE_PLANT = ObjectRegistry.registerWithoutItem("yerba_mate_plant", () -> new YerbaMateCropBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16999)));
    public static final RegistrySupplier<class_2248> TEA_PLANT = ObjectRegistry.registerWithoutItem("tea_plant", () -> new TeaCropBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16999)));
    public static final RegistrySupplier<class_2248> HIBISCUS = ObjectRegistry.registerWithItem("hibiscus", () -> new BonemealableFlower(class_1294.field_5915, 1, class_4970.class_2251.method_9630((class_4970)class_2246.field_10182)));
    public static final RegistrySupplier<class_2248> LAVENDER = ObjectRegistry.registerWithItem("lavender", () -> new BonemealableFlower(class_1294.field_5915, 1, class_4970.class_2251.method_9630((class_4970)class_2246.field_10182)));
    public static final RegistrySupplier<class_2248> JUG = ObjectRegistry.registerWithoutItem("jug", () -> new JugBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10033)));
    public static final RegistrySupplier<class_1792> JUG_ITEM = ObjectRegistry.registerItem("jug", () -> new JugItem((class_2248)JUG.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_2248> COPPER_TEA_KETTLE = ObjectRegistry.registerWithItem("copper_tea_kettle", () -> new TeaKettleBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10085)));
    public static final RegistrySupplier<class_2248> TEA_KETTLE = ObjectRegistry.registerWithItem("tea_kettle", () -> new TeaKettleBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10085)));
    public static final RegistrySupplier<class_2248> CAULDRON = ObjectRegistry.registerWithItem("cauldron", () -> new CauldronBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10085).method_9631(blockState -> 11)));
    public static final RegistrySupplier<class_1792> ARMOR_FLASK = ObjectRegistry.registerItem("armor_flask", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (class_1291)EffectRegistry.ARMOR.get(), 6000)));
    public static final RegistrySupplier<class_1792> ARMOR_FLASK_BIG = ObjectRegistry.registerItem("armor_flask_big", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (class_1291)EffectRegistry.ARMOR.get(), 12000)));
    public static final RegistrySupplier<class_1792> DAMAGE_FLASK = ObjectRegistry.registerItem("damage_flask", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (class_1291)EffectRegistry.DAMAGE.get(), 6000)));
    public static final RegistrySupplier<class_1792> DAMAGE_FLASK_BIG = ObjectRegistry.registerItem("damage_flask_big", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (class_1291)EffectRegistry.DAMAGE.get(), 12000)));
    public static final RegistrySupplier<class_1792> FERAL_FLASK = ObjectRegistry.registerItem("feral_flask", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (class_1291)EffectRegistry.FERAL.get(), 6000)));
    public static final RegistrySupplier<class_1792> FERAL_FLASK_BIG = ObjectRegistry.registerItem("feral_flask_big", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (class_1291)EffectRegistry.FERAL.get(), 12000)));
    public static final RegistrySupplier<class_1792> TEA_BLOSSOM = ObjectRegistry.registerItem("tea_blossom", () -> new class_1747((class_2248)TEA_PLANT.get(), ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(1).method_19237(0.1f).method_19241().method_19240().method_19242())));
    public static final RegistrySupplier<class_1792> GREEN_TEA_LEAF = ObjectRegistry.registerItem("green_tea_leaf", () -> new class_1792(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_1792> YERBA_MATE_LEAF = ObjectRegistry.registerItem("yerba_mate_leaf", () -> new class_1747((class_2248)YERBA_MATE_PLANT.get(), ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(1).method_19237(0.1f).method_19241().method_19240().method_19242())));
    public static final RegistrySupplier<class_1792> ROOIBOS_LEAF = ObjectRegistry.registerItem("rooibos_leaf", () -> new class_1747((class_2248)ROOIBOS_PLANT.get(), ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(1).method_19237(0.1f).method_19241().method_19240().method_19242())));
    public static final RegistrySupplier<class_1792> LAVENDER_BLOSSOM = ObjectRegistry.registerItem("lavender_blossom", () -> new class_1792(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_1792> DRIED_GREEN_TEA = ObjectRegistry.registerItem("dried_green_tea", () -> new class_1792(ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(1).method_19237(0.1f).method_19241().method_19240().method_19242())));
    public static final RegistrySupplier<class_1792> DRIED_BLACK_TEA = ObjectRegistry.registerItem("dried_black_tea", () -> new class_1792(ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(1).method_19237(0.1f).method_19241().method_19240().method_19242())));
    public static final RegistrySupplier<class_1792> DRIED_OOLONG_TEA = ObjectRegistry.registerItem("dried_oolong_tea", () -> new class_1792(ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(1).method_19237(0.1f).method_19241().method_19240().method_19242())));
    public static final RegistrySupplier<class_1792> COFFEE_BEANS = ObjectRegistry.registerItem("coffee_beans", () -> new class_1747((class_2248)COFFEE_PLANT.get(), ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(1).method_19237(0.1f).method_19241().method_19240().method_19242())));
    public static final RegistrySupplier<class_1792> GREEN_TEA = ObjectRegistry.registerItem("green_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (class_1291)EffectRegistry.BALANCED.get(), 1800)));
    public static final RegistrySupplier<class_1792> BLACK_TEA = ObjectRegistry.registerItem("black_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (class_1291)EffectRegistry.REVITALIZING.get(), 1800)));
    public static final RegistrySupplier<class_1792> LAVENDER_TEA = ObjectRegistry.registerItem("lavender_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (class_1291)EffectRegistry.FORTUNE.get(), 1800)));
    public static final RegistrySupplier<class_1792> YERBA_MATE_TEA = ObjectRegistry.registerItem("yerba_mate_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (class_1291)EffectRegistry.POISONOUSBREATH.get(), 1800)));
    public static final RegistrySupplier<class_1792> OOLONG_TEA = ObjectRegistry.registerItem("oolong_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (class_1291)EffectRegistry.RENEWAL.get(), 1800)));
    public static final RegistrySupplier<class_1792> ROOIBOS_TEA = ObjectRegistry.registerItem("rooibos_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (class_1291)EffectRegistry.EXCAVATION.get(), 1800)));
    public static final RegistrySupplier<class_2248> HIBISCUS_TEA_BLOCK = ObjectRegistry.registerTea("hibiscus_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()), EffectRegistry.FERAL);
    public static final RegistrySupplier<class_1792> HIBISCUS_TEA = ObjectRegistry.registerItem("hibiscus_tea", () -> new DrinkBlockItem((class_2248)HIBISCUS_TEA_BLOCK.get(), ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(class_4176.field_18636.method_19230()).method_19237(class_4176.field_18636.method_19231()).method_19240().method_19242()), new class_1293((class_1291)EffectRegistry.FERAL.get(), 1800, 0)));
    public static final RegistrySupplier<class_2248> MILK_COFFEE_BLOCK = ObjectRegistry.registerTea("milk_coffee_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()), EffectRegistry.TOUGH);
    public static final RegistrySupplier<class_1792> MILK_COFFEE = ObjectRegistry.registerItem("milk_coffee", () -> new DrinkBlockItem((class_2248)MILK_COFFEE_BLOCK.get(), ObjectRegistry.getSettings().method_19265(new class_4174.class_4175().method_19238(class_4176.field_18636.method_19230()).method_19237(class_4176.field_18636.method_19231()).method_19240().method_19242()), new class_1293((class_1291)EffectRegistry.TOUGH.get(), 1800, 0)));
    public static final RegistrySupplier<class_1792> COFFEE = ObjectRegistry.registerItem("coffee", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (class_1291)EffectRegistry.TOUGH.get(), 1800)));
    public static final RegistrySupplier<class_1792> WITCH_HAT = ObjectRegistry.registerItem("witch_hat", () -> new HatItem((class_1741)class_1740.field_7897, class_1738.class_8051.field_41934, new class_1792.class_1793(), new HerbalBrewsIdentifier("textures/entity/witch_hat.png")));
    public static final RegistrySupplier<class_1792> TOP_HAT = ObjectRegistry.registerItem("top_hat", () -> new HatItem((class_1741)class_1740.field_7897, class_1738.class_8051.field_41934, new class_1792.class_1793(), new HerbalBrewsIdentifier("textures/entity/top_hat.png")));
    public static final RegistrySupplier<class_1792> HERBALBREWS_STANDARD = ObjectRegistry.registerItem("herbalbrews_standard", () -> new HerbalbrewsStandardItem(new class_1792.class_1793().method_7889(16).method_7894(class_1814.field_8907)));
    public static final RegistrySupplier<class_2248> POTTED_LAVENDER = ObjectRegistry.registerWithoutItem("potted_lavender", () -> new class_2362((class_2248)LAVENDER.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10495)));
    public static final RegistrySupplier<class_2248> POTTED_HIBISCUS = ObjectRegistry.registerWithoutItem("potted_hibiscus", () -> new class_2362((class_2248)HIBISCUS.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10495)));
    public static final RegistrySupplier<class_2248> POTTED_WILD_ROOIBOS = ObjectRegistry.registerWithoutItem("potted_wild_rooibos", () -> new class_2362((class_2248)WILD_ROOIBOS_PLANT.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10495)));
    public static final RegistrySupplier<class_2248> POTTED_WILD_COFFEE = ObjectRegistry.registerWithoutItem("potted_wild_coffee", () -> new class_2362((class_2248)WILD_COFFEE_PLANT.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10495)));
    public static final RegistrySupplier<class_2248> POTTED_WILD_YERBA_MATE = ObjectRegistry.registerWithoutItem("potted_wild_yerba_mate", () -> new class_2362((class_2248)WILD_YERBA_MATE_PLANT.get(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10495)));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static class_1792.class_1793 getSettings(Consumer<class_1792.class_1793> consumer) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        consumer.accept(settings);
        return settings;
    }

    private static class_1792.class_1793 getSettingsWithoutTab(Consumer<class_1792.class_1793> consumer) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        consumer.accept(settings);
        return settings;
    }

    static class_1792.class_1793 getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    private static class_1792.class_1793 getWineItemSettings(class_1291 effect) {
        return ObjectRegistry.getSettings().method_19265(ObjectRegistry.wineFoodComponent(effect, 900));
    }

    private static class_1792.class_1793 getWineItemSettings(class_1291 effect, int duration) {
        return ObjectRegistry.getSettings().method_19265(ObjectRegistry.wineFoodComponent(effect, duration));
    }

    private static class_4174 wineFoodComponent(class_1291 effect, int duration) {
        ArrayList effects = Lists.newArrayList();
        if (effect != null) {
            effects.add(Pair.of((Object)new class_1293(effect, duration), (Object)Float.valueOf(1.0f)));
        }
        return new FoodComponent(effects);
    }

    private static class_1792.class_1793 getFoodItemSettings(float saturationMod, class_1291 effect, int duration) {
        return ObjectRegistry.getFoodItemSettings(saturationMod, effect, duration, true);
    }

    private static class_1792.class_1793 getFoodItemSettings(float saturationMod, class_1291 effect, int duration, boolean fast) {
        return ObjectRegistry.getSettings().method_19265(ObjectRegistry.createFood(saturationMod, effect, duration, fast));
    }

    private static class_4174 createFood(float saturationMod, class_1291 effect, int duration, boolean fast) {
        class_4174.class_4175 food = new class_4174.class_4175().method_19238(4).method_19237(saturationMod);
        food.method_19240();
        if (fast) {
            food.method_19241();
        }
        if (effect != null) {
            food.method_19239(new class_1293(effect, duration), 1.0f);
        }
        return food.method_19242();
    }

    private static class_1792.class_1793 getSettingsWithoutTab() {
        return ObjectRegistry.getSettingsWithoutTab(settings -> {});
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (class_2960)new HerbalBrewsIdentifier(name), block);
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return Util.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (class_2960)new HerbalBrewsIdentifier(path), block);
    }

    public static <T extends class_1792> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return Util.registerItem(ITEMS, ITEM_REGISTRAR, (class_2960)new HerbalBrewsIdentifier(path), itemSupplier);
    }

    private static class_2269 createWoodenButtonBlock(class_8177 blockSetType, class_7696 ... requiredFeatures) {
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_9634().method_9632(0.5f).method_50012(class_3619.field_15971);
        if (requiredFeatures.length > 0) {
            settings = settings.method_45476(requiredFeatures);
        }
        return new class_2269(settings, blockSetType, 30, true);
    }

    private static class_4174 teaFoodComponent(class_1291 effect) {
        class_4174.class_4175 component = new class_4174.class_4175().method_19238(2).method_19237(2.0f);
        if (effect != null) {
            component.method_19239(new class_1293(effect, 36000), 1.0f);
        }
        return component.method_19242();
    }

    private static class_4970.class_2251 getTeaSettings() {
        return class_4970.class_2251.method_9630((class_4970)class_2246.field_10033).method_22488().method_9618();
    }

    private static <T extends class_2248> RegistrySupplier<T> registerTea(String name, Supplier<T> block, RegistrySupplier<class_1291> effect) {
        RegistrySupplier toReturn = ObjectRegistry.registerWithoutItem(name, block);
        ObjectRegistry.registerItem(name, () -> new DrinkBlockItem((class_2248)toReturn.get(), ObjectRegistry.getSettings(settings -> settings.method_19265(ObjectRegistry.teaFoodComponent((class_1291)effect.get()))), new class_1293((class_1291)effect.get(), 1800, 1)));
        return toReturn;
    }
}

