/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.nethervinery.registry;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.FacingBlock;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3708;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5537;
import net.minecraft.class_7924;
import net.satisfy.nethervinery.block.AgingBarrelBlock;
import net.satisfy.nethervinery.block.ApplePressBlock;
import net.satisfy.nethervinery.block.CrimsonGrapeBush;
import net.satisfy.nethervinery.block.ImprovedWineBottleBlock;
import net.satisfy.nethervinery.block.WarpedGrapeBush;
import net.satisfy.nethervinery.registry.NetherEffects;
import net.satisfy.nethervinery.registry.NetherGrapeTypes;
import net.satisfy.nethervinery.util.NetherVineryIdentifier;
import net.satisfy.vinery.block.GrapevinePotBlock;
import net.satisfy.vinery.block.stem.LatticeBlock;
import net.satisfy.vinery.block.stem.PaleStemBlock;
import net.satisfy.vinery.block.storage.BigBottleStorageBlock;
import net.satisfy.vinery.block.storage.FourBottleStorageBlock;
import net.satisfy.vinery.block.storage.NineBottleStorageBlock;
import net.satisfy.vinery.block.storage.WineBottleBlock;
import net.satisfy.vinery.item.DrinkBlockBigItem;
import net.satisfy.vinery.item.DrinkBlockSmallItem;
import net.satisfy.vinery.item.GrapeBushSeedItem;
import net.satisfy.vinery.item.GrapeItem;
import net.satisfy.vinery.registry.MobEffectRegistry;
import net.satisfy.vinery.util.FoodComponent;

public class NetherObjectRegistry {
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"nethervinery", (class_5321)class_7924.field_41197);
    public static final Registrar<class_1792> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"nethervinery", (class_5321)class_7924.field_41254);
    public static final Registrar<class_2248> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<class_2248> OBSIDIAN_STEM = NetherObjectRegistry.registerWithItem("obsidian_stem", () -> new PaleStemBlock(NetherObjectRegistry.getGrapevineSettings()));
    public static final RegistrySupplier<class_1792> CRIMSON_NETHER_BAG = NetherObjectRegistry.registerI("crimson_nether_bag", () -> new class_5537(NetherObjectRegistry.getSettings().method_7889(1)));
    public static final RegistrySupplier<class_1792> WARPED_NETHER_BAG = NetherObjectRegistry.registerI("warped_nether_bag", () -> new class_5537(NetherObjectRegistry.getSettings().method_7889(1)));
    public static final RegistrySupplier<class_2248> CRIMSON_GRAPE_BUSH = NetherObjectRegistry.registerB("crimson_grape_bush", () -> new CrimsonGrapeBush(NetherObjectRegistry.getBushSettings(), NetherGrapeTypes.CRIMSON));
    public static final RegistrySupplier<class_2248> WARPED_GRAPE_BUSH = NetherObjectRegistry.registerB("warped_grape_bush", () -> new WarpedGrapeBush(NetherObjectRegistry.getBushSettings(), NetherGrapeTypes.WARPED));
    public static final RegistrySupplier<class_1792> CRIMSON_GRAPE_SEEDS = NetherObjectRegistry.registerI("crimson_grape_seeds", () -> new GrapeBushSeedItem((class_2248)CRIMSON_GRAPE_BUSH.get(), NetherObjectRegistry.getSettings(), NetherGrapeTypes.CRIMSON));
    public static final RegistrySupplier<class_1792> CRIMSON_GRAPE = NetherObjectRegistry.registerI("crimson_grape", () -> new GrapeItem(NetherObjectRegistry.getSettings().method_19265(class_4176.field_18636), NetherGrapeTypes.CRIMSON, (class_1792)CRIMSON_GRAPE_SEEDS.get()));
    public static final RegistrySupplier<class_1792> WARPED_GRAPE_SEEDS = NetherObjectRegistry.registerI("warped_grape_seeds", () -> new GrapeBushSeedItem((class_2248)WARPED_GRAPE_BUSH.get(), NetherObjectRegistry.getSettings(), NetherGrapeTypes.WARPED));
    public static final RegistrySupplier<class_1792> WARPED_GRAPE = NetherObjectRegistry.registerI("warped_grape", () -> new GrapeItem(NetherObjectRegistry.getSettings().method_19265(class_4176.field_18636), NetherGrapeTypes.WARPED, (class_1792)WARPED_GRAPE_SEEDS.get()));
    public static final RegistrySupplier<class_2248> WARPED_GRAPE_CRATE = NetherObjectRegistry.registerWithItem("warped_grape_crate", () -> new FacingBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10314)));
    public static final RegistrySupplier<class_2248> CRIMSON_GRAPE_GRATE = NetherObjectRegistry.registerWithItem("crimson_grape_crate", () -> new FacingBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10314)));
    public static final RegistrySupplier<class_1792> WARPED_GRAPEJUICE = NetherObjectRegistry.registerI("warped_grapejuice", () -> new class_1792(NetherObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_1792> CRIMSON_GRAPEJUICE = NetherObjectRegistry.registerI("crimson_grapejuice", () -> new class_1792(NetherObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_2248> GHASTLY_GRENACHE = NetherObjectRegistry.registerB("ghastly_grenache", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 2));
    public static final RegistrySupplier<class_1792> GHASTLY_GRENACHE_ITEM = NetherObjectRegistry.registerI("ghastly_grenache", () -> new DrinkBlockBigItem((class_2248)GHASTLY_GRENACHE.get(), NetherObjectRegistry.getWineItemSettings((class_1291)MobEffectRegistry.IMPROVED_JUMP_BOOST.get(), 1200)));
    public static final RegistrySupplier<class_2248> NETHERITE_NECTAR = NetherObjectRegistry.registerB("netherite_nectar", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 3));
    public static final RegistrySupplier<class_1792> NETHERITE_NECTAR_ITEM = NetherObjectRegistry.registerI("netherite_nectar", () -> new DrinkBlockSmallItem((class_2248)NETHERITE_NECTAR.get(), NetherObjectRegistry.getWineItemSettings((class_1291)NetherEffects.NETHERITE.get(), 240)));
    public static final RegistrySupplier<class_2248> BLAZEWINE_PINOT = NetherObjectRegistry.registerB("blazewine_pinot", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 1));
    public static final RegistrySupplier<class_1792> BLAZEWINE_PINOT_ITEM = NetherObjectRegistry.registerI("blazewine_pinot", () -> new DrinkBlockBigItem((class_2248)BLAZEWINE_PINOT.get(), NetherObjectRegistry.getWineItemSettings((class_1291)MobEffectRegistry.LAVA_WALKER.get(), 1200)));
    public static final RegistrySupplier<class_2248> NETHER_FIZZ = NetherObjectRegistry.registerB("nether_fizz", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 2));
    public static final RegistrySupplier<class_1792> NETHER_FIZZ_ITEM = NetherObjectRegistry.registerI("nether_fizz", () -> new DrinkBlockSmallItem((class_2248)NETHER_FIZZ.get(), NetherObjectRegistry.getWineItemSettings((class_1291)NetherEffects.HEARTHSTONE.get(), 1)));
    public static final RegistrySupplier<class_2248> LAVA_FIZZ = NetherObjectRegistry.registerB("lava_fizz", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 3));
    public static final RegistrySupplier<class_1792> LAVA_FIZZ_ITEM = NetherObjectRegistry.registerI("lava_fizz", () -> new DrinkBlockSmallItem((class_2248)LAVA_FIZZ.get(), NetherObjectRegistry.getWineItemSettings((class_1291)NetherEffects.GRAVEDIGGER.get(), 1)));
    public static final RegistrySupplier<class_2248> IMPROVED_NETHER_FIZZ = NetherObjectRegistry.registerB("improved_nether_fizz", () -> new ImprovedWineBottleBlock(NetherObjectRegistry.getWineSettings(), 3));
    public static final RegistrySupplier<class_1792> IMPROVED_NETHER_FIZZ_ITEM = NetherObjectRegistry.registerI("improved_nether_fizz", () -> new DrinkBlockSmallItem((class_2248)IMPROVED_NETHER_FIZZ.get(), NetherObjectRegistry.getWineItemSettings((class_1291)NetherEffects.IMPROVED_HEARTHSTONE.get(), 1)));
    public static final RegistrySupplier<class_2248> IMPROVED_LAVA_FIZZ = NetherObjectRegistry.registerB("improved_lava_fizz", () -> new ImprovedWineBottleBlock(NetherObjectRegistry.getWineSettings(), 3));
    public static final RegistrySupplier<class_1792> IMPROVED_LAVA_FIZZ_ITEM = NetherObjectRegistry.registerI("improved_lava_fizz", () -> new DrinkBlockSmallItem((class_2248)IMPROVED_LAVA_FIZZ.get(), NetherObjectRegistry.getWineItemSettings((class_1291)NetherEffects.IMPROVED_GRAVEDIGGER.get(), 1)));
    public static final RegistrySupplier<class_2248> CRIMSON_FERMENTATION_BARREL = NetherObjectRegistry.registerWithItem("crimson_fermentation_barrel", () -> new AgingBarrelBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16328).method_22488()));
    public static final RegistrySupplier<class_2248> CRIMSON_GRAPEVINE_POT = NetherObjectRegistry.registerWithItem("crimson_grapevine_pot", () -> new GrapevinePotBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_22126).method_22488()));
    public static final RegistrySupplier<class_2248> CRIMSON_APPLE_PRESS = NetherObjectRegistry.registerWithItem("crimson_apple_press", () -> new ApplePressBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_22126).method_22488()));
    public static final RegistrySupplier<class_2248> CRIMSON_WINE_RACK_BIG = NetherObjectRegistry.registerWithItem("crimson_wine_rack_big", () -> new NineBottleStorageBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547).method_22488()));
    public static final RegistrySupplier<class_2248> CRIMSON_WINE_RACK_SMALL = NetherObjectRegistry.registerWithItem("crimson_wine_rack_small", () -> new FourBottleStorageBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547).method_22488()));
    public static final RegistrySupplier<class_2248> CRIMSON_WINE_RACK_MID = NetherObjectRegistry.registerWithItem("crimson_wine_rack_mid", () -> new BigBottleStorageBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547).method_22488()));
    public static final RegistrySupplier<class_2248> REINFORCED_CRIMSON_PLANKS = NetherObjectRegistry.registerWithItem("reinforced_crimson_planks", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_22126)));
    public static final RegistrySupplier<class_2248> CRESTED_CRIMSON_PLANKS = NetherObjectRegistry.registerWithItem("crested_crimson_planks", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_22126)));
    public static final RegistrySupplier<class_2248> CRIMSON_BARREL = NetherObjectRegistry.registerWithItem("crimson_barrel", () -> new class_3708(class_4970.class_2251.method_9630((class_4970)class_2246.field_16328)));
    public static final RegistrySupplier<class_2248> WARPED_FERMENTATION_BARREL = NetherObjectRegistry.registerWithItem("warped_fermentation_barrel", () -> new AgingBarrelBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_16328).method_22488()));
    public static final RegistrySupplier<class_2248> WARPED_GRAPEVINE_POT = NetherObjectRegistry.registerWithItem("warped_grapevine_pot", () -> new GrapevinePotBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_22126).method_22488()));
    public static final RegistrySupplier<class_2248> WARPED_APPLE_PRESS = NetherObjectRegistry.registerWithItem("warped_apple_press", () -> new ApplePressBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_22126).method_22488()));
    public static final RegistrySupplier<class_2248> WARPED_WINE_RACK_BIG = NetherObjectRegistry.registerWithItem("warped_wine_rack_big", () -> new NineBottleStorageBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547).method_22488()));
    public static final RegistrySupplier<class_2248> WARPED_WINE_RACK_SMALL = NetherObjectRegistry.registerWithItem("warped_wine_rack_small", () -> new FourBottleStorageBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547).method_22488()));
    public static final RegistrySupplier<class_2248> WARPED_WINE_RACK_MID = NetherObjectRegistry.registerWithItem("warped_wine_rack_mid", () -> new BigBottleStorageBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547).method_22488()));
    public static final RegistrySupplier<class_2248> REINFORCED_WARPED_PLANKS = NetherObjectRegistry.registerWithItem("reinforced_warped_planks", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_22126)));
    public static final RegistrySupplier<class_2248> CRESTED_WARPED_PLANKS = NetherObjectRegistry.registerWithItem("crested_warped_planks", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_22126)));
    public static final RegistrySupplier<class_2248> WARPED_BARREL = NetherObjectRegistry.registerWithItem("warped_barrel", () -> new class_3708(class_4970.class_2251.method_9630((class_4970)class_2246.field_16328)));
    public static final RegistrySupplier<class_2248> WARPED_LATTICE = NetherObjectRegistry.registerWithItem("warped_lattice", () -> new LatticeBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 3.0f).method_9626(class_2246.field_10334.method_9573(class_2246.field_10334.method_9564())).method_22488()));
    public static final RegistrySupplier<class_2248> CRIMSON_LATTICE = NetherObjectRegistry.registerWithItem("crimson_lattice", () -> new LatticeBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 3.0f).method_9626(class_2246.field_37577.method_9573(class_2246.field_37577.method_9564())).method_22488()));

    private static <T extends class_1792> RegistrySupplier<T> registerI(String path, Supplier<T> item) {
        NetherVineryIdentifier id = new NetherVineryIdentifier(path);
        return ITEM_REGISTRAR.register((class_2960)id, item);
    }

    private static <T extends class_2248> RegistrySupplier<T> registerB(String path, Supplier<T> block) {
        NetherVineryIdentifier id = new NetherVineryIdentifier(path);
        return BLOCK_REGISTRAR.register((class_2960)id, block);
    }

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static class_1792.class_1793 getSettings(Consumer<class_1792.class_1793> consumer) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        consumer.accept(settings);
        return settings;
    }

    private static class_1792.class_1793 getSettings() {
        return NetherObjectRegistry.getSettings(settings -> {});
    }

    private static class_4970.class_2251 getGrapevineSettings() {
        return class_4970.class_2251.method_9637().method_9632(3.0f).method_9640().method_9626(class_2498.field_11544).method_22488();
    }

    private static class_1792.class_1793 getWineItemSettings(class_1291 effect, int duration) {
        return NetherObjectRegistry.getSettings().method_19265(NetherObjectRegistry.wineFoodComponent(effect, duration));
    }

    private static class_4174 wineFoodComponent(class_1291 effect, int duration) {
        ArrayList effects = Lists.newArrayList();
        if (effect != null) {
            effects.add(Pair.of((Object)new class_1293(effect, duration), (Object)Float.valueOf(1.0f)));
        }
        return new FoodComponent((List)effects);
    }

    private static class_4970.class_2251 getBushSettings() {
        return class_4970.class_2251.method_9630((class_4970)class_2246.field_16999);
    }

    private static class_4970.class_2251 getWineSettings() {
        return class_4970.class_2251.method_9630((class_4970)class_2246.field_10033).method_22488().method_9618();
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithItem(String path, Supplier<T> block) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (class_2960)new NetherVineryIdentifier(path), block);
    }
}

