/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.block.storage;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.common.block.StorageBlock;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import de.cristelknight.doapi.common.util.GeneralUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.satisfy.vinery.item.DrinkBlockItem;
import net.satisfy.vinery.registry.StorageTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class WineBottleBlock
extends StorageBlock {
    private static final class_265 SHAPE = class_259.method_1081((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    public static final class_2746 FAKE_MODEL = class_2746.method_11825((String)"fake_model");
    private final int maxCount;

    public WineBottleBlock(class_4970.class_2251 settings, int maxCount) {
        super(settings);
        this.maxCount = maxCount;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)FAKE_MODEL, (Comparable)Boolean.valueOf(true)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity wineEntity = (StorageBlockEntity)blockEntity;
            class_2371 inventory = wineEntity.getInventory();
            if (this.canInsertStack(stack) && this.willFitStack(stack, (class_2371<class_1799>)inventory)) {
                int posInE = this.getFirstEmptySlot((class_2371<class_1799>)inventory);
                if (posInE == Integer.MIN_VALUE) {
                    return class_1269.field_5811;
                }
                if (!world.method_8608()) {
                    wineEntity.setStack(posInE, stack.method_7971(1));
                    if (player.method_7337()) {
                        stack.method_7933(1);
                    }
                    world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
            if (stack.method_7960() && !this.isEmpty((class_2371<class_1799>)inventory)) {
                int posInE = this.getLastFullSlot((class_2371<class_1799>)inventory);
                if (posInE == Integer.MIN_VALUE) {
                    return class_1269.field_5811;
                }
                if (!world.method_8608()) {
                    class_1799 wine = wineEntity.removeStack(posInE);
                    if (!player.method_31548().method_7394(wine)) {
                        player.method_7328(wine, false);
                    }
                    if (this.isEmpty((class_2371<class_1799>)inventory)) {
                        world.method_22352(pos, false);
                    }
                    world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
        }
        return class_1269.field_5811;
    }

    public boolean isEmpty(class_2371<class_1799> inventory) {
        for (class_1799 stack : inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public int getFirstEmptySlot(class_2371<class_1799> inventory) {
        for (class_1799 stack : inventory) {
            if (!stack.method_7960()) continue;
            return inventory.indexOf((Object)stack);
        }
        return Integer.MIN_VALUE;
    }

    public int getLastFullSlot(class_2371<class_1799> inventory) {
        for (int i = inventory.size() - 1; i >= 0; --i) {
            if (((class_1799)inventory.get(i)).method_7960()) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FAKE_MODEL});
    }

    public boolean method_9558(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return GeneralUtil.isSolid((class_4538)levelReader, (class_2338)blockPos);
    }

    @NotNull
    public class_2680 method_9559(class_2680 blockState, class_2350 direction, class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
        if (direction == class_2350.field_11033 && !blockState.method_26184((class_4538)levelAccessor, blockPos)) {
            levelAccessor.method_22352(blockPos, true);
        }
        return super.method_9559(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public int size() {
        return this.maxCount;
    }

    public class_2960 type() {
        return StorageTypeRegistry.WINE_BOTTLE;
    }

    public boolean canInsertStack(class_1799 itemStack) {
        return itemStack.method_7909() instanceof DrinkBlockItem;
    }

    public boolean willFitStack(class_1799 itemStack, class_2371<class_1799> inventory) {
        Pair<Integer, Integer> p = WineBottleBlock.getFilledAmountAndBiggest(inventory);
        int biggest = (Integer)p.getSecond();
        int count = (Integer)p.getFirst();
        int stackCount = WineBottleBlock.getCount(itemStack);
        if (biggest == Integer.MAX_VALUE) {
            return true;
        }
        return stackCount > count && count < biggest;
    }

    public static Pair<Integer, Integer> getFilledAmountAndBiggest(class_2371<class_1799> inventory) {
        int count = 0;
        int biggest = Integer.MAX_VALUE;
        for (class_1799 stack : inventory) {
            DrinkBlockItem item;
            if (stack.method_7960()) continue;
            ++count;
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof DrinkBlockItem) || !((class_17922 = (item = (DrinkBlockItem)class_17922).method_7711()) instanceof WineBottleBlock)) continue;
            WineBottleBlock wine = (WineBottleBlock)class_17922;
            if (wine.maxCount >= biggest) continue;
            biggest = wine.maxCount;
        }
        return new Pair((Object)count, (Object)biggest);
    }

    public static int getCount(class_1799 itemStack) {
        DrinkBlockItem item;
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof DrinkBlockItem && (class_17922 = (item = (DrinkBlockItem)class_17922).method_7711()) instanceof WineBottleBlock) {
            WineBottleBlock wine = (WineBottleBlock)class_17922;
            return wine.maxCount;
        }
        return Integer.MIN_VALUE;
    }

    @NotNull
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public int getSection(Float aFloat, Float aFloat1) {
        return 0;
    }

    public class_2350[] unAllowedDirections() {
        return new class_2350[0];
    }
}

