/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.vinery.Vinery;
import net.satisfy.vinery.effect.NormalEffect;
import net.satisfy.vinery.effect.instant.CreeperEffect;
import net.satisfy.vinery.effect.instant.TeleportEffect;
import net.satisfy.vinery.effect.normal.ArmorEffect;
import net.satisfy.vinery.effect.normal.ImprovedHealthEffect;
import net.satisfy.vinery.effect.normal.LuckEffect;
import net.satisfy.vinery.effect.normal.ResistanceEffect;
import net.satisfy.vinery.effect.normal.TradingEffect;
import net.satisfy.vinery.effect.normal.TrippyEffect;
import net.satisfy.vinery.effect.ticking.ClimbingEffect;
import net.satisfy.vinery.effect.ticking.FrostyArmorEffect;
import net.satisfy.vinery.effect.ticking.JellieEffect;
import net.satisfy.vinery.effect.ticking.LavaWalkerEffect;
import net.satisfy.vinery.effect.ticking.MagnetEffect;
import net.satisfy.vinery.effect.ticking.StaggerEffect;
import net.satisfy.vinery.effect.ticking.WaterWalkerEffect;
import net.satisfy.vinery.util.VineryIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"vinery", (class_5321)class_7924.field_41208);
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<class_1291> TRIPPY;
    public static final RegistrySupplier<class_1291> JELLIE;
    public static final RegistrySupplier<class_1291> MAGNET;
    public static final RegistrySupplier<class_1291> TELEPORT;
    public static final RegistrySupplier<class_1291> IMPROVED_JUMP_BOOST;
    public static final RegistrySupplier<class_1291> WATER_WALKER;
    public static final RegistrySupplier<class_1291> CREEPER_EFFECT;
    public static final RegistrySupplier<class_1291> EXPERIENCE_EFFECT;
    public static final RegistrySupplier<class_1291> LAVA_WALKER;
    public static final RegistrySupplier<class_1291> STAGGER_EFFECT;
    public static final RegistrySupplier<class_1291> FROSTY_ARMOR_EFFECT;
    public static final RegistrySupplier<class_1291> PARTY_EFFECT;
    public static final RegistrySupplier<class_1291> CLIMBING_EFFECT;
    public static final RegistrySupplier<class_1291> LUCK_EFFECT;
    public static final RegistrySupplier<class_1291> HEALTH_EFFECT;
    public static final RegistrySupplier<class_1291> RESISTANCE_EFFECT;
    public static final RegistrySupplier<class_1291> ARMOR_EFFECT;
    public static final RegistrySupplier<class_1291> TRADING_EFFECT;
    public static final RegistrySupplier<class_1291> SHIRAAZ_EFFECT;

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new VineryIdentifier(name), effect);
    }

    public static void init() {
        Vinery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        ARMOR_EFFECT = MobEffectRegistry.registerEffect("armor_effect", ArmorEffect::new);
        HEALTH_EFFECT = MobEffectRegistry.registerEffect("health_effect", ImprovedHealthEffect::new);
        LUCK_EFFECT = MobEffectRegistry.registerEffect("luck_effect", LuckEffect::new);
        RESISTANCE_EFFECT = MobEffectRegistry.registerEffect("resistance_effect", ResistanceEffect::new);
        TRIPPY = MobEffectRegistry.registerEffect("trippy", TrippyEffect::new);
        TRADING_EFFECT = MobEffectRegistry.registerEffect("trading", () -> new TradingEffect(class_4081.field_18271, 0xFF0000));
        EXPERIENCE_EFFECT = MobEffectRegistry.registerEffect("experience_effect", () -> new NormalEffect(class_4081.field_18271, 65280));
        IMPROVED_JUMP_BOOST = MobEffectRegistry.registerEffect("double_jump", () -> new NormalEffect(class_4081.field_18271, 9500817));
        PARTY_EFFECT = MobEffectRegistry.registerEffect("party_effect", () -> new NormalEffect(class_4081.field_18271, 0xFF0000));
        SHIRAAZ_EFFECT = MobEffectRegistry.registerEffect("shiraaz_effect", () -> new NormalEffect(class_4081.field_18271, 0xFF0000));
        TELEPORT = MobEffectRegistry.registerEffect("teleport", TeleportEffect::new);
        CREEPER_EFFECT = MobEffectRegistry.registerEffect("creeper_effect", CreeperEffect::new);
        CLIMBING_EFFECT = MobEffectRegistry.registerEffect("climbing_effect", ClimbingEffect::new);
        FROSTY_ARMOR_EFFECT = MobEffectRegistry.registerEffect("frosty_armor", FrostyArmorEffect::new);
        JELLIE = MobEffectRegistry.registerEffect("jellie", JellieEffect::new);
        LAVA_WALKER = MobEffectRegistry.registerEffect("lava_walker", LavaWalkerEffect::new);
        MAGNET = MobEffectRegistry.registerEffect("magnet", MagnetEffect::new);
        STAGGER_EFFECT = MobEffectRegistry.registerEffect("staggering", StaggerEffect::new);
        WATER_WALKER = MobEffectRegistry.registerEffect("water_walker", WaterWalkerEffect::new);
    }
}

