/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.block;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.satisfy.wildernature.block.entity.BountyBoardBlockEntity;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.network.BountyBlockNetworking;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.ObjectRegistry;
import net.satisfy.wildernature.util.WilderNatureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BountyBoardBlock
extends class_2237 {
    public static final class_2754<Part> PART = class_2754.method_11850((String)"part", Part.class);
    public static final class_2753 FACING = class_2741.field_12481;
    private static final class_265 SHAPE_BOTTOM_LEFT = BountyBoardBlock.makeBottomLeftShape();
    private static final class_265 SHAPE_BOTTOM_RIGHT = BountyBoardBlock.makeBottomRightShape();
    private static final class_265 SHAPE_TOP_LEFT = BountyBoardBlock.makeTopLeftShape();
    private static final class_265 SHAPE_TOP_RIGHT = BountyBoardBlock.makeTopRightShape();
    public static final Map<class_2350, Map<Part, class_265>> SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            HashMap<Part, class_265> partShapeMap = new HashMap<Part, class_265>();
            partShapeMap.put(Part.BOTTOM_LEFT, WilderNatureUtil.rotateShape(class_2350.field_11043, direction, SHAPE_BOTTOM_LEFT));
            partShapeMap.put(Part.BOTTOM_RIGHT, WilderNatureUtil.rotateShape(class_2350.field_11043, direction, SHAPE_BOTTOM_RIGHT));
            partShapeMap.put(Part.TOP_LEFT, WilderNatureUtil.rotateShape(class_2350.field_11043, direction, SHAPE_TOP_LEFT));
            partShapeMap.put(Part.TOP_RIGHT, WilderNatureUtil.rotateShape(class_2350.field_11043, direction, SHAPE_TOP_RIGHT));
            map.put(direction, partShapeMap);
        }
    });

    public BountyBoardBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    private static class_265 makeBottomLeftShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.4375, (double)0.125, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.5, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeBottomRightShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.875, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.5, (double)0.4375, (double)0.875, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeTopLeftShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeTopRightShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (class_247)class_247.field_1366);
        return shape;
    }

    @NotNull
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_3908 method_17454(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        class_2586 entity = level.method_8321(blockPos);
        if (entity instanceof BountyBoardBlockEntity) {
            BountyBoardBlockEntity bountyBoardBlockEntity = (BountyBoardBlockEntity)entity;
            return bountyBoardBlockEntity;
        }
        return null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PART, FACING});
    }

    private static <T extends class_2586> class_5558<T> createTicker(class_1937 level, class_2591<T> blockEntityType, class_2591<BountyBoardBlockEntity> blockEntityType2) {
        return level.field_9236 ? null : BountyBoardBlock.method_31618(blockEntityType, blockEntityType2, BountyBoardBlockEntity::serverTick);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return BountyBoardBlock.createTicker(level, blockEntityType, (class_2591<BountyBoardBlockEntity>)((class_2591)EntityRegistry.BOUNTY_BOARD_ENTITY.get()));
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 direction;
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        if (!this.canPlaceAt(world, pos, direction = context.method_8042().method_10153())) {
            return null;
        }
        return (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).method_11657((class_2769)FACING, (Comparable)direction);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_1657 player;
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        world.method_8652(pos.method_10084(), (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)Part.TOP_LEFT))).method_11657((class_2769)FACING, (Comparable)direction), 3);
        world.method_8652(pos.method_10093(direction.method_10170()), (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)Part.BOTTOM_RIGHT))).method_11657((class_2769)FACING, (Comparable)direction), 3);
        world.method_8652(pos.method_10093(direction.method_10170()).method_10084(), (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)Part.TOP_RIGHT))).method_11657((class_2769)FACING, (Comparable)direction), 3);
        world.method_8396(null, pos, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.0f);
        world.method_8396(null, pos, class_3417.field_42549, class_3419.field_15245, 1.0f, 1.0f);
        if (placer instanceof class_1657 && !(player = (class_1657)placer).method_7337()) {
            stack.method_7934(1);
        }
    }

    private boolean canPlaceAt(class_1937 world, class_2338 pos, class_2350 direction) {
        return world.method_8320(pos).method_45474() && world.method_8320(pos.method_10084()).method_45474() && world.method_8320(pos.method_10093(direction.method_10170())).method_45474() && world.method_8320(pos.method_10093(direction.method_10170()).method_10084()).method_45474();
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        state.method_26204();
        newState.method_26204();
        super.method_9536(state, world, pos, newState, isMoving);
    }

    private class_2338 getBasePos(class_2680 state, class_2338 pos) {
        Part part = (Part)((Object)state.method_11654(PART));
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case Part.BOTTOM_LEFT -> pos;
            case Part.TOP_LEFT -> pos.method_10074();
            case Part.BOTTOM_RIGHT -> pos.method_10079(direction.method_10160(), 1);
            case Part.TOP_RIGHT -> pos.method_10079(direction.method_10160(), 1).method_10074();
        };
    }

    private void destroyAdjacentBlocks(class_1937 world, class_2338 basePos) {
        class_2680 blockstate = world.method_8320(basePos);
        class_2350 facing = (class_2350)blockstate.method_11654((class_2769)FACING);
        world.method_8650(basePos, false);
        world.method_8650(basePos.method_10084(), false);
        world.method_8650(basePos.method_10079(facing.method_10170(), 1), false);
        world.method_8650(basePos.method_10079(facing.method_10170(), 1).method_10084(), false);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        Part part = (Part)((Object)state.method_11654(PART));
        return SHAPE.get(direction).get((Object)part);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        state.method_11654(PART);
        class_2338 basePos = this.getBasePos(world.method_8320(pos), pos);
        class_2586 entity = world.method_8321(basePos);
        assert (entity instanceof BountyBoardBlockEntity);
        BountyBoardBlockEntity bountyBoardBlockEntity = (BountyBoardBlockEntity)entity;
        if (world.method_8608()) {
            return;
        }
        class_2487 blockEntityTag = new class_2487();
        bountyBoardBlockEntity.method_11007(blockEntityTag);
        class_2487 tag = new class_2487();
        tag.method_10566("BlockEntityTag", (class_2520)blockEntityTag);
        class_1799 stack = new class_1799((class_1935)ObjectRegistry.BOUNTY_BOARD.get());
        stack.method_7980(tag);
        world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack));
        this.destroyAdjacentBlocks(world, basePos);
        super.method_9576(world, pos, state, player);
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        if (blockPos != this.getBasePos(blockState, blockPos)) {
            return null;
        }
        return new BountyBoardBlockEntity(blockPos, blockState);
    }

    @NotNull
    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 originalBlockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_2338 blockPos = this.getBasePos(blockState, originalBlockPos);
        class_3908 pr = this.method_17454(blockState, level, blockPos);
        MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (class_3908)pr, friendlyByteBuf -> {
            BountyBoardBlockEntity entity = (BountyBoardBlockEntity)level.method_8321(blockPos);
            friendlyByteBuf.method_10817((Enum)BountyBlockNetworking.BountyServerUpdateType.MULTI);
            friendlyByteBuf.writeShort(3);
            assert (entity != null);
            BountyBlockScreenHandler.s_writeUpdateContracts(friendlyByteBuf, entity);
            BountyBlockScreenHandler.s_writeBlockDataChange(friendlyByteBuf, entity.rerollsLeft, entity.rerollCooldownLeft, entity.boardId, entity.tier, entity.xp);
            BountyBlockScreenHandler.s_writeActiveContractInfo(friendlyByteBuf, (class_3222)player);
        });
        return class_1269.field_5812;
    }

    public static enum Part implements class_3542
    {
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

