/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.block.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.platform.Platform;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3908;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.event.EventManager;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.util.BountyBoardTier;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import net.satisfy.wildernature.util.contract.Contract;
import net.satisfy.wildernature.util.contract.ContractReloader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BountyBoardBlockEntity
extends class_2586
implements class_3908 {
    private static final String KEY_CONTRACTS = "contracts";
    private static final int rerollCooldown = 18000;
    public int rerollCooldownLeft = 0;
    private static final String KEY_REROLL_COOLDOWN_LEFT = "reroll_cooldown_left";
    public static final int rerolls = 3;
    public int rerollsLeft;
    private static final String KEY_REROLLS_LEFT = "rerolls_left";
    private static final String KEY_TIER = "tier";
    private static final String KEY_EXP = "experience";
    private static final String KEY_LONGID = "longid";
    public EventManager onTick = new EventManager();
    public EventManager onBlockDataChange = new EventManager();
    public long boardId = new Random().nextInt();
    private class_2960[] contracts = new class_2960[3];
    public class_2960 tier = new WilderNatureIdentifier("tier1");
    public int xp = 0;

    public class_2960[] getContracts() {
        if (this.contracts == null) {
            this.contracts = new class_2960[3];
            this.fillWithRandomContracts();
        }
        if (this.contracts.length != 3) {
            this.contracts = null;
            this.contracts = this.getContracts();
            return this.contracts;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.contracts[i] != null) continue;
            this.contracts[i] = this.getRandomContract();
        }
        return (class_2960[])this.contracts.clone();
    }

    public void setContracts(class_2960[] contracts) {
        this.contracts = (class_2960[])contracts.clone();
    }

    public BountyBoardBlockEntity(class_2338 a, class_2680 b) {
        super((class_2591)EntityRegistry.BOUNTY_BOARD_ENTITY.get(), a, b);
    }

    public void method_11014(class_2487 compoundTag) {
        this.rerollCooldownLeft = compoundTag.method_10545(KEY_REROLL_COOLDOWN_LEFT) ? compoundTag.method_10550(KEY_REROLL_COOLDOWN_LEFT) : 0;
        this.rerollsLeft = compoundTag.method_10545(KEY_REROLLS_LEFT) ? compoundTag.method_10550(KEY_REROLLS_LEFT) : 3;
        this.boardId = compoundTag.method_10545(KEY_LONGID) ? compoundTag.method_10537(KEY_LONGID) : (long)new Random().nextInt();
        this.tier = compoundTag.method_10545(KEY_TIER) ? new class_2960(compoundTag.method_10558(KEY_TIER)) : new WilderNatureIdentifier("");
        int n = this.xp = compoundTag.method_10545(KEY_EXP) ? compoundTag.method_10550(KEY_EXP) : 0;
        if (compoundTag.method_10545(KEY_CONTRACTS)) {
            this.setContracts(((List)class_2960.field_25139.listOf().parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10580(KEY_CONTRACTS)).getOrThrow(false, error -> new RuntimeException((String)error))).toArray(new class_2960[3]));
        } else {
            this.fillWithRandomContracts();
        }
    }

    public void tryReroll() {
        if (this.rerollsLeft <= 0) {
            return;
        }
        if (this.rerollsLeft == 3) {
            this.rerollCooldownLeft = 18000;
        }
        --this.rerollsLeft;
        this.fillWithRandomContracts();
        this.onBlockDataChange.invoke();
    }

    private void fillWithRandomContracts() {
        for (int i = 0; i < 3; ++i) {
            this.setRandomContactInSlot(i);
        }
    }

    public void setRandomContactInSlot(int i) {
        class_2960[] contracts = this.getContracts();
        contracts[i] = this.getRandomContract();
        this.setContracts(contracts);
    }

    private class_2960 getRandomContract() {
        return ContractReloader.getRandomContractOfTier(this.tier);
    }

    public void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569(KEY_REROLL_COOLDOWN_LEFT, this.rerollCooldownLeft);
        compoundTag.method_10569(KEY_REROLLS_LEFT, this.rerollsLeft);
        compoundTag.method_10544(KEY_LONGID, this.boardId);
        compoundTag.method_10582(KEY_TIER, this.tier.toString());
        compoundTag.method_10569(KEY_EXP, this.xp);
        compoundTag.method_10566(KEY_CONTRACTS, (class_2520)class_2960.field_25139.listOf().encode(Arrays.stream(this.getContracts()).toList(), (DynamicOps)class_2509.field_11560, (Object)new class_2499()).getOrThrow(false, err -> {
            throw new RuntimeException((String)err);
        }));
    }

    public class_2487 getContractsNbt() {
        DataResult encode = Contract.CODEC.listOf().encode(Arrays.stream(this.getContracts()).map(Contract::fromId).toList(), (DynamicOps)class_2509.field_11560, (Object)new class_2499());
        class_2520 orThrow = (class_2520)encode.getOrThrow(false, error -> {
            throw new RuntimeException((String)error);
        });
        class_2487 tag = new class_2487();
        tag.method_10566("list", orThrow);
        return tag;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return BountyBlockScreenHandler.s_createServer(i, inventory, this);
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, BountyBoardBlockEntity abstractFurnaceBlockEntity) {
        abstractFurnaceBlockEntity.serverTick(level, blockPos, blockState);
    }

    private void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        --this.rerollCooldownLeft;
        if (this.rerollCooldownLeft < 0) {
            this.rerollsLeft = 3;
        }
        this.onTick.invoke();
    }

    public BountyBoardTier getTier() {
        return BountyBoardTier.byId(this.tier).get();
    }

    public void addXp(int addXp) {
        int nextTierXp = this.getTier().experience();
        this.xp += addXp;
        if (this.xp >= nextTierXp) {
            addXp = this.xp - nextTierXp;
            this.xp = 0;
            if (this.getTier().nextTier().isEmpty()) {
                if (Platform.isDevelopmentEnvironment()) {
                    Objects.requireNonNull(Objects.requireNonNull(this.method_10997()).method_8503()).method_3760().method_43514((class_2561)class_2561.method_43470((String)"_info: next tier is empty, impossible to upgrade"), true);
                }
                return;
            }
            this.tier = this.getTier().nextTier().get();
            this.onBlockDataChange.invoke();
            this.addXp(addXp);
        }
    }
}

