/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.gui.handlers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.block.entity.BountyBoardBlockEntity;
import net.satisfy.wildernature.event.EventManager;
import net.satisfy.wildernature.network.BountyBlockNetworking;
import net.satisfy.wildernature.util.BountyBoardTier;
import net.satisfy.wildernature.util.contract.Contract;
import net.satisfy.wildernature.util.contract.ContractInProgress;
import org.jetbrains.annotations.NotNull;

public class BountyBlockScreenHandler
extends class_1703 {
    private static final DeferredRegister<class_3917<?>> MENUS = DeferredRegister.create((String)"wildernature", (class_5321)class_7924.field_41207);
    public static final RegistrySupplier<class_3917<BountyBlockScreenHandler>> BOUNTY_BLOCK = MENUS.register("bounty_menu", () -> MenuRegistry.ofExtended((id, inventory, buf) -> {
        BountyBlockScreenHandler bountyBlockScreenHandler = BountyBlockScreenHandler.c_createClient(id, inventory);
        bountyBlockScreenHandler.c_onServerUpdate(buf);
        return bountyBlockScreenHandler;
    }));
    public BountyBoardBlockEntity s_targetEntity;
    public EventManager c_onContractUpdate = new EventManager();
    public ContractInProgress c_activeContractProgress;
    public Contract c_activeContract;
    public long c_boardId;
    public Contract[] c_contracts;
    public int c_time;
    public int c_rerolls;
    public float c_progress;
    public class_2960 c_tierId;

    @NotNull
    public class_1799 method_7601(class_1657 player, int i) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public static void registerMenuTypes() {
        MENUS.register();
    }

    private BountyBlockScreenHandler(int id, class_1661 inventory, BountyBoardBlockEntity s_targetEntity) {
        super((class_3917)BOUNTY_BLOCK.get(), id);
        this.s_targetEntity = s_targetEntity;
        if (s_targetEntity != null) {
            s_targetEntity.onTick.subscribe(() -> {
                if (s_targetEntity.rerollCooldownLeft % 20 == 0 && inventory.field_7546.field_7512 == this) {
                    class_2540 buf = new class_2540((ByteBuf)new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 0, 32768));
                    BountyBlockScreenHandler.s_writeBlockDataChange(buf, this.s_targetEntity.rerollsLeft, this.s_targetEntity.rerollCooldownLeft, this.s_targetEntity.boardId, s_targetEntity.tier, s_targetEntity.xp);
                    NetworkManager.sendToPlayer((class_3222)((class_3222)inventory.field_7546), (class_2960)BountyBlockNetworking.ID_SCREEN_UPDATE, (class_2540)buf);
                }
            });
            s_targetEntity.onBlockDataChange.subscribe(() -> {
                if (inventory.field_7546.field_7512 == this) {
                    class_2540 buf = new class_2540((ByteBuf)new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 0, 32768));
                    buf.method_10817((Enum)BountyBlockNetworking.BountyServerUpdateType.MULTI);
                    buf.writeShort(3);
                    BountyBlockScreenHandler.s_writeBlockDataChange(buf, this.s_targetEntity.rerollsLeft, this.s_targetEntity.rerollCooldownLeft, this.s_targetEntity.boardId, s_targetEntity.tier, s_targetEntity.xp);
                    BountyBlockScreenHandler.s_writeUpdateContracts(buf, s_targetEntity);
                    BountyBlockScreenHandler.s_writeActiveContractInfo(buf, (class_3222)inventory.field_7546);
                    NetworkManager.sendToPlayer((class_3222)((class_3222)inventory.field_7546), (class_2960)BountyBlockNetworking.ID_SCREEN_UPDATE, (class_2540)buf);
                }
            });
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)inventory, i * 9 + j + 9, j * 18 + 8, i * 18 + 86));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.method_7621(new class_1735((class_1263)inventory, j, j * 18 + 8, 144));
        }
    }

    public static class_1703 s_createServer(int i, class_1661 inventory, BountyBoardBlockEntity bountyBoardBlockEntity) {
        return new BountyBlockScreenHandler(i, inventory, bountyBoardBlockEntity);
    }

    public static void s_writeBlockDataChange(class_2540 buf, int rerolls, int time, long boardId, class_2960 tierId, int xp) {
        buf.method_10817((Enum)BountyBlockNetworking.BountyServerUpdateType.SEND_BOARD_DATA);
        buf.writeInt(time);
        buf.writeByte(rerolls);
        buf.writeLong(boardId);
        buf.method_10812(tierId);
        buf.writeFloat(BountyBoardTier.byId(tierId).get().progress(xp));
    }

    public static void s_writeActiveContractInfo(class_2540 buf, class_3222 player) {
        ContractInProgress contractProgress = ContractInProgress.progressPerPlayer.get(player.method_5667());
        if (contractProgress == null) {
            buf.method_10817((Enum)BountyBlockNetworking.BountyServerUpdateType.CLEAR_ACTIVE_CONTRACT);
        } else {
            buf.method_10817((Enum)BountyBlockNetworking.BountyServerUpdateType.SET_ACTIVE_CONTRACT);
            buf.method_10794((class_2487)ContractInProgress.SERVER_CODEC.encode((Object)contractProgress, (DynamicOps)class_2509.field_11560, (Object)new class_2487()).get().left().get());
            buf.method_10794((class_2487)Contract.CODEC.encode((Object)contractProgress.s_getContract(), (DynamicOps)class_2509.field_11560, (Object)new class_2487()).get().left().get());
        }
    }

    public static void s_writeUpdateContracts(class_2540 friendlyByteBuf, BountyBoardBlockEntity blockEntity) {
        friendlyByteBuf.method_10817((Enum)BountyBlockNetworking.BountyServerUpdateType.UPDATE_CONTRACTS);
        friendlyByteBuf.method_10794(blockEntity.getContractsNbt());
    }

    public void s_handleClientAction(class_3222 player, class_2540 buf) {
        BountyBlockNetworking.BountyClientActionType action = (BountyBlockNetworking.BountyClientActionType)buf.method_10818(BountyBlockNetworking.BountyClientActionType.class);
        if (action == BountyBlockNetworking.BountyClientActionType.REROLL) {
            WilderNature.info("Player {} Rerolled", player.method_5820());
            this.s_targetEntity.tryReroll();
            this.s_targetEntity.method_10997();
        }
        if (action == BountyBlockNetworking.BountyClientActionType.CONFIRM_CONTRACT) {
            boolean hasContract;
            ContractInProgress playerContract = ContractInProgress.progressPerPlayer.get(player.method_5667());
            boolean bl = hasContract = playerContract == null;
            if (!hasContract) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Error: you already have contract"));
                return;
            }
            byte id = buf.readByte();
            class_2960 contract = this.s_targetEntity.getContracts()[id];
            this.s_targetEntity.setRandomContactInSlot(id);
            class_2540 newBuf = new class_2540((ByteBuf)new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 0, 32768));
            class_1799 stack = Contract.fromId(contract).contractStack();
            stack.method_7980(new class_2487());
            assert (stack.method_7969() != null);
            stack.method_7969().method_10582("contract_id", contract.toString());
            stack.method_7969().method_25927("player_uuid", player.method_5667());
            player.method_37908().method_8503().execute(() -> player.method_5775(stack));
            ContractInProgress.progressPerPlayer.put(player.method_5667(), new ContractInProgress(contract, Contract.fromId(contract).count(), this.s_targetEntity.boardId));
            newBuf.method_10817((Enum)BountyBlockNetworking.BountyServerUpdateType.MULTI);
            newBuf.writeShort(2);
            BountyBlockScreenHandler.s_writeActiveContractInfo(newBuf, player);
            BountyBlockScreenHandler.s_writeUpdateContracts(newBuf, this.s_targetEntity);
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)BountyBlockNetworking.ID_SCREEN_UPDATE, (class_2540)newBuf);
        }
        if (action == BountyBlockNetworking.BountyClientActionType.FINISH_CONTRACT) {
            ContractInProgress contract = ContractInProgress.progressPerPlayer.get(player.method_5667());
            if (contract == null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Error: player does not have a contract"));
                return;
            }
            if (!contract.isFinished()) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Error: contract is not finished"));
                return;
            }
            player.method_43496((class_2561)class_2561.method_43469((String)"text.gui.wildernature.bounty.finished", (Object[])new Object[]{class_2561.method_43471((String)contract.s_getContract().name())}));
            ContractInProgress.progressPerPlayer.remove(player.method_5667());
            contract.onFinish(player);
            class_2540 newBuf = new class_2540((ByteBuf)new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 0, 32768));
            BountyBlockScreenHandler.s_writeActiveContractInfo(newBuf, player);
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)BountyBlockNetworking.ID_SCREEN_UPDATE, (class_2540)newBuf);
        }
        this.s_targetEntity.method_5431();
    }

    private static BountyBlockScreenHandler c_createClient(int id, class_1661 inventory) {
        return new BountyBlockScreenHandler(id, inventory, null);
    }

    public void c_onServerUpdate(class_2540 buf) {
        BountyBlockNetworking.BountyServerUpdateType updateType = (BountyBlockNetworking.BountyServerUpdateType)buf.method_10818(BountyBlockNetworking.BountyServerUpdateType.class);
        try {
            Platform.isDevelopmentEnvironment();
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.MULTI) {
                int count = buf.readShort();
                for (int i = 0; i < count; ++i) {
                    this.c_onServerUpdate(buf);
                }
            }
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.UPDATE_CONTRACTS) {
                this.c_contracts = ((List)((Pair)Contract.CODEC.listOf().decode((DynamicOps)class_2509.field_11560, (Object)Objects.requireNonNull(buf.method_10798()).method_10580("list")).getOrThrow(false, er -> {
                    throw new RuntimeException((String)er);
                })).getFirst()).toArray(new Contract[3]);
                this.c_onContractUpdate.invoke();
            }
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.SEND_BOARD_DATA) {
                this.c_time = buf.readInt();
                this.c_rerolls = buf.readByte();
                this.c_boardId = buf.readLong();
                this.c_tierId = buf.method_10810();
                this.c_progress = buf.readFloat();
            }
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.SET_ACTIVE_CONTRACT) {
                if (Platform.isDevelopmentEnvironment()) {
                    class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"_handling SET_ACTIVE_CONTRACT"));
                }
                class_2487 nbt = buf.method_10798();
                ContractInProgress contractProgress = (ContractInProgress)((Pair)ContractInProgress.SERVER_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow(false, er -> {
                    throw new RuntimeException((String)er);
                })).getFirst();
                nbt = buf.method_10798();
                Contract contract = (Contract)((Pair)Contract.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow(false, er -> {
                    throw new RuntimeException((String)er);
                })).getFirst();
                if (Platform.isDevelopmentEnvironment()) {
                    class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"_active contract: %b".formatted(contractProgress)));
                }
                this.c_activeContractProgress = contractProgress;
                this.c_activeContract = contract;
            }
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.CLEAR_ACTIVE_CONTRACT) {
                this.c_activeContractProgress = null;
                this.c_activeContract = null;
            }
        }
        catch (Exception e) {
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Error handling %s screen update packet: %s".formatted(updateType.toString(), e.getMessage())));
            throw new RuntimeException(e);
        }
    }
}

