/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3532;
import net.minecraft.class_3855;
import net.minecraft.class_3966;
import net.satisfy.wildernature.item.AmmunitionItem;
import net.satisfy.wildernature.network.EntityPacketHandler;
import net.satisfy.wildernature.registry.EntityRegistry;
import org.jetbrains.annotations.NotNull;

public class BulletEntity
extends class_3855 {
    private static final double STOP_TRESHOLD = 0.01;
    private static final double GRAVITY = 0.05;
    private double damage = 1.0;
    private boolean ignoreInvulnerability = false;
    private double knockbackStrength = 0.0;
    private int ticksSinceFired;
    private class_243 initialPosition;

    public BulletEntity(class_1299<? extends class_3855> entityType, class_1937 level) {
        super(entityType, level);
    }

    public BulletEntity(class_1937 worldIn, class_1309 shooter) {
        this(worldIn, shooter, 0.0, 0.0, 0.0);
        this.method_5814(shooter.method_23317(), shooter.method_23320() - 0.1, shooter.method_23321());
        this.initialPosition = new class_243(shooter.method_23317(), shooter.method_23320() - 0.1, shooter.method_23321());
    }

    public BulletEntity(class_1937 worldIn, class_1309 shooter, double accelX, double accelY, double accelZ) {
        super((class_1299)EntityRegistry.BULLET.get(), shooter, accelX, accelY, accelZ, worldIn);
        this.initialPosition = new class_243(shooter.method_23317(), shooter.method_23320() - 0.1, shooter.method_23321());
    }

    public void method_5773() {
        double distanceTraveled;
        if (this.initialPosition == null) {
            this.initialPosition = this.method_19538();
        }
        ++this.ticksSinceFired;
        if (this.ticksSinceFired > 100 || this.method_18798().method_1027() < 0.01) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
        if ((distanceTraveled = this.method_19538().method_1022(this.initialPosition)) > 20.0) {
            class_243 movement = this.method_18798();
            this.method_18799(movement.method_1031(0.0, -0.05, 0.0));
        }
        super.method_5773();
    }

    protected void method_7454(class_3966 raytrace) {
        super.method_7454(raytrace);
        if (!this.method_37908().field_9236) {
            boolean damaged;
            class_1297 target = raytrace.method_17782();
            class_1297 shooter = this.method_24921();
            AmmunitionItem bullet = (AmmunitionItem)this.method_16938().method_7909();
            if (this.method_5809()) {
                target.method_5639(5);
            }
            int lastHurtResistant = target.field_6008;
            if (this.ignoreInvulnerability) {
                target.field_6008 = 0;
            }
            if ((damaged = target.method_5643(this.method_37908().method_48963().method_48815((class_1297)this, shooter), (float)bullet.modifyDamage(this.damage, this, target, shooter, this.method_37908()))) && target instanceof class_1309) {
                class_243 vec;
                class_1309 livingTarget = (class_1309)target;
                if (this.knockbackStrength > 0.0 && (vec = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021(this.knockbackStrength)).method_1027() > 0.0) {
                    livingTarget.method_5762(vec.field_1352, 0.1, vec.field_1350);
                }
                if (shooter instanceof class_1309) {
                    this.method_5723((class_1309)shooter, target);
                }
                AmmunitionItem.onLivingEntityHit(livingTarget, shooter, this.method_37908());
            } else if (!damaged && this.ignoreInvulnerability) {
                target.field_6008 = lastHurtResistant;
            }
        }
    }

    protected void method_7488(class_239 result) {
        super.method_7488(result);
        if (!(this.method_37908().field_9236 || this.field_5960 && result.method_17783() == class_239.class_240.field_1332)) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("tickssincefired", this.ticksSinceFired);
        compound.method_10549("damage", this.damage);
        if (this.ignoreInvulnerability) {
            compound.method_10556("ignoreinvulnerability", true);
        }
        if (this.knockbackStrength != 0.0) {
            compound.method_10549("knockback", this.knockbackStrength);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.ticksSinceFired = compound.method_10550("tickssincefired");
        this.damage = compound.method_10574("damage");
        this.ignoreInvulnerability = compound.method_10577("ignoreinvulnerability");
        this.knockbackStrength = compound.method_10574("knockback");
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public void setIgnoreInvulnerability(boolean ignoreInvulnerability) {
        this.ignoreInvulnerability = ignoreInvulnerability;
    }

    public void method_24919(class_1297 shooter, float xRot, float yRot, float p_37255_, float speed, float spread) {
        float f = -class_3532.method_15374((float)(yRot * ((float)Math.PI / 180))) * class_3532.method_15362((float)(xRot * ((float)Math.PI / 180)));
        float f1 = -class_3532.method_15374((float)((xRot + p_37255_) * ((float)Math.PI / 180)));
        float f2 = class_3532.method_15362((float)(yRot * ((float)Math.PI / 180))) * class_3532.method_15362((float)(xRot * ((float)Math.PI / 180)));
        this.method_7485(f, f1, f2, speed, spread);
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return false;
    }

    protected float method_7466() {
        return 1.0f;
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return EntityPacketHandler.createAddEntityPacket((class_1297)this);
    }
}

