/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1604;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeerEntity
extends class_1429 {
    private static final int FLAG_RUNNING = 256;
    private static final int FLAG_EATING = 65536;
    private static final int FLAG_LOOKING_AROUND = 16;
    private static final class_2940<Integer> DATA_TYPE_ID = class_2945.method_12791(DeerEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DATA_FLAGS_ID = class_2945.method_12791(DeerEntity.class, (class_2941)class_2943.field_13327);
    public final class_7094 idleState = new class_7094();
    public final class_7094 lookAroundState = new class_7094();
    public final class_7094 eatingState = new class_7094();
    private int idleAnimationTimeout = 0;
    public int globalCooldown = 0;

    public DeerEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.270000011920929).method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23721, 1.5);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_TYPE_ID, (Object)0);
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
    }

    protected void method_48565(float pPartialTick) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    protected void method_5959() {
        int i = 0;
        this.field_6201.method_6277(++i, new DeerAvoidEntityGoal<class_1646>(this, class_1646.class));
        this.field_6201.method_6277(++i, new DeerAvoidEntityGoal<class_1604>(this, class_1604.class));
        this.field_6201.method_6277(++i, new DeerAvoidEntityGoal<class_1657>(this, class_1657.class));
        this.field_6201.method_6277(++i, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.15));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.2, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8602}), false));
        this.field_6201.method_6277(3, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f));
        this.field_6201.method_6277(6, (class_1352)new DeerEatingGoal(this));
        this.field_6201.method_6277(7, (class_1352)new DeerLookAroundGoal(this));
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return this.method_6109() ? entityDimensions.field_18068 * 0.4f : entityDimensions.field_18068 * 0.5f;
    }

    protected class_3414 method_5994() {
        return (class_3414)SoundRegistry.DEER_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)SoundRegistry.DEER_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)SoundRegistry.DEER_DEATH.get();
    }

    @Nullable
    public DeerEntity getBreedOffspring(class_3218 serverLevel, class_1296 ageableMob) {
        return (DeerEntity)((class_1299)EntityRegistry.DEER.get()).method_5883((class_1937)serverLevel);
    }

    public boolean method_6481(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8602);
    }

    public void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
            this.idleState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((Integer)this.field_6011.method_12789(DATA_FLAGS_ID) | i));
        } else {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((Integer)this.field_6011.method_12789(DATA_FLAGS_ID) & ~i));
        }
    }

    private boolean getFlag(int i) {
        return ((Integer)this.field_6011.method_12789(DATA_FLAGS_ID) & i) != 0;
    }

    public void startEating() {
        this.setFlag(65536, true);
    }

    public void stopEating() {
        this.setFlag(65536, false);
    }

    public boolean isEating() {
        return this.getFlag(65536);
    }

    public void startLookingAround() {
        this.setFlag(16, true);
    }

    public void stopLookingAround() {
        this.setFlag(16, false);
    }

    public boolean isLookingAround() {
        return this.getFlag(16);
    }

    public boolean isDeerRunning() {
        return this.getFlag(256);
    }

    public void startRunningAnim() {
        this.setFlag(256, true);
    }

    public void stopRunningAnim() {
        this.setFlag(256, false);
    }

    public void method_5773() {
        super.method_5773();
        if (this.globalCooldown > 0) {
            --this.globalCooldown;
        }
        this.eatingState.method_45317(this.isEating(), this.field_6012);
        this.lookAroundState.method_45317(this.isLookingAround(), this.field_6012);
        if (this.method_37908().field_9236) {
            this.setupAnimationStates();
        }
    }

    public static class DeerAvoidEntityGoal<T extends class_1309>
    extends class_1338<T> {
        private final DeerEntity deer;

        public DeerAvoidEntityGoal(DeerEntity deer, Class<T> tClass) {
            super((class_1314)deer, tClass, 16.0f, 2.0, 2.0);
            this.deer = deer;
        }

        public boolean method_6264() {
            if (this.field_6390 instanceof class_1657 && this.field_6390.method_18276()) {
                return false;
            }
            return super.method_6264();
        }

        public void method_6269() {
            this.deer.startRunningAnim();
            super.method_6269();
        }

        public void method_6270() {
            this.deer.stopRunningAnim();
            super.method_6270();
        }
    }

    public static class DeerEatingGoal
    extends class_1352 {
        private final DeerEntity target;
        private int counter;
        private static final int EATING_DURATION_TICKS = 37;
        private static final int COOLDOWN_TICKS = 400;
        public static final class_1322 modifier = new class_1322("deer_eat_do_not_move", -1000.0, class_1322.class_1323.field_6328);

        public DeerEatingGoal(DeerEntity mob) {
            this.target = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
        }

        public boolean method_38846() {
            return true;
        }

        public boolean method_6267() {
            return true;
        }

        public boolean method_6264() {
            float r = new Random().nextFloat();
            return r < 0.01f && !this.target.isDeerRunning() && this.target.globalCooldown == 0;
        }

        public boolean method_6266() {
            return this.counter < 37 && !this.target.isDeerRunning();
        }

        public void method_6268() {
            ++this.counter;
        }

        public void method_6269() {
            this.counter = 0;
            Objects.requireNonNull(this.target.method_5996(class_5134.field_23719)).method_26835(modifier);
            this.target.startEating();
            super.method_6269();
        }

        public void method_6270() {
            Objects.requireNonNull(this.target.method_5996(class_5134.field_23719)).method_6202(modifier);
            this.target.stopEating();
            this.target.globalCooldown = 400;
            super.method_6270();
        }
    }

    public static class DeerLookAroundGoal
    extends class_1352 {
        private final DeerEntity target;
        private int counter;
        private static final int LOOK_AROUND_DURATION_TICKS = 70;
        private static final int COOLDOWN_TICKS = 400;
        public static final class_1322 modifier = new class_1322("deer_look_around_do_not_move", -1000.0, class_1322.class_1323.field_6328);

        public DeerLookAroundGoal(DeerEntity mob) {
            this.target = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
        }

        public boolean method_38846() {
            return true;
        }

        public boolean method_6267() {
            return true;
        }

        public boolean method_6264() {
            float r = new Random().nextFloat();
            return r < 0.01f && !this.target.isDeerRunning() && this.target.globalCooldown == 0;
        }

        public boolean method_6266() {
            return this.counter < 70 && !this.target.isDeerRunning();
        }

        public void method_6268() {
            ++this.counter;
        }

        public void method_6269() {
            this.counter = 0;
            Objects.requireNonNull(this.target.method_5996(class_5134.field_23719)).method_26835(modifier);
            this.target.startLookingAround();
            super.method_6269();
        }

        public void method_6270() {
            Objects.requireNonNull(this.target.method_5996(class_5134.field_23719)).method_6202(modifier);
            this.target.stopLookingAround();
            this.target.globalCooldown = 400;
            super.method_6270();
        }
    }
}

