/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1331;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1403;
import net.minecraft.class_1404;
import net.minecraft.class_1406;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1471;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5532;
import net.minecraft.class_5534;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.satisfy.wildernature.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.entity.ai.FlyingFollowOwnerGoal;
import net.satisfy.wildernature.entity.ai.PredicateTemptGoal;
import net.satisfy.wildernature.entity.ai.RandomAction;
import net.satisfy.wildernature.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import net.satisfy.wildernature.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OwlEntity
extends class_1471
implements EntityWithAttackAnimation {
    private static final class_2940<Integer> STANDING_STATE = class_2945.method_12791(OwlEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> OWL_STATE = class_2945.method_12791(OwlEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> ATTACKING = class_2945.method_12791(OwlEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HOOTING = class_2945.method_12791(OwlEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(OwlEntity.class, (class_2941)class_2943.field_13323);
    private static final class_4048 FLYING_DIMENSION = new class_4048(0.7f, 1.4f, false);
    private static final Predicate<class_1309> IS_OWL_TARGET = e -> e.method_5864().method_20210(TagsRegistry.OWL_TARGETS);
    private float leaningPitch;
    private float lastLeaningPitch;
    public class_7094 flyingState = new class_7094();
    public class_7094 hootState = new class_7094();
    public class_7094 attackState = new class_7094();
    public class_7094 sleepState = new class_7094();

    public OwlEntity(class_1299<? extends class_1471> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 0, false);
        this.method_5941(class_7.field_3, -1.0f);
        this.method_5941(class_7.field_9, -1.0f);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23720, 0.8).method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23721, 2.0);
    }

    protected void method_5959() {
        super.method_5959();
        int i = 0;
        this.field_6201.method_6277(++i, (class_1352)new class_1338<class_1657>((class_1314)this, class_1657.class, 32.0f, 2.0, 2.0){

            public boolean method_6264() {
                return super.method_6264() && OwlEntity.this.isInPanicRightNow();
            }
        });
        this.field_6201.method_6277(++i, (class_1352)new class_1374((class_1314)this, 1.75){

            protected boolean method_6301() {
                class_243 vec3 = class_5532.method_31510((class_1314)this.field_6549, (int)20, (int)20);
                if (vec3 == null) {
                    return false;
                }
                this.field_6547 = vec3.field_1352;
                this.field_6546 = vec3.field_1351;
                this.field_6550 = vec3.field_1350;
                return true;
            }
        });
        this.field_6201.method_6277(++i, (class_1352)new SleepGoal(this));
        this.field_6201.method_6277(++i, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(++i, (class_1352)new class_1347((class_1308)this){

            public boolean method_6264() {
                return super.method_6264() && !OwlEntity.this.method_6113();
            }

            public boolean method_6266() {
                return super.method_6266() && !OwlEntity.this.method_6113();
            }
        });
        this.field_6201.method_6277(++i, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(++i, (class_1352)new AnimationAttackGoal(this, 1.0, true, (int)ServerAnimationDurations.owl_attack * 20, 15){

            public boolean method_6264() {
                return super.method_6264() && !OwlEntity.this.method_6113();
            }

            @Override
            public boolean method_6266() {
                return super.method_6266() && !OwlEntity.this.method_6113();
            }
        });
        this.field_6201.method_6277(++i, (class_1352)new FlyingFollowOwnerGoal((class_1321)this, 1.2, 10.0f, 2.0f, true){

            @Override
            public boolean method_6264() {
                return super.method_6264() && !OwlEntity.this.method_6113();
            }

            @Override
            public boolean method_6266() {
                return super.method_6266() && !OwlEntity.this.method_6113();
            }
        });
        this.field_6201.method_6277(++i, (class_1352)new PredicateTemptGoal((class_1314)this, 1.2, this::method_6481, false){

            @Override
            public boolean method_6264() {
                return super.method_6264() && !OwlEntity.this.method_6113();
            }

            @Override
            public boolean method_6266() {
                return super.method_6266() && !OwlEntity.this.method_6113();
            }
        });
        this.field_6201.method_6277(++i, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(++i, (class_1352)new ExtendedFlyOntoTree((class_1314)this, 1.0, 0.5f));
        this.field_6201.method_6277(++i, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(++i, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(++i, (class_1352)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return false;
            }

            @Override
            public void onStop() {
                OwlEntity.this.setHooting(false);
            }

            @Override
            public void onStart() {
                if (OwlEntity.this.method_24828()) {
                    OwlEntity.this.setHooting(true);
                }
                class_3414 owlSound = (class_3414)SoundRegistry.OWL_AMBIENT.get();
                OwlEntity.this.method_37908().method_43129(null, (class_1297)OwlEntity.this, owlSound, class_3419.field_15254, 1.0f, 1.0f);
            }

            @Override
            public boolean isPossible() {
                return !OwlEntity.this.isAttacking() && !OwlEntity.this.method_6113();
            }

            @Override
            public int duration() {
                return (int)(ServerAnimationDurations.owl_hoot * 20.0f);
            }

            @Override
            public float chance() {
                return 0.01f;
            }

            @Override
            public class_1324 getAttribute(class_1320 movementSpeed) {
                return OwlEntity.this.method_5996(movementSpeed);
            }
        }));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, class_1309.class, false, IS_OWL_TARGET));
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        OwlEntity owl = (OwlEntity)((class_1299)EntityRegistry.OWL.get()).method_5883((class_1937)serverLevel);
        UUID uUID = this.method_6139();
        if (uUID != null) {
            assert (owl != null);
            owl.method_6174(uUID);
            owl.method_6173(true);
        }
        return owl;
    }

    @NotNull
    protected class_1408 method_5965(class_1937 level) {
        class_1407 birdNavigation = new class_1407((class_1308)this, level);
        birdNavigation.method_6331(true);
        birdNavigation.method_6354(false);
        birdNavigation.method_6332(false);
        return birdNavigation;
    }

    public float method_6024(float f) {
        return class_3532.method_17821((float)f, (float)this.lastLeaningPitch, (float)this.leaningPitch);
    }

    public void method_5773() {
        super.method_5773();
        this.setStandingState(this.method_24828() || this.method_5799() || this.method_24345() ? StandingState.STANDING : StandingState.FLYING);
        this.lastLeaningPitch = this.leaningPitch;
        switch (this.getStandingState()) {
            case STANDING: {
                this.leaningPitch = Math.max(0.0f, this.leaningPitch - 2.0f);
                break;
            }
            case FLYING: {
                this.leaningPitch = Math.min(7.0f, this.leaningPitch + 1.5f);
            }
        }
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        StandingState standingState = this.getStandingState();
        OwlState owlState = this.getOwlState();
        this.flyingState.method_45317(standingState == StandingState.FLYING, this.field_6012);
        this.attackState.method_45317(this.isAttacking(), this.field_6012);
        this.hootState.method_45317(this.isHooting(), this.field_6012);
        this.sleepState.method_45317(this.method_6113(), this.field_6012);
    }

    private boolean isHooting() {
        return (Boolean)this.field_6011.method_12789(HOOTING);
    }

    private void setHooting(boolean hooting) {
        this.field_6011.method_12778(HOOTING, (Object)hooting);
    }

    public void method_6007() {
        super.method_6007();
        class_243 velocity = this.method_18798();
        if (!this.method_24828() && velocity.field_1351 < 0.0) {
            this.method_18799(velocity.method_18805(1.0, 0.75, 1.0));
        }
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(20.0);
            Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_6192(4.0);
            this.method_6033(20.0f);
        } else {
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(6.0);
            Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_6192(2.0);
        }
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (this.method_6181()) {
            if (this.method_6481(stack) && this.method_6032() < this.method_6063()) {
                if (!this.method_37908().method_8608()) {
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    this.method_6025(Objects.requireNonNull(item.method_19264()).method_19230());
                }
                return class_1269.field_5812;
            }
            class_1269 actionResult = super.method_5992(player, hand);
            if ((!actionResult.method_23665() || this.method_6109()) && this.method_6171((class_1309)player)) {
                if (!this.method_37908().method_8608()) {
                    this.method_24346(!this.method_24345());
                    this.field_6282 = false;
                    this.field_6189.method_6340();
                    this.method_5980(null);
                }
                return class_1269.field_5812;
            }
            return actionResult;
        }
        if (this.method_6481(stack) && this.method_5968() == null) {
            if (!this.method_37908().method_8608()) {
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                if (this.field_5974.method_43048(3) == 0) {
                    this.method_6170(player);
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    this.method_24346(true);
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)6);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_6481(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item.method_19263() && Objects.requireNonNull(item.method_19264()).method_19232();
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("OwlState", ((Integer)this.method_5841().method_12789(OWL_STATE)).intValue());
        tag.method_10569("StandingState", ((Integer)this.method_5841().method_12789(STANDING_STATE)).intValue());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setOwlState(OwlState.values()[tag.method_10550("OwlState")]);
        this.setStandingState(StandingState.values()[tag.method_10550("StandingState")]);
    }

    @NotNull
    public class_4048 method_18377(class_4050 pose) {
        return this.getStandingState() == StandingState.STANDING ? super.method_18377(pose) : FLYING_DIMENSION;
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(STANDING_STATE, (Object)0);
        this.method_5841().method_12784(OWL_STATE, (Object)0);
        this.method_5841().method_12784(ATTACKING, (Object)false);
        this.method_5841().method_12784(HOOTING, (Object)false);
        this.method_5841().method_12784(SLEEPING, (Object)false);
    }

    public boolean method_5747(float f, float g, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double d, boolean bl, class_2680 blockState, class_2338 blockPos) {
    }

    public StandingState getStandingState() {
        return StandingState.values()[(Integer)this.method_5841().method_12789(STANDING_STATE)];
    }

    public void setStandingState(StandingState standingState) {
        this.method_5841().method_12778(STANDING_STATE, (Object)standingState.ordinal());
    }

    public OwlState getOwlState() {
        return OwlState.values()[(Integer)this.method_5841().method_12789(OWL_STATE)];
    }

    public void setOwlState(OwlState owlState) {
        this.method_5841().method_12778(OWL_STATE, (Object)owlState.ordinal());
    }

    protected class_3414 method_6002() {
        return (class_3414)SoundRegistry.OWL_DEATH.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return null;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)SoundRegistry.OWL_HURT.get();
    }

    @Override
    public class_1309 getTarget_() {
        return this.method_5968();
    }

    @Override
    public double getMeleeAttackRangeSqr_(class_1309 target) {
        return this.method_33191(target);
    }

    @Override
    public void setAttacking_(boolean b) {
        this.field_6011.method_12778(ATTACKING, (Object)b);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    @Override
    public class_243 getPosition_(int i) {
        return super.method_30950((float)i);
    }

    @Override
    public void doHurtTarget_(class_1309 targetEntity) {
        super.method_6121((class_1297)targetEntity);
    }

    private void setSleeping(boolean b) {
        this.field_6011.method_12778(SLEEPING, (Object)b);
    }

    public boolean isInPanicRightNow() {
        return this.method_6065() != null || this.method_5809();
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    private static class SleepGoal
    extends class_1352 {
        private final OwlEntity owl;

        public SleepGoal(OwlEntity owlEntity) {
            this.owl = owlEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            return this.owl.method_37908().method_8530() && !this.owl.isInPanicRightNow();
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public boolean method_6267() {
            return false;
        }

        public void method_6269() {
            super.method_6269();
            this.owl.setSleeping(true);
        }

        public void method_6268() {
            super.method_6268();
        }

        public void method_6270() {
            super.method_6270();
            this.owl.setSleeping(false);
        }
    }

    private static class ExtendedFlyOntoTree
    extends class_1394 {
        public ExtendedFlyOntoTree(class_1314 pathAwareEntity, double speed, float probability) {
            super(pathAwareEntity, speed, probability);
        }

        protected class_243 method_6302() {
            class_243 vec3d = null;
            if (this.field_6566.method_5816()) {
                vec3d = class_5534.method_31527((class_1314)this.field_6566, (int)15, (int)7);
            }
            if (this.field_6566.method_6051().method_43057() >= this.field_6626) {
                vec3d = this.getTreeTarget();
            }
            return vec3d == null ? super.method_6302() : vec3d;
        }

        private class_243 getTreeTarget() {
            class_2680 blockState;
            boolean bl;
            class_2338 blockPos2;
            class_2338 blockPos = this.field_6566.method_23312();
            class_2338.class_2339 mutable = new class_2338.class_2339();
            class_2338.class_2339 mutable2 = new class_2338.class_2339();
            Iterable iterable = class_2338.method_10094((int)class_3532.method_15357((double)(this.field_6566.method_23317() - 3.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23318() - 6.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23321() - 3.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23317() + 3.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23318() + 6.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23321() + 3.0)));
            Iterator var5 = iterable.iterator();
            do {
                if (var5.hasNext()) continue;
                return null;
            } while (blockPos.equals((Object)(blockPos2 = (class_2338)var5.next())) || !(bl = (blockState = this.field_6566.method_37908().method_8320((class_2338)mutable2.method_25505((class_2382)blockPos2, class_2350.field_11033))).method_26204() instanceof class_2397 || blockState.method_26164(class_3481.field_15475)) || !this.field_6566.method_37908().method_22347(blockPos2) || !this.field_6566.method_37908().method_22347((class_2338)mutable.method_25505((class_2382)blockPos2, class_2350.field_11036)));
            return class_243.method_24955((class_2382)blockPos2);
        }
    }

    public static enum StandingState {
        STANDING,
        FLYING;

    }

    public static enum OwlState {
        IDLE,
        ATTACKING;

    }
}

