/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1343;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.satisfy.wildernature.entity.ai.RandomAction;
import net.satisfy.wildernature.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaccoonEntity
extends class_1429 {
    private static final class_1856 FOOD_ITEMS;
    private static final class_2940<Integer> DATA_TYPE_ID;
    private static final class_2940<Integer> DATA_FLAGS_ID;
    private static final int FLAG_WASHING = 2;
    private static final int FLAG_RUNNING = 256;
    private static final int FLAG_OPENDOOR = 4096;
    public final class_7094 walkState = new class_7094();
    public final class_7094 runState = new class_7094();
    public final class_7094 washingState = new class_7094();
    public final class_7094 openDoorState = new class_7094();
    public int openDoorAnimationTimeout = 0;
    private int ticksSinceEaten;
    private int washTicks;

    public RaccoonEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5829().method_1011(1.0);
        this.method_5942().method_6354(true);
        this.method_5942().method_6342().method_20(true);
        this.method_5942().method_6342().method_15(true);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.20000001192092895).method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23721, 1.5);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_TYPE_ID, (Object)0);
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
    }

    protected void method_5959() {
        int i = 0;
        this.field_6201.method_6277(++i, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(++i, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(++i, (class_1352)new RaccoonDoorInteractGoal(this));
        this.field_6201.method_6277(++i, new RaccoonAvoidEntityGoal<class_1657>(this, class_1657.class));
        this.field_6201.method_6277(++i, new RaccoonAvoidEntityGoal<class_1646>(this, class_1646.class));
        this.field_6201.method_6277(++i, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(++i, (class_1352)new class_1391((class_1314)this, 1.0, FOOD_ITEMS, false));
        this.field_6201.method_6277(++i, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(++i, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(++i, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(++i, (class_1352)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return true;
            }

            @Override
            public void onStop() {
                RaccoonEntity.this.stopWash();
            }

            @Override
            public void onStart() {
                RaccoonEntity.this.startWash();
            }

            @Override
            public boolean isPossible() {
                return !RaccoonEntity.this.isRaccoonRunning();
            }

            @Override
            public int duration() {
                return 48;
            }

            @Override
            public float chance() {
                return 0.01f;
            }

            @Override
            public class_1324 getAttribute(class_1320 movementSpeed) {
                return RaccoonEntity.this.method_5996(movementSpeed);
            }
        }));
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.openDoorState.method_45317(this.isOpeningDoor(), this.field_6012);
            this.washingState.method_45317(this.isWashing(), this.field_6012);
        }
    }

    private boolean isOpeningDoor() {
        return this.getFlag(4096);
    }

    public void method_6007() {
        if (!this.method_37908().field_9236 && this.method_5805() && this.method_6034()) {
            ++this.ticksSinceEaten;
            class_1799 itemStack = this.method_6118(class_1304.field_6173);
            if (this.method_6481(itemStack)) {
                if (this.ticksSinceEaten > 600) {
                    class_1799 itemStack2 = itemStack.method_7910(this.method_37908(), (class_1309)this);
                    if (!itemStack2.method_7960()) {
                        this.method_5673(class_1304.field_6173, itemStack2);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.field_5974.method_43057() < 0.1f) {
                    this.method_5783(this.method_18869(itemStack), 1.0f, 1.0f);
                    this.method_37908().method_8421((class_1297)this, (byte)45);
                }
            }
        }
        if (this.method_6113() || this.method_6062()) {
            this.field_6282 = false;
            this.field_6212 = 0.0f;
            this.field_6250 = 0.0f;
        }
        super.method_6007();
        if (this.isDefending() && this.field_5974.method_43057() < 0.05f) {
            this.method_5783((class_3414)SoundRegistry.RACCOON_AMBIENT.get(), 1.0f, 1.0f);
        } else {
            this.washTicks = 0;
        }
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return this.method_6109() ? entityDimensions.field_18068 * 0.4f : entityDimensions.field_18068 * 0.5f;
    }

    @NotNull
    public class_4048 method_18377(class_4050 pose) {
        return new class_4048(0.1f, 0.1f, false);
    }

    public void method_18382() {
        super.method_18382();
    }

    protected class_3414 method_5994() {
        return (class_3414)SoundRegistry.RACCOON_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)SoundRegistry.RACCOON_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)SoundRegistry.RACCOON_DEATH.get();
    }

    @Nullable
    public RaccoonEntity getBreedOffspring(class_3218 serverLevel, class_1296 ageableMob) {
        return (RaccoonEntity)((class_1299)EntityRegistry.RACCOON.get()).method_5883((class_1937)serverLevel);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    public boolean method_6113() {
        return this.getFlag(32);
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((Integer)this.field_6011.method_12789(DATA_FLAGS_ID) | i));
        } else {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((Integer)this.field_6011.method_12789(DATA_FLAGS_ID) & ~i));
        }
    }

    private boolean getFlag(int i) {
        return ((Integer)this.field_6011.method_12789(DATA_FLAGS_ID) & i) != 0;
    }

    public boolean method_6481(class_1799 itemStack) {
        return FOOD_ITEMS.method_8093(itemStack);
    }

    public void startWash() {
        this.setFlag(2, true);
    }

    public void stopWash() {
        this.setFlag(2, false);
    }

    public boolean isWashing() {
        return this.getFlag(2);
    }

    public boolean isRaccoonRunning() {
        return this.getFlag(256);
    }

    public void startRunningAnim() {
        this.setFlag(256, true);
    }

    public void stopRunningAnim() {
        this.setFlag(256, false);
    }

    public void startOpenDoorAnim() {
        this.setFlag(4096, true);
    }

    public void stopOpenDoorAnim() {
        this.setFlag(4096, false);
    }

    static {
        DATA_TYPE_ID = class_2945.method_12791(RaccoonEntity.class, (class_2941)class_2943.field_13327);
        DATA_FLAGS_ID = class_2945.method_12791(RaccoonEntity.class, (class_2941)class_2943.field_13327);
        FOOD_ITEMS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8279, class_1802.field_8186, class_1802.field_16998, class_1802.field_8567, class_1802.field_8373, class_1802.field_8509, class_1802.field_8179});
    }

    public static class RaccoonDoorInteractGoal
    extends class_1343 {
        private final RaccoonEntity raccoon;
        public static final class_1322 modifier = new class_1322("racoon_door_do_not_move", -1000.0, class_1322.class_1323.field_6328);
        int counter = 0;

        public RaccoonDoorInteractGoal(RaccoonEntity raccoon) {
            super((class_1308)raccoon);
            this.raccoon = raccoon;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            return super.method_6264();
        }

        public void method_6269() {
            this.counter = 0;
            Objects.requireNonNull(this.raccoon.method_5996(class_5134.field_23719)).method_26835(modifier);
            super.method_6269();
            this.raccoon.startOpenDoorAnim();
        }

        public boolean method_6266() {
            return this.counter > 0 && this.counter < ServerAnimationDurations.raccoon_opening_door_length && (!this.method_6256() || this.counter >= ServerAnimationDurations.raccoon_opening_door_tick);
        }

        public void method_6268() {
            this.raccoon.method_37908().method_8320(this.field_6414).method_26218((class_1922)this.raccoon.method_37908().method_22350(this.field_6414), this.field_6414).method_1107().method_1005();
            if (this.method_6266()) {
                this.raccoon.startOpenDoorAnim();
            } else {
                this.raccoon.stopOpenDoorAnim();
            }
            if (this.counter < ServerAnimationDurations.raccoon_opening_door_length) {
                ++this.counter;
            }
            if (this.counter == ServerAnimationDurations.raccoon_opening_door_tick) {
                this.method_19995(true);
            }
            if (this.counter == ServerAnimationDurations.raccoon_opening_door_length) {
                super.method_6268();
            }
        }

        public void method_6270() {
            Objects.requireNonNull(this.raccoon.method_5996(class_5134.field_23719)).method_6202(modifier);
            this.counter = 0;
            super.method_6270();
            this.method_19995(true);
            this.raccoon.stopOpenDoorAnim();
        }
    }

    public static class RaccoonAvoidEntityGoal<T extends class_1309>
    extends class_1338<T> {
        private final RaccoonEntity raccoon;

        public RaccoonAvoidEntityGoal(RaccoonEntity raccoon, Class<T> tClass) {
            super((class_1314)raccoon, tClass, 16.0f, 2.0, 2.0);
            this.raccoon = raccoon;
        }

        public void method_6269() {
            this.raccoon.startRunningAnim();
            super.method_6269();
        }

        public void method_6270() {
            this.raccoon.stopRunningAnim();
            super.method_6270();
        }
    }
}

