/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.fabric;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.fabric.config.ConfigFabric;
import net.satisfy.wildernature.fabric.world.PlacedFeatures;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.ObjectRegistry;
import net.satisfy.wildernature.registry.TagsRegistry;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import net.satisfy.wildernature.util.contract.ContractReloader;
import org.jetbrains.annotations.NotNull;

public class WilderNatureFabric
implements ModInitializer {
    private static Predicate<BiomeSelectionContext> getWilderNatureSelector(String path) {
        return BiomeSelectors.tag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new WilderNatureIdentifier(path)));
    }

    private static Predicate<BiomeSelectionContext> getBloomingNatureSelector() {
        return BiomeSelectors.tag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new WilderNatureIdentifier("spawns_patch_hazelnut_bush")));
    }

    public void onInitialize() {
        AutoConfig.register(ConfigFabric.class, GsonConfigSerializer::new);
        WilderNature.init();
        this.registerFuel();
        WilderNature.commonInit();
        this.addSpawns();
        this.addBiomeModification();
        this.addResourcerLoader();
    }

    void addBiomeModification() {
        ConfigFabric config = (ConfigFabric)AutoConfig.getConfigHolder(ConfigFabric.class).getConfig();
        BiomeModification world = BiomeModifications.create((class_2960)new WilderNatureIdentifier("world_features"));
        Predicate<BiomeSelectionContext> spawns_patch_hazelnut_bush = WilderNatureFabric.getBloomingNatureSelector();
        if (config.spawnHazelnutBush) {
            world.add(ModificationPhase.ADDITIONS, spawns_patch_hazelnut_bush, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PATCH_HAZELNUT_BUSH));
        } else {
            world.add(ModificationPhase.REMOVALS, spawns_patch_hazelnut_bush, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.PATCH_HAZELNUT_BUSH));
        }
    }

    private void addResourcerLoader() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){
            final ContractReloader dataReloader = new ContractReloader();

            public class_2960 getFabricId() {
                return new WilderNatureIdentifier("contractloader");
            }

            @NotNull
            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
                return this.dataReloader.method_25931(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
            }
        });
    }

    private void registerFuel() {
        FuelRegistry.INSTANCE.add((class_1935)ObjectRegistry.FISH_OIL.get(), (Object)1600);
    }

    void addSpawns() {
        ConfigFabric config = (ConfigFabric)AutoConfig.getConfigHolder(ConfigFabric.class).getConfig();
        this.addMobSpawn(TagsRegistry.SPAWNS_PELICAN, (class_1299)EntityRegistry.PELICAN.get(), config.PelicanSpawnWeight, config.PelicanMinGroupSize, config.PelicanMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_DEER, (class_1299)EntityRegistry.DEER.get(), config.DeerSpawnWeight, config.DeerMinGroupSize, config.DeerMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_RACCOON, (class_1299)EntityRegistry.RACCOON.get(), config.RaccoonSpawnWeight, config.RaccoonMinGroupSize, config.RaccoonMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_SQUIRREL, (class_1299)EntityRegistry.SQUIRREL.get(), config.SquirrelSpawnWeight, config.SquirrelMinGroupSize, config.SquirrelMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_RED_WOLF, (class_1299)EntityRegistry.RED_WOLF.get(), config.RedWolfSpawnWeight, config.RedWolfMinGroupSize, config.RedWolfMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_OWL, (class_1299)EntityRegistry.OWL.get(), config.OwlSpawnWeight, config.OwlMinGroupSize, config.OwlMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_BOAR, (class_1299)EntityRegistry.BOAR.get(), config.BoarSpawnWeight, config.BoarMinGroupSize, config.BoarMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_BISON, (class_1299)EntityRegistry.BISON.get(), config.BisonSpawnWeight, config.BisonMinGroupSize, config.BisonMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_TURKEY, (class_1299)EntityRegistry.TURKEY.get(), config.TurkeySpawnWeight, config.TurkeyMinGroupSize, config.TurkeyMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_DOG, (class_1299)EntityRegistry.DOG.get(), config.DogSpawnWeight, config.DogMinGroupSize, config.DogMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_MINISHEEP, (class_1299)EntityRegistry.MINISHEEP.get(), config.MiniSheepSpawnWeight, config.MiniSheepMinGroupSize, config.MiniSheepMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_PENGUIN, (class_1299)EntityRegistry.PENGUIN.get(), config.PenguinSpawnWeight, config.PenguinMinGroupSize, config.PenguinMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_CASSOWARY, (class_1299)EntityRegistry.CASSOWARY.get(), config.CassowarySpawnWeight, config.CassowaryMinGroupSize, config.CassowaryMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_FLAMINGO, (class_1299)EntityRegistry.FLAMINGO.get(), config.FlamingoSpawnWeight, config.FlamingoMinGroupSize, config.FlamingoMaxGroupSize);
        this.addMobSpawn(TagsRegistry.SPAWNS_HEDGEHOG, (class_1299)EntityRegistry.HEDGEHOG.get(), config.HedgehogSpawnWeight, config.HedgehogMinGroupSize, config.HedgehogMaxGroupSize);
        if (config.removeSavannaAnimals) {
            this.removeSpawn((class_6862<class_1959>)class_6908.field_37392, List.of(class_1299.field_6115, class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        }
        if (config.removeForestAnimals) {
            this.removeSpawn((class_6862<class_1959>)class_6908.field_36517, List.of(class_1299.field_6093, class_1299.field_6132));
        }
        if (config.removeSwampAnimals) {
            this.removeSpawn((class_6862<class_1959>)ConventionalBiomeTags.SWAMP, List.of(class_1299.field_6115, class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        }
        if (config.removeJungleAnimals) {
            this.removeSpawn((class_6862<class_1959>)class_6908.field_36516, List.of(class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        }
        if (config.addJungleAnimals) {
            this.addMobSpawn((class_6862<class_1959>)class_6908.field_36516, class_1299.field_37419, 8, 3, 4);
        }
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.SQUIRREL.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.OWL.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13197, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.TURKEY.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.RACCOON.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.PELICAN.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.DEER.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.RED_WOLF.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.BOAR.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.BISON.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.DOG.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.MINISHEEP.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.PENGUIN.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
        class_1317.method_20637((class_1299)((class_1299)EntityRegistry.CASSOWARY.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1308::method_20636);
    }

    void addMobSpawn(class_6862<class_1959> tag, class_1299<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        BiomeModifications.addSpawn(biomeSelector -> biomeSelector.hasTag(tag), (class_1311)class_1311.field_6294, entityType, (int)weight, (int)minGroupSize, (int)maxGroupSize);
    }

    void removeSpawn(class_6862<class_1959> tag, List<class_1299<?>> entityTypes) {
        entityTypes.forEach(entityType -> {
            class_2960 id = class_7923.field_41177.method_10221(entityType);
            Preconditions.checkState((boolean)class_7923.field_41177.method_10250(id), (String)"Unregistered entity tier: %s", (Object)entityType);
            BiomeModifications.create((class_2960)id).add(ModificationPhase.REMOVALS, biomeSelector -> biomeSelector.hasTag(tag), context -> context.getSpawnSettings().removeSpawnsOfEntityType(entityType));
        });
    }
}

