/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import net.satisfy.wildernature.registry.RecipeRegistry;
import net.satisfy.wildernature.registry.TagsRegistry;
import net.satisfy.wildernature.util.Truffling;
import org.jetbrains.annotations.NotNull;

public class TrufflingRecipe
extends class_1852 {
    private final String group;
    private final class_2371<class_1856> ingredients;

    public TrufflingRecipe(class_2960 id, String group, class_2371<class_1856> ingredients) {
        super(id, class_7710.field_40251);
        this.group = group;
        this.ingredients = ingredients;
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(class_8566 pContainer) {
        return class_2371.method_10213((int)pContainer.method_5439(), (Object)class_1799.field_8037);
    }

    public boolean matches(class_8566 craftingContainer, @NotNull class_1937 level) {
        boolean hasFoodInput = false;
        class_2371 matches = class_2371.method_10213((int)this.ingredients.size(), (Object)false);
        int itemsCount = 0;
        for (int slotIndex = 0; slotIndex < craftingContainer.method_5439(); ++slotIndex) {
            class_1799 stackInSlot = craftingContainer.method_5438(slotIndex);
            if (stackInSlot.method_7960()) continue;
            ++itemsCount;
            if ((stackInSlot.method_31573(TagsRegistry.CAN_BE_TRUFFLED) || stackInSlot.method_7909().method_19263()) && !hasFoodInput && !Truffling.isTruffled(stackInSlot)) {
                hasFoodInput = true;
            }
            for (int ingredientIndex = 0; ingredientIndex < this.ingredients.size(); ++ingredientIndex) {
                if (!((class_1856)this.ingredients.get(ingredientIndex)).method_8093(stackInSlot) || ((Boolean)matches.get(ingredientIndex)).booleanValue()) continue;
                matches.set(ingredientIndex, (Object)true);
            }
        }
        return hasFoodInput && matches.stream().allMatch(match -> match) && itemsCount == this.ingredients.size() + 1;
    }

    @NotNull
    public class_1799 assemble(class_8566 craftingContainer, @NotNull class_5455 registryAccess) {
        for (int index = 0; index < craftingContainer.method_5439(); ++index) {
            class_1799 itemStack = craftingContainer.method_5438(index);
            if (!itemStack.method_31573(TagsRegistry.CAN_BE_TRUFFLED) && !itemStack.method_7909().method_19263()) continue;
            class_1799 resultStack = itemStack.method_7972();
            resultStack.method_7939(1);
            return Truffling.setTruffled(resultStack);
        }
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return width >= 2 || height >= 2;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeRegistry.TRUFFLING.get();
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public static class Serializer
    implements class_1865<TrufflingRecipe> {
        @NotNull
        public TrufflingRecipe fromJson(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            return new TrufflingRecipe(recipeId, group, this.getIngredients(json));
        }

        private class_2371<class_1856> getIngredients(JsonObject json) {
            JsonArray jsonArray = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < jsonArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)jsonArray.get(i));
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for truffling recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for truffling recipe. The maximum is 9");
            }
            return ingredients;
        }

        @NotNull
        public TrufflingRecipe fromNetwork(@NotNull class_2960 recipeID, class_2540 buffer) {
            String group = buffer.method_19772();
            int ingredientsCount = buffer.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)ingredientsCount, (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            return new TrufflingRecipe(recipeID, group, (class_2371<class_1856>)ingredients);
        }

        public void toNetwork(class_2540 buffer, TrufflingRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                ingredient.method_8088(buffer);
            }
        }
    }
}

