/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.block.entity.BountyBoardBlockEntity;
import net.satisfy.wildernature.block.entity.CompletionistBannerEntity;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.entity.BisonEntity;
import net.satisfy.wildernature.entity.BoarEntity;
import net.satisfy.wildernature.entity.BulletEntity;
import net.satisfy.wildernature.entity.CassowaryEntity;
import net.satisfy.wildernature.entity.DeerEntity;
import net.satisfy.wildernature.entity.DogEntity;
import net.satisfy.wildernature.entity.FlamingoEntity;
import net.satisfy.wildernature.entity.HedgehogEntity;
import net.satisfy.wildernature.entity.MiniSheepEntity;
import net.satisfy.wildernature.entity.OwlEntity;
import net.satisfy.wildernature.entity.PelicanEntity;
import net.satisfy.wildernature.entity.PenguinEntity;
import net.satisfy.wildernature.entity.RaccoonEntity;
import net.satisfy.wildernature.entity.RedWolfEntity;
import net.satisfy.wildernature.entity.SquirrelEntity;
import net.satisfy.wildernature.entity.TurkeyEntity;
import net.satisfy.wildernature.registry.ObjectRegistry;
import net.satisfy.wildernature.util.WilderNatureIdentifier;

public class EntityRegistry {
    public static final DeferredRegister<class_2591<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"wildernature", (class_5321)class_7924.field_41255);
    private static final DeferredRegister<class_1299<?>> ENTITY_TYPES = DeferredRegister.create((String)"wildernature", (class_5321)class_7924.field_41266);
    public static final RegistrySupplier<class_2591<CompletionistBannerEntity>> COMPLETIONIST_BANNER_ENTITY = EntityRegistry.createBlockEntity("completionist_banner", () -> class_2591.class_2592.method_20528(CompletionistBannerEntity::new, (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.WOLF_TRAPPER_BANNER.get(), (class_2248)ObjectRegistry.WOLF_TRAPPER_WALL_BANNER.get(), (class_2248)ObjectRegistry.BUNNY_STALKER_BANNER.get(), (class_2248)ObjectRegistry.BUNNY_STALKER_WALL_BANNER.get(), (class_2248)ObjectRegistry.COD_CATCHER_BANNER.get(), (class_2248)ObjectRegistry.COD_CATCHER_WALL_BANNER.get()}).method_11034(null));
    public static final RegistrySupplier<class_2591<BountyBoardBlockEntity>> BOUNTY_BOARD_ENTITY = EntityRegistry.createBlockEntity("bounty_board", () -> class_2591.class_2592.method_20528(BountyBoardBlockEntity::new, (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.BOUNTY_BOARD.get()}).method_11034(null));
    public static final RegistrySupplier<class_1299<BisonEntity>> BISON = EntityRegistry.createEntity("bison", () -> class_1299.class_1300.method_5903(BisonEntity::new, (class_1311)class_1311.field_6294).method_17687(1.8f, 2.2f).method_5905(new WilderNatureIdentifier("bison").toString()));
    public static final RegistrySupplier<class_1299<BoarEntity>> BOAR = EntityRegistry.createEntity("boar", () -> class_1299.class_1300.method_5903(BoarEntity::new, (class_1311)class_1311.field_6294).method_17687(1.1f, 1.1f).method_5905(new WilderNatureIdentifier("boar").toString()));
    public static final RegistrySupplier<class_1299<CassowaryEntity>> CASSOWARY = EntityRegistry.createEntity("cassowary", () -> class_1299.class_1300.method_5903(CassowaryEntity::new, (class_1311)class_1311.field_6294).method_17687(0.8f, 0.8f).method_27299(10).method_5905(new WilderNatureIdentifier("cassowary").toString()));
    public static final RegistrySupplier<class_1299<DeerEntity>> DEER = EntityRegistry.createEntity("deer", () -> class_1299.class_1300.method_5903(DeerEntity::new, (class_1311)class_1311.field_6294).method_17687(1.3f, 1.6f).method_5905(new WilderNatureIdentifier("deer").toString()));
    public static final RegistrySupplier<class_1299<DogEntity>> DOG = EntityRegistry.createEntity("dog", () -> class_1299.class_1300.method_5903(DogEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.3f).method_5905(new WilderNatureIdentifier("dog").toString()));
    public static final RegistrySupplier<class_1299<FlamingoEntity>> FLAMINGO = EntityRegistry.createEntity("flamingo", () -> class_1299.class_1300.method_5903(FlamingoEntity::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 1.0f).method_27299(10).method_5905(new WilderNatureIdentifier("flamingo").toString()));
    public static final RegistrySupplier<class_1299<HedgehogEntity>> HEDGEHOG = EntityRegistry.createEntity("hedgehog", () -> class_1299.class_1300.method_5903(HedgehogEntity::new, (class_1311)class_1311.field_6294).method_17687(0.3f, 0.3f).method_27299(10).method_5905(new WilderNatureIdentifier("hedgehog").toString()));
    public static final RegistrySupplier<class_1299<MiniSheepEntity>> MINISHEEP = EntityRegistry.createEntity("minisheep", () -> class_1299.class_1300.method_5903(MiniSheepEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.3f).method_5905(new WilderNatureIdentifier("minisheep").toString()));
    public static final RegistrySupplier<class_1299<OwlEntity>> OWL = EntityRegistry.createEntity("owl", () -> class_1299.class_1300.method_5903(OwlEntity::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 1.0f).method_5905(new WilderNatureIdentifier("owl").toString()));
    public static final RegistrySupplier<class_1299<PelicanEntity>> PELICAN = EntityRegistry.createEntity("pelican", () -> class_1299.class_1300.method_5903(PelicanEntity::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 1.0f).method_5905(new WilderNatureIdentifier("pelican").toString()));
    public static final RegistrySupplier<class_1299<PenguinEntity>> PENGUIN = EntityRegistry.createEntity("penguin", () -> class_1299.class_1300.method_5903(PenguinEntity::new, (class_1311)class_1311.field_6294).method_17687(0.7f, 0.9f).method_27299(10).method_5905(new WilderNatureIdentifier("penguin").toString()));
    public static final RegistrySupplier<class_1299<RaccoonEntity>> RACCOON = EntityRegistry.createEntity("raccoon", () -> class_1299.class_1300.method_5903(RaccoonEntity::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.6f).method_5905(new WilderNatureIdentifier("raccoon").toString()));
    public static final RegistrySupplier<class_1299<RedWolfEntity>> RED_WOLF = EntityRegistry.createEntity("red_wolf", () -> class_1299.class_1300.method_5903(RedWolfEntity::new, (class_1311)class_1311.field_6294).method_17687(0.7f, 0.9f).method_27299(10).method_5905(new WilderNatureIdentifier("red_wolf").toString()));
    public static final RegistrySupplier<class_1299<SquirrelEntity>> SQUIRREL = EntityRegistry.createEntity("squirrel", () -> class_1299.class_1300.method_5903(SquirrelEntity::new, (class_1311)class_1311.field_6294).method_17687(0.4f, 0.9f).method_5905(new WilderNatureIdentifier("squirrel").toString()));
    public static final RegistrySupplier<class_1299<TurkeyEntity>> TURKEY = EntityRegistry.createEntity("turkey", () -> class_1299.class_1300.method_5903(TurkeyEntity::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 1.0f).method_5905(new WilderNatureIdentifier("turkey").toString()));
    public static final RegistrySupplier<class_1299<BulletEntity>> BULLET = EntityRegistry.createEntity("bullet", () -> class_1299.class_1300.method_5903(BulletEntity::new, (class_1311)class_1311.field_17715).method_17687(0.3125f, 0.3125f).method_27299(64).method_27300(2).method_5905(new WilderNatureIdentifier("bullet").toString()));

    public static <T extends class_1299<?>> RegistrySupplier<T> createEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((class_2960)new WilderNatureIdentifier(path), type);
    }

    private static <T extends class_2591<?>> RegistrySupplier<T> createBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITIES.register((class_2960)new WilderNatureIdentifier(path), type);
    }

    public static void init() {
        WilderNature.LOGGER.debug("Registering Entities for wildernature");
        ENTITY_TYPES.register();
        BLOCK_ENTITIES.register();
        EntityAttributeRegistry.register(BISON, BisonEntity::createMobAttributes);
        EntityAttributeRegistry.register(BOAR, BoarEntity::createMobAttributes);
        EntityAttributeRegistry.register(CASSOWARY, CassowaryEntity::createMobAttributes);
        EntityAttributeRegistry.register(DEER, DeerEntity::createMobAttributes);
        EntityAttributeRegistry.register(DOG, DogEntity::createMobAttributes);
        EntityAttributeRegistry.register(FLAMINGO, FlamingoEntity::createMobAttributes);
        EntityAttributeRegistry.register(HEDGEHOG, HedgehogEntity::createMobAttributes);
        EntityAttributeRegistry.register(MINISHEEP, MiniSheepEntity::createMobAttributes);
        EntityAttributeRegistry.register(OWL, OwlEntity::createMobAttributes);
        EntityAttributeRegistry.register(PELICAN, PelicanEntity::createMobAttributes);
        EntityAttributeRegistry.register(PENGUIN, PenguinEntity::createMobAttributes);
        EntityAttributeRegistry.register(RACCOON, RaccoonEntity::createMobAttributes);
        EntityAttributeRegistry.register(RED_WOLF, RedWolfEntity::createMobAttributes);
        EntityAttributeRegistry.register(SQUIRREL, SquirrelEntity::createMobAttributes);
        EntityAttributeRegistry.register(TURKEY, TurkeyEntity::createMobAttributes);
        BountyBlockScreenHandler.registerMenuTypes();
    }
}

