/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.util.contract;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import net.satisfy.wildernature.util.contract.ContractReloader;
import net.satisfy.wildernature.util.contract.ContractReward;

public record Contract(class_2960 tier, class_1799 contractStack, class_2960 targetPredicate, class_2960 damagePredicate, int count, String name, String description, ContractReward reward) {
    public static Codec<Contract> CODEC = RecordCodecBuilder.create(contractInstance -> contractInstance.group((App)class_2960.field_25139.fieldOf("type").forGetter(Contract::tier), (App)class_1799.field_24671.fieldOf("contractStack").forGetter(Contract::contractStack), (App)class_2960.field_25139.fieldOf("targetPredicate").forGetter(Contract::targetPredicate), (App)class_2960.field_25139.fieldOf("damagePredicate").forGetter(Contract::damagePredicate), (App)Codec.INT.fieldOf("count").forGetter(Contract::count), (App)Codec.STRING.fieldOf("name").forGetter(Contract::name), (App)Codec.STRING.fieldOf("description").forGetter(Contract::description), (App)ContractReward.CODEC.fieldOf("reward").forGetter(Contract::reward)).apply((Applicative)contractInstance, Contract::new));
    public static final Contract ERROR_CONTRACT = new Contract(new WilderNatureIdentifier("tier1"), class_1799.field_8037, new WilderNatureIdentifier("damage_any"), new WilderNatureIdentifier("_error"), 0, "Deleted contract", "Error: This contract was deleted from datapack", new ContractReward(0, 0, Optional.empty()));

    public static Contract fromId(class_2960 contract) {
        return Objects.requireNonNullElse(ContractReloader.getContract(contract), ERROR_CONTRACT);
    }
}

