/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.util.contract;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_7923;
import net.minecraft.class_8490;
import net.minecraft.class_8567;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.util.contract.Contract;
import net.satisfy.wildernature.util.contract.ContractReloader;

public class ContractInProgress {
    public static final HashMap<UUID, ContractInProgress> progressPerPlayer = new HashMap();
    public final class_2960 s_contract;
    public final long boardId;
    public int count;
    public static final Codec<ContractInProgress> SERVER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("contract").forGetter(ContractInProgress::contract), (App)Codec.INT.fieldOf("count").forGetter(ContractInProgress::count), (App)Codec.LONG.fieldOf("id").forGetter(ContractInProgress::id)).apply((Applicative)instance, ContractInProgress::new));

    private static class_2960 contract(ContractInProgress o) {
        return o.s_contract;
    }

    private static long id(Object o) {
        return ((ContractInProgress)o).boardId;
    }

    public boolean isFinished() {
        return this.count <= 0;
    }

    private static int count(Object o) {
        return ((ContractInProgress)o).count;
    }

    public ContractInProgress(class_2960 contract, int count, long id) {
        this.s_contract = contract;
        this.boardId = id;
        this.count = count;
    }

    public static EventResult onEntityDeath(class_1309 livingEntity, class_1282 damageSource) {
        class_3222 serverPlayer;
        ContractInProgress contract;
        class_1297 attacker = damageSource.method_5529();
        if (attacker instanceof class_3222 && (contract = progressPerPlayer.get((serverPlayer = (class_3222)attacker).method_5667())) != null) {
            contract.onEntityDeath(livingEntity, damageSource, (class_1657)serverPlayer);
        }
        return EventResult.pass();
    }

    public void onEntityDeath(class_1309 livingEntity, class_1282 damageSource, class_1657 sourcePlayer) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
        Contract contract = this.s_getContract();
        try {
            boolean predicateOrId;
            boolean damageResult;
            if (this.isFinished()) {
                return;
            }
            class_8567 entityLootParams = new class_8567.class_8568((class_3218)livingEntity.method_37908()).method_51874(class_181.field_24424, (Object)livingEntity.method_30950(0.0f)).method_51877(class_181.field_1226, (Object)livingEntity).method_51875(class_173.field_20761);
            class_47 entityLootContext = new class_47.class_48(entityLootParams).method_309(null);
            class_5341 entityCondition = (class_5341)livingEntity.method_5682().method_3857().getElement(class_8490.field_44496, contract.targetPredicate());
            boolean entityResult = entityCondition != null && entityCondition.test((Object)entityLootContext);
            class_8567 damageLootParams = new class_8567.class_8568((class_3218)livingEntity.method_37908()).method_51874(class_181.field_1226, (Object)livingEntity).method_51874(class_181.field_24424, (Object)livingEntity.method_30950(0.0f)).method_51874(class_181.field_1231, (Object)damageSource).method_51874(class_181.field_1230, (Object)damageSource.method_5529()).method_51874(class_181.field_1227, (Object)damageSource.method_5526()).method_51874(class_181.field_1233, (Object)sourcePlayer).method_51875(class_173.field_1173);
            class_47 damageLootContext = new class_47.class_48(damageLootParams).method_309(null);
            class_5341 damageCondition = (class_5341)livingEntity.method_5682().method_3857().getElement(class_8490.field_44496, contract.damagePredicate());
            boolean bl = damageResult = damageCondition == null || damageCondition.test((Object)damageLootContext);
            if (damageCondition == null) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43470((String)"Data error: contract %s has wrong damage predicate id (%s). Please check if name is correct".formatted(this.s_contract, contract.damagePredicate())));
                return;
            }
            boolean bl2 = predicateOrId = entityResult || class_7923.field_41177.method_10221((Object)livingEntity.method_5864()).equals((Object)contract.targetPredicate());
            if (Platform.isDevelopmentEnvironment()) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43470((String)"_entity: %b; damage: %b".formatted(predicateOrId, damageResult)));
            }
            if (predicateOrId && damageResult) {
                --this.count;
            }
            if (Platform.isDevelopmentEnvironment()) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43470((String)("_Entities left: " + this.count)));
            }
            if (this.count <= 0 && Platform.isDevelopmentEnvironment()) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43470((String)"_Finished contract \"%s\"".formatted(contract.name(), contract.description())));
            }
        }
        catch (Exception e) {
            WilderNature.info("error while handling entity death. Some debug data:", new Object[0]);
            WilderNature.info("Contract progress: {}", this.toString());
            WilderNature.info("Contract data: {}", this.s_getContract());
            WilderNature.info("Player {} with uuid {}", sourcePlayer.method_5477().toString(), sourcePlayer.method_5667());
            WilderNature.info("Progress per player id's:", new Object[0]);
            progressPerPlayer.forEach((uuid, data) -> WilderNature.info("UUID: {}, data: {}", uuid, data.toString()));
            WilderNature.info("\n\nRegistered contracts:", new Object[0]);
            ContractReloader.getAllContracts().forEach((id, data) -> WilderNature.info("contract id: {}, data: {}", id, data.toString()));
            WilderNature.info("\n\nRegistered tiers:", new Object[0]);
            ContractReloader.tiers.forEach((id, data) -> WilderNature.info("tier id: {}, data: {}", id, data));
            e.printStackTrace();
            Objects.requireNonNull(sourcePlayer.method_5682()).method_3747(false);
        }
    }

    public String toString() {
        return "[%d, %s, %d]".formatted(this.boardId, this.s_contract.toString(), this.count);
    }

    public void onFinish(class_3222 sourcePlayer) {
        BountyBlockScreenHandler bountyHandler = (BountyBlockScreenHandler)sourcePlayer.field_7512;
        if (bountyHandler.s_targetEntity.boardId == this.boardId) {
            bountyHandler.s_targetEntity.addXp(this.s_getContract().reward().blockExpReward());
        } else if (Platform.isDevelopmentEnvironment()) {
            sourcePlayer.method_43496((class_2561)class_2561.method_43470((String)"_not given xp to block because contract taken in other board"));
        }
        if (this.s_getContract().reward().playerRewardLoot().isEmpty()) {
            return;
        }
        Objects.requireNonNull(sourcePlayer.method_37908().method_8503()).method_3857().getLootTable(this.s_getContract().reward().playerRewardLoot().get()).method_51880(new class_8567.class_8568((class_3218)sourcePlayer.method_37908()).method_51874(class_181.field_1226, (Object)sourcePlayer).method_51874(class_181.field_24424, (Object)sourcePlayer.method_30950(0.0f)).method_51875(class_173.field_1174), sourcePlayer.method_51851(), arg_0 -> ((class_3222)sourcePlayer).method_5775(arg_0));
    }

    public Contract s_getContract() {
        return Contract.fromId(this.s_contract);
    }
}

