/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.util.contract;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.util.BountyBoardTier;
import net.satisfy.wildernature.util.contract.Contract;

public class ContractReloader
implements class_4013 {
    private static HashMap<class_2960, Contract> contracts = new HashMap();
    public static HashMap<class_2960, BountyBoardTier> tiers = new HashMap();

    public static Contract getContract(class_2960 location) {
        String path = location.method_12832();
        int index = path.indexOf("/", 0);
        String newLocation = path.substring(index + 1);
        class_2960 rl = new class_2960(location.method_12836(), newLocation);
        Contract contract = contracts.get(rl);
        WilderNature.info("searching contract {}: {}", rl, contract);
        return contract;
    }

    public static List<class_2960> getContractsOfTier(class_2960 tierId) {
        return contracts.keySet().stream().filter(key -> {
            ArrayList<class_2960> allTiers = new ArrayList<class_2960>();
            class_2960 id = tierId;
            while (true) {
                allTiers.add(id);
                class_2960 idcopy = id;
                BountyBoardTier tier = BountyBoardTier.byId(id).orElseThrow(() -> {
                    throw new RuntimeException("Error: Not found tier with id %s".formatted(idcopy));
                });
                if (!tier.previousTier().isPresent()) break;
                id = tier.previousTier().get();
            }
            return allTiers.contains(contracts.get(key).tier());
        }).toList();
    }

    public static class_2960 getRandomContractOfTier(class_2960 tier) {
        List<class_2960> tier1 = ContractReloader.getContractsOfTier(tier);
        return tier1.get(new Random().nextInt(tier1.size()));
    }

    public static Map<class_2960, Contract> getAllContracts() {
        return new HashMap<class_2960, Contract>(contracts);
    }

    public void method_14491(class_3300 manager) {
        contracts.clear();
        Map contracts = manager.method_14488("wildernature_contracts", path -> path.method_12832().endsWith(".json"));
        WilderNature.info("Reloading contracts", new Object[0]);
        contracts.forEach((resourceLocation, resource) -> {
            WilderNature.info("Found contract {}", resourceLocation);
            try {
                InputStream open = resource.method_14482();
                int index = resourceLocation.method_12832().indexOf("/", 0);
                String pathEdits = resourceLocation.method_12832().substring(index + 1);
                String jsonString = new String(open.readAllBytes(), StandardCharsets.UTF_8);
                Contract contract = (Contract)Contract.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)new Gson().fromJson(jsonString, JsonElement.class))).getOrThrow(false, err -> {
                    throw new RuntimeException((String)err);
                });
                class_2960 rl = new class_2960(resourceLocation.method_12836(), pathEdits);
                WilderNature.info("registering contract {}", rl);
                contracts.put(rl, contract);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        contracts.clear();
        Map tiers = manager.method_14488("wildernature_tiers", path -> path.method_12832().endsWith(".json"));
        WilderNature.info("Reloading tiers", new Object[0]);
        tiers.forEach((resourceLocation, resource) -> {
            WilderNature.info("Found tier {}", resourceLocation);
            try {
                String namespace = resourceLocation.method_12836();
                String pathEdits = resourceLocation.method_12832();
                pathEdits = pathEdits.substring("wildernature_tiers/".length());
                pathEdits = pathEdits.substring(0, pathEdits.length() - ".json".length());
                InputStream open = resource.method_14482();
                String jsonString = new String(open.readAllBytes(), StandardCharsets.UTF_8);
                BountyBoardTier tier = (BountyBoardTier)BountyBoardTier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)new Gson().fromJson(jsonString, JsonElement.class))).getOrThrow(false, err -> {
                    throw new RuntimeException((String)err);
                });
                class_2960 rl = new class_2960(namespace, pathEdits);
                tiers.put(rl, tier);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

