/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.access.StructurePoolAccess;
import dev.worldgen.lithostitched.mixin.common.StructureTemplatePoolAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_6032;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class AddTemplatePoolElementsModifier
extends Modifier {
    public static final Codec<AddTemplatePoolElementsModifier> CODEC = RecordCodecBuilder.create(instance -> AddTemplatePoolElementsModifier.addModifierFields(instance).and(instance.group((App)class_2960.field_25139.fieldOf("template_pool").forGetter(AddTemplatePoolElementsModifier::rawTemplatePoolLocation), (App)Codec.mapPair((MapCodec)class_3784.field_24953.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(AddTemplatePoolElementsModifier::elements), (App)class_6903.method_46636((class_5321)class_7924.field_41249))).apply((Applicative)instance, AddTemplatePoolElementsModifier::new));
    private final class_5321<class_3785> EMPTY_TEMPLATE_POOL = class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)new class_2960("lithostitched", "empty"));
    private final class_2960 rawTemplatePoolLocation;
    private final class_6880<class_3785> templatePool;
    private final List<Pair<class_3784, Integer>> elements;

    public AddTemplatePoolElementsModifier(ModifierPredicate predicate, class_2960 rawTemplatePoolLocation, List<Pair<class_3784, Integer>> elements, class_7871<class_3785> getter) {
        super(predicate, Modifier.ModifierPhase.ADD);
        this.rawTemplatePoolLocation = rawTemplatePoolLocation;
        Optional templatePoolEntry = getter.method_46746(predicate.test() ? class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)rawTemplatePoolLocation) : this.EMPTY_TEMPLATE_POOL);
        this.templatePool = (class_6880)templatePoolEntry.get();
        this.elements = elements;
    }

    public class_6880<class_3785> templatePool() {
        return this.templatePool;
    }

    public class_2960 rawTemplatePoolLocation() {
        return this.rawTemplatePoolLocation;
    }

    public List<Pair<class_3784, Integer>> elements() {
        return this.elements;
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }

    @Override
    public void applyModifier() {
        if (this.templatePool.method_40225(this.EMPTY_TEMPLATE_POOL)) {
            return;
        }
        StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)this.templatePool().comp_349();
        StructurePoolAccess lithostitchedPoolAccessor = (StructurePoolAccess)this.templatePool().comp_349();
        ArrayList<Pair<class_3784, Integer>> rawTemplates = new ArrayList<Pair<class_3784, Integer>>(poolAccessor.getRawTemplates());
        rawTemplates.addAll(this.elements());
        poolAccessor.setRawTemplates(rawTemplates);
        ObjectArrayList vanillaTemplates = new ObjectArrayList(poolAccessor.getVanillaTemplates());
        class_6032<class_3784> lithostitchedTemplates = lithostitchedPoolAccessor.getLithostitchedTemplates();
        for (Pair<class_3784, Integer> pair : this.elements()) {
            lithostitchedTemplates.method_35093((Object)((class_3784)pair.getFirst()), ((Integer)pair.getSecond()).intValue());
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                vanillaTemplates.add((Object)((class_3784)pair.getFirst()));
            }
        }
        poolAccessor.setVanillaTemplates((ObjectArrayList<class_3784>)vanillaTemplates);
        lithostitchedPoolAccessor.setLithostitchedTemplates(lithostitchedTemplates);
    }
}

