/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.PriorityBasedModifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.modifier.util.DensityFunctionWrapper;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class WrapNoiseRouterModifier
extends Modifier {
    public static final Codec<WrapNoiseRouterModifier> CODEC = RecordCodecBuilder.create(instance -> WrapNoiseRouterModifier.addModifierFields(instance).and(instance.group((App)PriorityBasedModifier.PRIORITY_CODEC.forGetter(WrapNoiseRouterModifier::priority), (App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("dimension").forGetter(WrapNoiseRouterModifier::dimension), (App)Target.CODEC.fieldOf("target").forGetter(WrapNoiseRouterModifier::target), (App)class_6910.field_37058.fieldOf("wrapper_function").forGetter(WrapNoiseRouterModifier::wrapperFunction))).apply((Applicative)instance, WrapNoiseRouterModifier::new));
    private final int priority;
    private final class_5321<class_1937> dimension;
    private final Target target;
    private final class_6880<class_6910> wrapperFunction;

    public WrapNoiseRouterModifier(ModifierPredicate predicate, int priority, class_5321<class_1937> dimension, Target target, class_6880<class_6910> wrapperFunction) {
        super(predicate, Modifier.ModifierPhase.MODIFY);
        this.priority = priority;
        this.dimension = dimension;
        this.target = target;
        this.wrapperFunction = wrapperFunction;
    }

    @Override
    public void applyModifier() {
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }

    public static class_6910 modifyDensityFunction(Target target, class_6910 wrapped, List<WrapNoiseRouterModifier> modifiers) {
        List<class_6910> orderedFunctions = modifiers.stream().filter(modifier -> modifier.target == target).sorted(Comparator.comparingInt(WrapNoiseRouterModifier::priority)).map(modifier -> (class_6910)modifier.wrapperFunction().comp_349()).toList();
        if (orderedFunctions.isEmpty()) {
            return wrapped;
        }
        class_6910 mergedFunction = wrapped;
        for (class_6910 function : orderedFunctions) {
            mergedFunction = DensityFunctionWrapper.wrap(mergedFunction, function);
        }
        return mergedFunction;
    }

    public int priority() {
        return this.priority;
    }

    public class_5321<class_1937> dimension() {
        return this.dimension;
    }

    public Target target() {
        return this.target;
    }

    public class_6880<class_6910> wrapperFunction() {
        return this.wrapperFunction;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WrapNoiseRouterModifier that = (WrapNoiseRouterModifier)obj;
        return this.priority == that.priority && Objects.equals((Object)this.target, (Object)that.target) && Objects.equals(this.wrapperFunction, that.wrapperFunction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priority, this.target, this.wrapperFunction});
    }

    public String toString() {
        return "WrapNoiseRouterModifier[priority=" + this.priority + ", target=" + this.target + ", wrapperFunction=" + this.wrapperFunction + "]";
    }

    public static enum Target implements class_3542
    {
        BARRIER("barrier"),
        FLUID_LEVEL_FLOODEDNESS("fluid_level_floodedness"),
        FLUID_LEVEL_SPREAD("fluid_level_spread"),
        LAVA("lava"),
        TEMPERATURE("temperature"),
        VEGETATION("vegetation"),
        CONTINENTS("continents"),
        EROSION("erosion"),
        DEPTH("depth"),
        RIDGES("ridges"),
        INITIAL_DENSITY("initial_density_without_jaggedness"),
        FINAL_DENSITY("final_density"),
        VEIN_TOGGLE("vein_toggle"),
        VEIN_RIDGED("vein_ridged"),
        VEIN_GAP("vein_gap");

        public static final Codec<Target> CODEC;
        private final String name;

        private Target(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Target::values);
        }
    }
}

