/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.IngredientValue;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public final class CrabConfig
extends EntityConfig {
    private static final CrabConfig INSTANCE = new CrabConfig();
    public final BooleanValue canAttack = new BooleanValue("canAttack", true);
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 10.0, 1.0, 32767.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.25, 0.05, 10.0);
    public final NumberValue.DoubleValue attackDamage = new NumberValue.DoubleValue("attackDamage", 2.0, 1.0, 32767.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 4, 1, 15);
    public final IngredientValue temptationItems = new IngredientValue("temptationItems", class_1802.field_8429);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", CrabConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);
    public final NumberValue.IntegerValue colorRedWeight = new NumberValue.IntegerValue("colorRedWeight", 45, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorBlueWeight = new NumberValue.IntegerValue("colorBlueWeight", 10, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorWhiteWeight = new NumberValue.IntegerValue("colorWhiteWeight", 45, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue scalingNormalWeight = new NumberValue.IntegerValue("scalingNormalWeight", 30, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue scalingSmallWeight = new NumberValue.IntegerValue("scalingSmallWeight", 30, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue scalingLargeWeight = new NumberValue.IntegerValue("scalingLargeWeight", 25, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue scalingExtraLargeWeight = new NumberValue.IntegerValue("scalingExtraLargeWeight", 15, 0, Integer.MAX_VALUE);

    private CrabConfig() {
        super("crab");
        this.registerConfigValues(this.canAttack, this.health, this.movementSpeed, this.attackDamage, this.maxSpawnedInChunk, this.temptationItems, this.spawnBiomes);
        this.registerForCategory("colorVariants", this.colorRedWeight, this.colorBlueWeight, this.colorWhiteWeight);
        this.registerForCategory("scalingVariants", this.scalingNormalWeight, this.scalingSmallWeight, this.scalingLargeWeight, this.scalingExtraLargeWeight);
    }

    public static CrabConfig get() {
        return INSTANCE;
    }

    public static boolean canAttack() {
        return CrabConfig.INSTANCE.canAttack.get();
    }

    public static double health() {
        return (Double)CrabConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)CrabConfig.INSTANCE.movementSpeed.get();
    }

    public static double attackDamage() {
        return (Double)CrabConfig.INSTANCE.attackDamage.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)CrabConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    public static class_1856 temptationItems() {
        return CrabConfig.INSTANCE.temptationItems.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(60, 5, 8, new class_5321[]{class_1972.field_9438, class_1972.field_9434, class_1972.field_9471, class_1972.field_38748}));
    }
}

