/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public final class MantarayConfig
extends EntityConfig {
    private static final MantarayConfig INSTANCE = new MantarayConfig();
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 10.0, 1.0, 32767.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 1.0, 0.05, 10.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 5, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", MantarayConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);
    public final NumberValue.IntegerValue colorBlueVariant = new NumberValue.IntegerValue("colorBlueVariant", 50, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorBrownVariant = new NumberValue.IntegerValue("colorBrownVariant", 50, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue scalingNormalWeight = new NumberValue.IntegerValue("scalingNormalWeight", 30, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue scalingSmallVariant = new NumberValue.IntegerValue("scalingSmallVariant", 30, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue scalingLargeVariant = new NumberValue.IntegerValue("scalingLargeVariant", 25, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue scalingExtraLargeWeight = new NumberValue.IntegerValue("scalingExtraLargeWeight", 15, 0, Integer.MAX_VALUE);

    private MantarayConfig() {
        super("mantaray");
        this.registerConfigValues(this.health, this.movementSpeed, this.maxSpawnedInChunk, this.spawnBiomes);
        this.registerForCategory("colorVariants", this.colorBlueVariant, this.colorBrownVariant);
        this.registerForCategory("scalingVariants", this.scalingNormalWeight, this.scalingSmallVariant, this.scalingLargeVariant, this.scalingExtraLargeWeight);
    }

    public static MantarayConfig get() {
        return INSTANCE;
    }

    public static double health() {
        return (Double)MantarayConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)MantarayConfig.INSTANCE.movementSpeed.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)MantarayConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(12, 2, 5, new class_5321[]{class_1972.field_9423, class_1972.field_9446, class_1972.field_9435, class_1972.field_9418, class_1972.field_9467, class_1972.field_9470, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9438}));
    }
}

