/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.ArrayList;
import java.util.List;

public final class NetherKnightConfig
extends EntityConfig {
    private static final NetherKnightConfig INSTANCE = new NetherKnightConfig();
    public final BooleanValue canAttack = new BooleanValue("canAttack", true);
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 60.0, 1.0, 32767.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.26, 0.05, 10.0);
    public final NumberValue.DoubleValue attackDamage = new NumberValue.DoubleValue("attackDamage", 10.0, 1.0, 32767.0);
    public final NumberValue.DoubleValue weaponDropChance = new NumberValue.DoubleValue("weaponDropChance", 100.0, 0.0, 100.0);
    public final NumberValue.IntegerValue spawnWeight = new NumberValue.IntegerValue("spawnWeight", 18, 1, Short.MAX_VALUE);
    public final NumberValue.IntegerValue minSpawnCount = new NumberValue.IntegerValue("minSpawnCount", 1, 1, Short.MAX_VALUE);
    public final NumberValue.IntegerValue maxSpawnCount = new NumberValue.IntegerValue("maxSpawnCount", 2, 1, Short.MAX_VALUE);
    public final ListValue<String> swordNames = new ListValue<String>("swordNames", NetherKnightConfig.getDefaultSwordNames(), JsonPrimitive::new, JsonElement::getAsString);
    public final ListValue<String> axeNames = new ListValue<String>("axeNames", NetherKnightConfig.getDefaultAxeNames(), JsonPrimitive::new, JsonElement::getAsString);

    private NetherKnightConfig() {
        super("nether_knight");
        this.registerConfigValues(this.canAttack, this.health, this.movementSpeed, this.attackDamage, this.weaponDropChance);
        this.registerForCategory("spawning", this.spawnWeight, this.minSpawnCount, this.maxSpawnCount);
        this.registerForCategory("weaponNames", this.swordNames, this.axeNames);
    }

    public static NetherKnightConfig get() {
        return INSTANCE;
    }

    public static boolean canAttack() {
        return NetherKnightConfig.INSTANCE.canAttack.get();
    }

    public static double health() {
        return (Double)NetherKnightConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)NetherKnightConfig.INSTANCE.movementSpeed.get();
    }

    public static double attackDamage() {
        return (Double)NetherKnightConfig.INSTANCE.attackDamage.get();
    }

    public static double weaponDropChance() {
        return (Double)NetherKnightConfig.INSTANCE.weaponDropChance.get();
    }

    private static List<String> getDefaultSwordNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Edge of Suffering");
        list.add("Dragon's Curse");
        list.add("The Soul Harvester");
        list.add("Bloodseeker");
        list.add("Soul Reaper");
        list.add("Doomblade");
        return list;
    }

    private static List<String> getDefaultAxeNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Demonic Soul Collector");
        list.add("The Reaper's Scythe");
        list.add("The Soul Reaper");
        list.add("The Soul Collector");
        return list;
    }
}

