/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public final class SharkConfig
extends EntityConfig {
    private static final SharkConfig INSTANCE = new SharkConfig();
    public final BooleanValue canAttack = new BooleanValue("canAttack", true);
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 22.0, 1.0, 32767.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 1.05, 0.05, 10.0);
    public final NumberValue.DoubleValue attackDamage = new NumberValue.DoubleValue("attackDamage", 6.0, 1.0, 32767.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 3, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", SharkConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);

    private SharkConfig() {
        super("shark");
        this.registerConfigValues(this.canAttack, this.health, this.movementSpeed, this.attackDamage, this.maxSpawnedInChunk, this.spawnBiomes);
    }

    public static SharkConfig get() {
        return INSTANCE;
    }

    public static boolean canAttack() {
        return SharkConfig.INSTANCE.canAttack.get();
    }

    public static double health() {
        return (Double)SharkConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)SharkConfig.INSTANCE.movementSpeed.get();
    }

    public static double attackDamage() {
        return (Double)SharkConfig.INSTANCE.attackDamage.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)SharkConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(13, 2, 3, new class_5321[]{class_1972.field_9423, class_1972.field_9446, class_1972.field_9435, class_1972.field_9418, class_1972.field_9467, class_1972.field_9470, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439}));
    }
}

