/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.tristankechlo.livingthings.LivingThings;
import com.tristankechlo.livingthings.config.util.IConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_3518;

public abstract class EntityConfig
implements IConfig {
    public static final double MIN_HEALTH = 1.0;
    public static final double MAX_HEALTH = 32767.0;
    public static final double MIN_SPEED = 0.05;
    public static final double MAX_SPEED = 10.0;
    public static final double MIN_DAMAGE = 1.0;
    public static final double MAX_DAMAGE = 32767.0;
    private final List<IConfig> children = new ArrayList<IConfig>();
    private final List<Pair<String, List<IConfig>>> categories = new ArrayList<Pair<String, List<IConfig>>>();
    private final String fileName;

    public EntityConfig(String id) {
        this.fileName = id + ".json";
    }

    protected void registerConfigValues(IConfig ... configs) {
        this.children.addAll(Arrays.asList(configs));
    }

    protected void registerForCategory(String category, IConfig ... configs) {
        this.categories.add((Pair<String, List<IConfig>>)Pair.of((Object)category, Arrays.asList(configs)));
    }

    @Override
    public void setToDefault() {
        for (IConfig child : this.children) {
            child.setToDefault();
        }
        this.categories.forEach(pair -> ((List)pair.getSecond()).forEach(IConfig::setToDefault));
    }

    @Override
    public void deserialize(JsonObject json) {
        for (IConfig child : this.children) {
            child.deserialize(json);
        }
        this.categories.forEach(pair -> {
            String category = (String)pair.getFirst();
            List configs = (List)pair.getSecond();
            if (class_3518.method_34923((JsonObject)json, (String)category)) {
                JsonObject categoryJson = class_3518.method_15296((JsonObject)json, (String)category);
                configs.forEach(config -> config.deserialize(categoryJson));
            } else {
                LivingThings.LOGGER.warn("Category '{}' not found in config file '{}'", (Object)category, (Object)this.fileName);
            }
        });
    }

    @Override
    public JsonElement serialize(JsonObject json) {
        for (IConfig child : this.children) {
            child.serialize(json);
        }
        this.categories.forEach(pair -> {
            JsonObject categoryJson = new JsonObject();
            ((List)pair.getSecond()).forEach(config -> config.serialize(categoryJson));
            json.add((String)pair.getFirst(), (JsonElement)categoryJson);
        });
        return json;
    }

    public String getFileName() {
        return this.fileName;
    }
}

