/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.tristankechlo.livingthings.LivingThings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_5483;

public final class SpawnData {
    private final List<class_2960> biomes = new ArrayList<class_2960>();
    private final int weight;
    private final int minCount;
    private final int maxCount;

    public SpawnData(int weight, int minCount, int maxCount, class_5321<class_1959>[] biomes) {
        this(weight, minCount, maxCount, Arrays.stream(biomes).map(class_5321::method_29177).toList());
    }

    public SpawnData(int weight, int minCount, int maxCount, List<class_2960> biomes) {
        this.weight = weight;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.biomes.addAll(biomes);
    }

    public class_5483.class_1964 asSpawnerData(class_1299<?> entityType) {
        return new class_5483.class_1964(entityType, this.weight, this.minCount, this.maxCount);
    }

    public List<class_2960> getBiomes() {
        return this.biomes;
    }

    public static JsonElement serialize(SpawnData spawnData) {
        JsonObject json = new JsonObject();
        json.addProperty("weight", (Number)spawnData.weight);
        json.addProperty("minGroupSize", (Number)spawnData.minCount);
        json.addProperty("maxGroupSize", (Number)spawnData.maxCount);
        JsonArray biomes = new JsonArray();
        spawnData.biomes.forEach(biome -> {
            JsonPrimitive primitive = new JsonPrimitive(biome.toString());
            biomes.add((JsonElement)primitive);
        });
        json.add("biomes", (JsonElement)biomes);
        return json;
    }

    public static SpawnData deserialize(JsonElement jsonElement) {
        JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"spawnData");
        int weight = class_3518.method_15260((JsonObject)json, (String)"weight");
        int minCount = class_3518.method_15260((JsonObject)json, (String)"minGroupSize");
        int maxCount = class_3518.method_15260((JsonObject)json, (String)"maxGroupSize");
        ArrayList<class_2960> biomes = new ArrayList<class_2960>();
        JsonArray biomesArray = class_3518.method_15261((JsonObject)json, (String)"biomes");
        for (JsonElement biomeElement : biomesArray) {
            String biomeString = class_3518.method_15287((JsonElement)biomeElement, (String)"biome");
            class_2960 biomeLoc = class_2960.method_12829((String)biomeString);
            if (biomeLoc == null) {
                LivingThings.LOGGER.error("Ignoring invalid biome: {}", (Object)biomeString);
                continue;
            }
            biomes.add(biomeLoc);
        }
        return new SpawnData(weight, minCount, maxCount, biomes);
    }
}

