/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.CrabConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.entity.misc.IScaleableMob;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_6019;
import net.minecraft.class_7;

public class CrabEntity
extends class_1429
implements IMobVariants,
class_5354,
IScaleableMob,
ILexiconEntry {
    private static final class_2940<Byte> CRAB_VARIANT = class_2945.method_12791(CrabEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> CRAB_SCALING = class_2945.method_12791(CrabEntity.class, (class_2941)class_2943.field_13319);
    private static final class_6019 rangedInteger = class_4802.method_24505((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public CrabEntity(class_1299<? extends CrabEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_49477(1.0f);
        this.method_5941(class_7.field_18, 1.0f);
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        CrabEntity entityChild = (CrabEntity)ModEntityTypes.CRAB.get().method_5883(this.method_37908());
        entityChild.setVariant(this.getVariantFromParents((class_1296)this, entity));
        entityChild.setScaling(CrabEntity.getWeightedRandomScaling(this.field_5974));
        double health = CrabConfig.health();
        if (health > 0.0) {
            entityChild.method_5996(class_5134.field_23716).method_6192(health + (double)entityChild.getScaling());
            entityChild.method_6033(entityChild.method_6063());
        }
        return entityChild;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, CrabConfig.health()).method_26868(class_5134.field_23719, CrabConfig.movementSpeed()).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23721, CrabConfig.attackDamage());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new BetterMeleeAttackGoal((class_1314)this, 1.05, false, CrabConfig::canAttack));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.1));
        this.field_6201.method_6277(1, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_5398((class_1308)this, true));
    }

    public static boolean checkCrabSpawnRules(class_1299<CrabEntity> animal, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_22351(pos) || world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.CRAB_SPAWNABLE_ON) && CrabEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        int colorRedWeight = (Integer)CrabConfig.get().colorRedWeight.get();
        int colorWhiteWeight = (Integer)CrabConfig.get().colorWhiteWeight.get();
        int colorBlueWeight = (Integer)CrabConfig.get().colorBlueWeight.get();
        byte variant = this.getRandomVariant(this.field_5974, new byte[]{0, 1, 2}, new int[]{colorRedWeight, colorWhiteWeight, colorBlueWeight});
        this.setVariant(variant);
        this.setScaling(CrabEntity.getWeightedRandomScaling(this.field_5974));
        double health = CrabConfig.health();
        if (health > 0.0) {
            this.method_5996(class_5134.field_23716).method_6192(health + (double)this.getScaling());
            this.method_6033(this.method_6063());
        }
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static byte getWeightedRandomScaling(class_5819 random) {
        int scaling1Weight = (Integer)CrabConfig.get().scalingNormalWeight.get();
        int scaling2Weight = (Integer)CrabConfig.get().scalingLargeWeight.get();
        int scaling3Weight = (Integer)CrabConfig.get().scalingSmallWeight.get();
        int scaling4Weight = (Integer)CrabConfig.get().scalingExtraLargeWeight.get();
        if (scaling1Weight <= 0 && scaling2Weight <= 0 && scaling3Weight <= 0 && scaling4Weight <= 0) {
            return 0;
        }
        Optional scaling = class_6011.method_34986((class_5819)random, (List)ImmutableList.of((Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling1Weight), 0), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling2Weight), 2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling3Weight), -2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling4Weight), 6)));
        return ((IScaleableMob.WeightedMobScaling)scaling.get()).scaling;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CRAB_VARIANT, (Object)0);
        this.field_6011.method_12784(CRAB_SCALING, (Object)0);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10567("CrabVariant", this.getVariant());
        compound.method_10567("CrabScaling", this.getScaling());
        this.method_29517(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_10571("CrabVariant"));
        this.setScaling(compound.method_10571("CrabScaling"));
        this.method_29512(this.method_37908(), compound);
    }

    public boolean method_6481(class_1799 stack) {
        return CrabConfig.temptationItems().method_8093(stack);
    }

    public int method_5945() {
        return CrabConfig.maxSpawnedInChunk();
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return size.field_18068 * 0.9f;
    }

    public boolean method_6094() {
        return true;
    }

    protected float method_6120() {
        return 0.98f;
    }

    @Override
    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(CRAB_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.field_6011.method_12778(CRAB_VARIANT, (Object)variant);
    }

    @Override
    public byte getScaling() {
        return (Byte)this.field_6011.method_12789(CRAB_SCALING);
    }

    @Override
    public void setScaling(byte scaling) {
        this.field_6011.method_12778(CRAB_SCALING, (Object)scaling);
        this.method_23311();
        this.method_18382();
        this.field_6194 = Math.abs(scaling) * this.field_5974.method_43048(2);
    }

    public void method_5674(class_2940<?> key) {
        if (CRAB_SCALING.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    public void method_18382() {
        double d0 = this.method_23317();
        double d1 = this.method_23318();
        double d2 = this.method_23321();
        super.method_18382();
        this.method_5814(d0, d1, d2);
    }

    public class_4048 method_18377(class_4050 pose) {
        if (this.method_6109()) {
            return super.method_18377(pose);
        }
        return super.method_18377(pose).method_18383(0.85f + 0.1f * (float)this.getScaling());
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int time) {
        this.angerTime = time;
    }

    public UUID method_29508() {
        return this.angerTarget;
    }

    public void method_29513(UUID target) {
        this.angerTarget = target;
    }

    public void method_29509() {
        this.method_29514(rangedInteger.method_35008(this.field_5974));
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.CRAB;
    }
}

