/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.ShroomieConfig;
import com.tristankechlo.livingthings.entity.ai.ShroomiePlantMushroomGoal;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;

public class ShroomieEntity
extends class_1429
implements IMobVariants,
ILexiconEntry {
    private static final class_2940<Byte> VARIANT = class_2945.method_12791(ShroomieEntity.class, (class_2941)class_2943.field_13319);
    private static final class_6019 RANGED_INTEGER = class_4802.method_24505((int)30, (int)60);
    private boolean canPlantMushroom = false;
    private int mushroomCooldown;

    public ShroomieEntity(class_1299<? extends ShroomieEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static boolean checkShroomieSpawnRules(class_1299<ShroomieEntity> animal, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.SHROOMIE_SPAWNABLE_ON) && ShroomieEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(tag.method_10571("ShroomieType"));
        this.mushroomCooldown = tag.method_10550("MushroomCooldown");
        this.canPlantMushroom = tag.method_10577("CanPlantMushroom");
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10567("ShroomieType", this.getVariant());
        tag.method_10569("MushroomCooldown", this.mushroomCooldown);
        tag.method_10556("CanPlantMushroom", this.canPlantMushroom);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.1, ShroomieConfig.temptationItems(), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new ShroomiePlantMushroomGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.mushroomCooldown > 0) {
            --this.mushroomCooldown;
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 reason, class_1315 data, class_2487 tag) {
        int brownWeight = (Integer)ShroomieConfig.get().colorBrownWeight.get();
        int redWeight = (Integer)ShroomieConfig.get().colorRedWeight.get();
        this.setVariant(this.getRandomVariant(this.field_5974, new byte[]{0, 1}, new int[]{brownWeight, redWeight}));
        return super.method_5943(world, difficulty, reason, data, tag);
    }

    public boolean method_6481(class_1799 stack) {
        return ShroomieConfig.temptationItems().method_8093(stack);
    }

    public int method_5945() {
        return ShroomieConfig.maxSpawnedInChunk();
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return size.field_18068 * 0.55f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.getVariant() == 1 && stack.method_31574(class_1802.field_17517) || this.getVariant() == 0 && stack.method_31574(class_1802.field_17516)) {
            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
            if (!this.canPlantMushroom) {
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                this.mushroomCooldown += 100;
                this.canPlantMushroom = true;
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return super.method_5992(player, hand);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ShroomieConfig.health()).method_26868(class_5134.field_23719, ShroomieConfig.movementSpeed());
    }

    public class_1296 method_5613(class_3218 world, class_1296 parent) {
        ShroomieEntity shroomie = (ShroomieEntity)ModEntityTypes.SHROOMIE.get().method_5883((class_1937)world);
        shroomie.setVariant(this.getVariantFromParents((class_1296)this, parent));
        shroomie.method_5614(0);
        return shroomie;
    }

    public boolean canPlantMushroom() {
        return this.canPlantMushroom && this.mushroomCooldown <= 0;
    }

    public void plantedMushroom() {
        if (this.field_5974.method_43056()) {
            this.canPlantMushroom = false;
        }
        this.mushroomCooldown = RANGED_INTEGER.method_35008(this.field_5974);
    }

    @Override
    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(VARIANT);
    }

    @Override
    public void setVariant(byte type) {
        if (type > 1 || type < 0) {
            return;
        }
        this.field_6011.method_12778(VARIANT, (Object)type);
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.SHROOMIE;
    }
}

