/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.lootbeams.LootBeams;
import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class Configuration {
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    public boolean allItems = true;
    public boolean onlyEquipment = false;
    public boolean onlyRare = false;
    public List<String> whitelist = new ArrayList<String>();
    public List<String> blacklist = new ArrayList<String>();
    public List<String> colorOverrides = new ArrayList<String>();
    public boolean renderNameColor = true;
    public boolean renderRarityColor = true;
    public float beamRadius = 1.0f;
    public float beamHeight = 1.0f;
    public float beamYOffset = 0.0f;
    public float beamAlpha = 0.85f;
    public float renderDistance = 24.0f;
    public float fadeDistance = 2.0f;
    public boolean borders = true;
    public boolean renderNametags = true;
    public boolean renderNametagsOnlook = true;
    public boolean renderStackcount = true;
    public float nametagLookSensitivity = 0.018f;
    public float nametagTextAlpha = 1.0f;
    public float nametagBackgroundAlpha = 0.5f;
    public float nametagScale = 1.0f;
    public float nametagYOffset = 0.75f;
    public boolean dmclootCompatRarity = true;
    public List<String> customRarities = new ArrayList<String>();
    public List<String> alwaysDrawRaritiesOn = List.of(new String[]{"#minecrft:music_discs"});
    public boolean whiteRarities = false;

    public static Configuration load() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("lootbeams-client.toml").toFile();
        Configuration inst = new Configuration();
        if (configFile.isFile()) {
            try {
                Toml main = new Toml().read(configFile).getTable("\"Loot Beams\"");
                inst.renderNameColor = main.getBoolean("render_name_color", Boolean.valueOf(true));
                inst.renderRarityColor = main.getBoolean("render_rarity_color", Boolean.valueOf(true));
                inst.beamRadius = main.getDouble("beam_radius", Double.valueOf(1.0)).floatValue();
                inst.beamHeight = main.getDouble("beam_height", Double.valueOf(1.0)).floatValue();
                inst.beamYOffset = main.getDouble("beam_y_offset", Double.valueOf(0.0)).floatValue();
                inst.beamAlpha = main.getDouble("beam_alpha", Double.valueOf(0.85)).floatValue();
                inst.renderDistance = main.getDouble("render_distance", Double.valueOf(24.0)).floatValue();
                inst.renderDistance = main.getDouble("fade_distance", Double.valueOf(2.0)).floatValue();
                inst.colorOverrides = main.getList("color_overrides", new ArrayList());
                Toml items = main.getTable("Items");
                inst.allItems = items.getBoolean("all_items", Boolean.valueOf(true));
                inst.onlyRare = items.getBoolean("only_rare", Boolean.valueOf(false));
                inst.onlyEquipment = items.getBoolean("only_equipment", Boolean.valueOf(false));
                inst.whitelist = items.getList("whitelist", new ArrayList());
                inst.blacklist = items.getList("blacklist", new ArrayList());
                Toml nametags = main.getTable("Nametags");
                inst.borders = nametags.getBoolean("borders", Boolean.valueOf(true));
                inst.renderNametags = nametags.getBoolean("render_nametags", Boolean.valueOf(true));
                inst.renderNametagsOnlook = nametags.getBoolean("render_nametags_onlook", Boolean.valueOf(true));
                inst.renderStackcount = nametags.getBoolean("render_stackcount", Boolean.valueOf(true));
                inst.nametagLookSensitivity = nametags.getDouble("nametag_look_sensitivity", Double.valueOf(0.018)).floatValue();
                inst.nametagTextAlpha = nametags.getDouble("nametag_text_alpha", Double.valueOf(1.0)).floatValue();
                inst.nametagBackgroundAlpha = nametags.getDouble("nametag_background_alpha", Double.valueOf(0.5)).floatValue();
                inst.nametagScale = nametags.getDouble("nametag_scale", Double.valueOf(1.0)).floatValue();
                inst.nametagYOffset = nametags.getDouble("nametag_y_offset", Double.valueOf(0.75)).floatValue();
                inst.dmclootCompatRarity = nametags.getBoolean("dmcloot_compat_rarity", Boolean.valueOf(true));
                inst.customRarities = nametags.getList("custom_rarities", new ArrayList());
                inst.alwaysDrawRaritiesOn = nametags.getList("always_draw_rarities_on", new ArrayList());
                inst.whiteRarities = nametags.getBoolean("white_rarities", Boolean.valueOf(false));
            }
            catch (Exception e) {
                LootBeams.LOGGER.warn("cannot load config file", (Throwable)e);
                return new Configuration();
            }
        } else {
            inst.save();
        }
        return inst;
    }

    public void save() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("lootbeams-client.toml").toFile();
        HashMap<String, Object> nametags = new HashMap<String, Object>();
        nametags.put("borders", this.borders);
        nametags.put("render_nametags", this.renderNametags);
        nametags.put("render_nametags_onlook", this.renderNametagsOnlook);
        nametags.put("render_stackcount", this.renderStackcount);
        nametags.put("nametag_look_sensitivity", Float.valueOf(this.nametagLookSensitivity));
        nametags.put("nametag_text_alpha", Float.valueOf(this.nametagTextAlpha));
        nametags.put("nametag_background_alpha", Float.valueOf(this.nametagBackgroundAlpha));
        nametags.put("nametag_scale", Float.valueOf(this.nametagScale));
        nametags.put("nametag_y_offset", Float.valueOf(this.nametagYOffset));
        nametags.put("dmcloot_compat_rarity", this.dmclootCompatRarity);
        nametags.put("custom_rarities", this.customRarities);
        nametags.put("always_draw_rarities_on", this.alwaysDrawRaritiesOn);
        nametags.put("white_rarities", this.whiteRarities);
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("all_items", this.allItems);
        items.put("only_rare", this.onlyRare);
        items.put("only_equipment", this.onlyEquipment);
        items.put("whitelist", this.whitelist);
        items.put("blacklist", this.blacklist);
        HashMap<String, Object> main = new HashMap<String, Object>();
        main.put("render_name_color", this.renderNameColor);
        main.put("render_rarity_color", this.renderRarityColor);
        main.put("beam_radius", Float.valueOf(this.beamRadius));
        main.put("beam_height", Float.valueOf(this.beamHeight));
        main.put("beam_y_offset", Float.valueOf(this.beamYOffset));
        main.put("beam_alpha", Float.valueOf(this.beamAlpha));
        main.put("render_distance", Float.valueOf(this.renderDistance));
        main.put("fade_distance", Float.valueOf(this.renderDistance));
        main.put("color_overrides", this.colorOverrides);
        main.put("Items", items);
        main.put("Nametags", nametags);
        HashMap<String, HashMap<String, Object>> root = new HashMap<String, HashMap<String, Object>>();
        root.put("Loot Beams", main);
        TomlWriter tomlWriter = new TomlWriter.Builder().indentValuesBy(4).indentTablesBy(4).padArrayDelimitersBy(1).build();
        try {
            tomlWriter.write(root, configFile);
        }
        catch (IOException e) {
            LootBeams.LOGGER.warn("cannot save config file", (Throwable)e);
        }
    }

    public static class_5251 getColorFromItemOverrides(class_1792 i) {
        List<String> overrides = LootBeams.config.colorOverrides;
        if (overrides.isEmpty()) {
            return null;
        }
        for (String unparsed : overrides.stream().filter(s -> !s.isEmpty()).toList()) {
            Optional<class_6885.class_6888> tag;
            String[] configValue = unparsed.split("=");
            if (configValue.length != 2) continue;
            String nameIn = configValue[0];
            class_2960 registry = class_2960.method_12829((String)nameIn.replace("#", ""));
            class_5251 colorIn = null;
            try {
                colorIn = class_5251.method_27719((String)configValue[1]);
            }
            catch (Exception e) {
                LootBeams.LOGGER.error(String.format("Color overrides error! \"%s\" is not a valid hex color for \"%s\"", configValue[1], nameIn));
                return null;
            }
            if (!nameIn.contains(":") && class_7923.field_41178.method_10221((Object)i).method_12836().equals(nameIn)) {
                return colorIn;
            }
            if (registry == null) continue;
            if (nameIn.startsWith("#") && (tag = class_7923.field_41178.method_40272().filter(pair -> ((class_6862)pair.getFirst()).comp_327().equals((Object)registry)).findFirst().map(Pair::getSecond)).isPresent() && tag.get().method_40241((class_6880)class_7923.field_41178.method_40264((class_5321)class_7923.field_41178.method_29113((Object)i).get()).get())) {
                return colorIn;
            }
            Optional registryItem = class_7923.field_41178.method_17966(registry);
            if (!registryItem.isPresent() || ((class_1792)registryItem.get()).method_8389() != i.method_8389()) continue;
            return colorIn;
        }
        return null;
    }
}

