/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.google.common.collect.Lists;
import com.lootbeams.Configuration;
import com.lootbeams.LootBeams;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3544;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_5223;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class LootBeamRenderer
extends class_1921 {
    private static final class_2960 LOOT_BEAM_TEXTURE = new class_2960("lootbeams", "textures/entity/loot_beam.png");
    private static final class_1921 LOOT_BEAM_RENDERTYPE = LootBeamRenderer.createRenderType();

    public LootBeamRenderer(String string, class_293 vertexFormat, class_293.class_5596 mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
    }

    public static void renderLootBeam(class_4587 stack, class_4597 buffer, float pticks, long worldtime, class_1542 item) {
        float beamAlpha = LootBeams.config.beamAlpha;
        float fadeDistance = LootBeams.config.fadeDistance;
        class_746 player = class_310.method_1551().field_1724;
        double distance = player.method_5858((class_1297)item);
        if (distance < (double)fadeDistance) {
            beamAlpha = (float)((double)beamAlpha * Math.max(0.0, distance - (double)fadeDistance + 1.0));
        }
        if (beamAlpha <= 0.1f) {
            return;
        }
        float glowAlpha = beamAlpha * 0.4f;
        float beamRadius = 0.05f * LootBeams.config.beamRadius;
        float glowRadius = beamRadius + beamRadius * 0.2f;
        float beamHeight = LootBeams.config.beamHeight;
        float yOffset = LootBeams.config.beamYOffset;
        class_5251 color = LootBeamRenderer.getItemColor(item);
        float R = (float)(color.method_27716() >> 16 & 0xFF) / 255.0f;
        float G = (float)(color.method_27716() >> 8 & 0xFF) / 255.0f;
        float B = (float)(color.method_27716() & 0xFF) / 255.0f;
        stack.method_22903();
        stack.method_22903();
        float rotation = (float)Math.floorMod(worldtime, 40L) + pticks;
        stack.method_22907(class_7833.field_40716.rotationDegrees(rotation * 2.25f - 45.0f));
        stack.method_46416(0.0f, yOffset, 0.0f);
        stack.method_46416(0.0f, 1.0f, 0.0f);
        stack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        LootBeamRenderer.renderPart(stack, buffer.getBuffer(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius);
        stack.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        LootBeamRenderer.renderPart(stack, buffer.getBuffer(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius);
        stack.method_22909();
        stack.method_46416(0.0f, yOffset, 0.0f);
        stack.method_46416(0.0f, 1.0f, 0.0f);
        stack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        LootBeamRenderer.renderPart(stack, buffer.getBuffer(LOOT_BEAM_RENDERTYPE), R, G, B, glowAlpha, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -beamRadius, glowRadius, glowRadius, glowRadius);
        stack.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        LootBeamRenderer.renderPart(stack, buffer.getBuffer(LOOT_BEAM_RENDERTYPE), R, G, B, glowAlpha, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -beamRadius, glowRadius, glowRadius, glowRadius);
        stack.method_22909();
        if (LootBeams.config.renderNametags) {
            LootBeamRenderer.renderNameTag(stack, buffer, item, color);
        }
    }

    private static void renderNameTag(class_4587 stack, class_4597 buffer, class_1542 item, class_5251 color) {
        if (class_310.method_1551().field_1724.method_18276() || LootBeams.config.renderNametagsOnlook && LootBeamRenderer.isLookingAt(class_310.method_1551().field_1724, (class_1297)item, LootBeams.config.nametagLookSensitivity)) {
            int count;
            float foregroundAlpha = LootBeams.config.nametagTextAlpha;
            float backgroundAlpha = LootBeams.config.nametagBackgroundAlpha;
            double yOffset = LootBeams.config.nametagYOffset;
            int foregroundColor = color.method_27716() & 0xFFFFFF | (int)(255.0f * foregroundAlpha) << 24;
            int backgroundColor = color.method_27716() & 0xFFFFFF | (int)(255.0f * backgroundAlpha) << 24;
            stack.method_22903();
            stack.method_22904(0.0, Math.min(1.0, class_310.method_1551().field_1724.method_5858((class_1297)item) * 0.025) + yOffset, 0.0);
            stack.method_22907(class_310.method_1551().method_1561().method_24197());
            float nametagScale = LootBeams.config.nametagScale;
            stack.method_22905(-0.02f * nametagScale, -0.02f * nametagScale, 0.02f * nametagScale);
            class_327 fontrenderer = class_310.method_1551().field_1772;
            Object itemName = class_3544.method_15440((String)item.method_6983().method_7964().getString());
            if (LootBeams.config.renderStackcount && (count = item.method_6983().method_7947()) > 1) {
                itemName = (String)itemName + " x" + count;
            }
            stack.method_46416(0.0f, 0.0f, -10.0f);
            LootBeamRenderer.RenderText(fontrenderer, stack, buffer, (String)itemName, foregroundColor, backgroundColor, backgroundAlpha);
            LootBeamRenderer.DrawRarity(item, foregroundAlpha, backgroundAlpha, fontrenderer, stack, buffer);
            stack.method_22909();
        }
    }

    private static void DrawRarity(class_1542 item, float foregroundAlpha, float backgroundAlpha, class_327 fontRenderer, class_4587 stack, class_4597 buffer) {
        stack.method_22904(0.0, 10.0, 0.0);
        stack.method_22905(0.75f, 0.75f, 0.75f);
        List tooltip = item.method_6983().method_7950(null, (class_1836)class_1836.class_1837.field_41070);
        if (tooltip.size() < 2) {
            return;
        }
        boolean textDrawn = false;
        class_2561 tooltipRarity = (class_2561)tooltip.get(1);
        String rarityString = tooltipRarity.getString();
        if (textDrawn) {
            return;
        }
        if (!LootBeams.config.customRarities.contains(rarityString) && !LootBeamRenderer.AlwaysHasRarity(item.method_6983())) {
            return;
        }
        class_5251 rarityColor = LootBeams.config.whiteRarities ? class_5251.method_27718((class_124)class_124.field_1068) : LootBeamRenderer.getRawColor(tooltipRarity);
        int foregroundColor = rarityColor.method_27716() & 0xFFFFFF | (int)(255.0f * foregroundAlpha) << 24;
        int backgroundColor = rarityColor.method_27716() & 0xFFFFFF | (int)(255.0f * backgroundAlpha) << 24;
        LootBeamRenderer.RenderText(fontRenderer, stack, buffer, rarityString, foregroundColor, backgroundColor, backgroundAlpha);
    }

    private static boolean AlwaysHasRarity(class_1799 item) {
        List<String> overrides = LootBeams.config.alwaysDrawRaritiesOn;
        if (overrides.isEmpty()) {
            return false;
        }
        for (String name : overrides.stream().filter(s -> !s.isEmpty()).toList()) {
            Optional<class_6885.class_6888> tag;
            class_2960 registry = class_2960.method_12829((String)name.replace("#", ""));
            if (!name.contains(":") && class_7923.field_41178.method_10221((Object)item.method_7909()).method_12836().equals(name)) {
                return true;
            }
            if (registry == null) continue;
            if (name.startsWith("#") && (tag = class_7923.field_41178.method_40272().filter(pair -> ((class_6862)pair.getFirst()).comp_327().equals((Object)registry)).findFirst().map(Pair::getSecond)).isPresent() && tag.get().method_40241((class_6880)class_7923.field_41178.method_40264((class_5321)class_7923.field_41178.method_29113((Object)item.method_7909()).get()).get())) {
                return true;
            }
            Optional registryItem = class_7923.field_41178.method_17966(registry);
            if (!registryItem.isPresent() || ((class_1792)registryItem.get()).method_8389() != item.method_7909()) continue;
            return true;
        }
        return false;
    }

    private static void RenderText(class_327 fontRenderer, class_4587 stack, class_4597 buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        if (LootBeams.config.borders) {
            float w = (float)(-fontRenderer.method_1727(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            Matrix4f matrix = stack.method_23760().method_23761();
            fontRenderer.method_27521(text, w + 1.0f, 0.0f, bg, false, matrix, buffer, class_327.class_6415.field_33993, 0, 0);
            fontRenderer.method_27521(text, w - 1.0f, 0.0f, bg, false, matrix, buffer, class_327.class_6415.field_33993, 0, 0);
            fontRenderer.method_27521(text, w, 1.0f, bg, false, matrix, buffer, class_327.class_6415.field_33993, 0, 0);
            fontRenderer.method_27521(text, w, -1.0f, bg, false, matrix, buffer, class_327.class_6415.field_33993, 0, 0);
            stack.method_22904(0.0, 0.0, -0.01);
            matrix = stack.method_23760().method_23761();
            fontRenderer.method_27521(text, w, 0.0f, foregroundColor, false, matrix, buffer, class_327.class_6415.field_33993, 0, 0xF000E0);
            stack.method_22904(0.0, 0.0, 0.01);
        } else {
            fontRenderer.method_27521(text, (float)(-fontRenderer.method_1727(text) / 2), 0.0f, foregroundColor, false, stack.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, backgroundColor, 0xF000E0);
        }
    }

    private static class_5251 getItemColor(class_1542 item) {
        if (LootBeams.CRASH_BLACKLIST.contains(item.method_6983())) {
            return class_5251.method_27718((class_124)class_124.field_1068);
        }
        try {
            class_5251 nameColor;
            class_5251 override = Configuration.getColorFromItemOverrides(item.method_6983().method_7909());
            if (override != null) {
                return override;
            }
            if (item.method_6983().method_7985() && item.method_6983().method_7969().method_10545("lootbeams.color")) {
                return class_5251.method_27719((String)item.method_6983().method_7969().method_10558("lootbeams.color"));
            }
            if (LootBeams.config.renderNameColor && !(nameColor = LootBeamRenderer.getRawColor(item.method_6983().method_7964())).equals((Object)class_5251.method_27718((class_124)class_124.field_1068))) {
                return nameColor;
            }
            if (LootBeams.config.renderRarityColor && item.method_6983().method_7932().field_8908 != null) {
                return class_5251.method_27718((class_124)item.method_6983().method_7932().field_8908);
            }
            return class_5251.method_27718((class_124)class_124.field_1068);
        }
        catch (Exception e) {
            LootBeams.LOGGER.error("Failed to get color for (" + item.method_6983().method_7954() + "), added to temporary blacklist");
            LootBeams.CRASH_BLACKLIST.add(item.method_6983());
            LootBeams.LOGGER.info("Temporary blacklist is now : ");
            for (class_1799 s : LootBeams.CRASH_BLACKLIST) {
                LootBeams.LOGGER.info((Object)s.method_7954());
            }
            return class_5251.method_27718((class_124)class_124.field_1068);
        }
    }

    private static class_5251 getRawColor(class_2561 text) {
        ArrayList list = Lists.newArrayList();
        text.method_27658((acceptor, styleIn) -> {
            class_5223.method_27479((String)styleIn, (class_2583)acceptor, (string, style, consumer) -> {
                list.add(style);
                return true;
            });
            return Optional.empty();
        }, class_2583.field_24360);
        if (((class_2583)list.get(0)).method_10973() != null) {
            return ((class_2583)list.get(0)).method_10973();
        }
        return class_5251.method_27718((class_124)class_124.field_1068);
    }

    private static void renderPart(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        Matrix4f matrixpose = matrixentry.method_23761();
        Matrix3f matrixnormal = matrixentry.method_23762();
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderQuad(Matrix4f pose, Matrix3f normal, class_4588 builder, float red, float green, float blue, float alpha, float y, float z1, float texu1, float z, float texu) {
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, y, z1, texu1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z1, texu1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z, texu, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, y, z, texu, 0.0f, 0.0f);
    }

    private static void addVertex(Matrix4f pose, Matrix3f normal, class_4588 builder, float red, float green, float blue, float alpha, float y, float x, float z, float texu, float texv) {
        builder.method_22918(pose, x, y, z).method_22915(red, green, blue, alpha).method_22913(texu, texv).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
    }

    private static String toBinaryName(String mapName) {
        return "L" + mapName.replace('.', '/') + ";";
    }

    private static class_1921 createRenderType() {
        class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(LOOT_BEAM_TEXTURE, false, false)).method_23608(field_21383).method_23615(field_21370).method_34578(class_1921.field_29446).method_23611(class_4668.field_21386).method_23604(class_4668.field_21348).method_23616(class_1921.field_21350).method_23617(false);
        try {
            Method method = class_1921.class.getDeclaredMethod(FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1921", "method_24049", "(Ljava/lang/String;" + LootBeamRenderer.toBinaryName("net.minecraft.class_293") + LootBeamRenderer.toBinaryName("net.minecraft.class_293$class_5596") + "IZZ" + LootBeamRenderer.toBinaryName("net.minecraft.class_1921$class_4688") + ")" + LootBeamRenderer.toBinaryName("net.minecraft.class_1921$class_4687")), String.class, class_293.class, class_293.class_5596.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, class_1921.class_4688.class);
            method.setAccessible(true);
            return (class_1921)method.invoke(null, "loot_beam", class_290.field_1590, class_293.class_5596.field_27382, 256, false, true, state);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return class_1921.method_24294((class_2960)LOOT_BEAM_TEXTURE, (boolean)false);
        }
    }

    private static boolean isLookingAt(class_746 player, class_1297 target, double accuracy) {
        class_243 difference = new class_243(target.method_23317() - player.method_23317(), target.method_23320() - player.method_23320(), target.method_23321() - player.method_23321());
        double length = difference.method_1033();
        double dot = player.method_5828(1.0f).method_1029().method_1026(difference.method_1029());
        return dot > 1.0 - accuracy / length && player.method_6057(target);
    }
}

