/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidStackImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftFluidStack {
    public static final Codec<SoftFluidStack> CODEC = RecordCodecBuilder.create(i -> i.group((App)SoftFluid.HOLDER_CODEC.fieldOf("id").forGetter(SoftFluidStack::getHolder), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(SoftFluidStack::getCount), (App)class_2487.field_25128.optionalFieldOf("tag", null).forGetter(SoftFluidStack::getTag)).apply((Applicative)i, SoftFluidStack::of));
    private final class_6880<SoftFluid> fluidHolder;
    private final SoftFluid fluid;
    private int count;
    @Nullable
    private class_2487 tag;
    private boolean isEmptyCache;

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public SoftFluidStack(class_6880<SoftFluid> fluid, int count, @Nullable class_2487 tag) {
        this.fluidHolder = fluid;
        this.fluid = (SoftFluid)this.fluidHolder.comp_349();
        this.tag = tag;
        this.count = count;
        this.updateEmpty();
        if (fluid.method_40226(BuiltInSoftFluids.POTION.getID()) && (this.tag == null || PotionNBTHelper.getPotionType(this.tag) == null)) {
            PotionNBTHelper.Type.REGULAR.applyToTag(this.getOrCreateTag());
        }
    }

    @Deprecated(forRemoval=true)
    public SoftFluidStack(class_6880<SoftFluid> fluid, int count) {
        this(fluid, count, null);
    }

    @Deprecated(forRemoval=true)
    public SoftFluidStack(class_6880<SoftFluid> fluid) {
        this(fluid, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count, @Nullable class_2487 tag) {
        void var2_2;
        void var1_1;
        return SoftFluidStackImpl.of(fluid, (int)var1_1, (class_2487)var2_2);
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count) {
        return SoftFluidStack.of(fluid, count, null);
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, 1, null);
    }

    public static SoftFluidStack bucket(class_6880<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BUCKET_COUNT);
    }

    public static SoftFluidStack bowl(class_6880<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BOWL_COUNT);
    }

    public static SoftFluidStack bottle(class_6880<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BOTTLE_COUNT);
    }

    public static SoftFluidStack empty() {
        return SoftFluidStack.of(SoftFluidRegistry.getEmpty(), 0, null);
    }

    public class_2487 save(class_2487 compoundTag) {
        compoundTag.method_10582("id", ((class_5321)this.getHolder().method_40230().get()).method_29177().toString());
        compoundTag.method_10567("count", (byte)this.count);
        if (this.tag != null) {
            compoundTag.method_10566("tag", (class_2520)this.tag.method_10553());
        }
        return compoundTag;
    }

    public static SoftFluidStack load(class_2487 tag) {
        if (tag.method_10545("Fluid")) {
            tag.method_10582("id", tag.method_10558("Fluid"));
            tag.method_10551("Fluid");
        }
        if (tag.method_10545("NBT")) {
            tag.method_10566("tag", tag.method_10580("NBT"));
            tag.method_10551("NBT");
        }
        if (tag.method_10545("Count")) {
            tag.method_10567("count", (byte)tag.method_10550("Count"));
            tag.method_10551("count");
        }
        class_6880<SoftFluid> fluid = SoftFluidRegistry.getHolder(new class_2960(tag.method_10558("id")));
        byte amount = tag.method_10571("count");
        class_2487 nbt = null;
        if (tag.method_10573("tag", 10)) {
            nbt = tag.method_10562("tag");
        }
        return SoftFluidStack.of(fluid, amount, nbt);
    }

    public boolean is(class_6862<SoftFluid> tag) {
        return this.getHolder().method_40220(tag);
    }

    public boolean is(SoftFluid fluid) {
        return this.fluid() == fluid;
    }

    public boolean is(class_6880<SoftFluid> fluid) {
        return this.is((SoftFluid)fluid.comp_349());
    }

    @Deprecated(forRemoval=true)
    public final class_6880<SoftFluid> getFluid() {
        return this.isEmptyCache ? SoftFluidRegistry.getEmpty() : this.fluidHolder;
    }

    public final class_6880<SoftFluid> getHolder() {
        return this.isEmptyCache ? SoftFluidRegistry.getEmpty() : this.fluidHolder;
    }

    public final SoftFluid fluid() {
        return this.isEmptyCache ? SoftFluidRegistry.empty() : this.fluid;
    }

    public boolean isEmpty() {
        return this.isEmptyCache;
    }

    protected void updateEmpty() {
        this.isEmptyCache = this.count <= 0 || this.fluid.isEmptyFluid();
    }

    public int getCount() {
        return this.isEmptyCache ? 0 : this.count;
    }

    public void setCount(int count) {
        if (this.fluid.isEmptyFluid()) {
            if (PlatHelper.isDev()) {
                throw new AssertionError();
            }
            return;
        }
        this.count = count;
        this.updateEmpty();
    }

    public void grow(int amount) {
        this.setCount(this.count + amount);
    }

    public void shrink(int amount) {
        this.setCount(this.count - amount);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Nullable
    public class_2487 getTag() {
        return this.tag;
    }

    public void setTag(@Nullable class_2487 tag) {
        if (this.fluid.isEmptyFluid()) {
            if (PlatHelper.isDev()) {
                throw new AssertionError();
            }
            return;
        }
        this.tag = tag;
    }

    public class_2487 getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new class_2487());
        }
        return this.tag;
    }

    public class_2487 getOrCreateTagElement(String key) {
        if (this.tag != null && this.tag.method_10573(key, 10)) {
            return this.tag.method_10562(key);
        }
        class_2487 compoundTag = new class_2487();
        this.addTagElement(key, (class_2520)compoundTag);
        return compoundTag;
    }

    public void addTagElement(String key, class_2520 tag) {
        this.getOrCreateTag().method_10566(key, tag);
    }

    public SoftFluidStack copy() {
        return SoftFluidStack.of(this.getHolder(), this.count, this.tag == null ? null : this.tag.method_10553());
    }

    public SoftFluidStack copyWithCount(int count) {
        SoftFluidStack stack = this.copy();
        if (!stack.isEmpty()) {
            stack.setCount(count);
        }
        return stack;
    }

    public SoftFluidStack split(int amount) {
        int i = Math.min(amount, this.getCount());
        SoftFluidStack stack = this.copyWithCount(i);
        if (!this.isEmpty()) {
            this.shrink(i);
        }
        return stack;
    }

    public boolean isFluidEqual(SoftFluidStack other) {
        return this.fluid() == other.fluid() && this.isFluidStackTagEqual(other);
    }

    public boolean isFluidStackTagEqual(SoftFluidStack other) {
        return Objects.equals(this.tag, other.tag);
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.fluid().hashCode();
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public final boolean equals(Object o) {
        if (o instanceof SoftFluidStack) {
            SoftFluidStack ss = (SoftFluidStack)o;
            return this.isFluidEqual(ss);
        }
        return false;
    }

    public String toString() {
        String s = this.count + " " + String.valueOf(((class_5321)this.getHolder().method_40230().get()).method_29177());
        if (this.tag != null) {
            s = s + " [" + String.valueOf(this.tag) + "]";
        }
        return s;
    }

    @NotNull
    public static SoftFluidStack fromFluid(class_3611 fluid, int amount, @Nullable class_2487 tag) {
        class_6880<SoftFluid> f = SoftFluidInternal.FLUID_MAP.get(fluid);
        if (f == null) {
            return SoftFluidStack.empty();
        }
        return SoftFluidStack.of(f, amount, tag);
    }

    @NotNull
    public static SoftFluidStack fromFluid(class_3610 fluid) {
        if (fluid.method_15767(class_3486.field_15517)) {
            return SoftFluidStack.fromFluid(fluid.method_15772(), 3, null);
        }
        return SoftFluidStack.fromFluid(fluid.method_15772(), SoftFluid.BUCKET_COUNT, null);
    }

    @Nullable
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(class_1799 itemStack) {
        Optional<FluidContainerList.Category> category;
        class_1792 filledContainer = itemStack.method_7909();
        class_6880<SoftFluid> fluid = SoftFluidInternal.ITEM_MAP.get(filledContainer);
        if (fluid != null && !((SoftFluid)fluid.comp_349()).isEmptyFluid() && (category = ((SoftFluid)fluid.comp_349()).getContainerList().getCategoryFromFilled(filledContainer)).isPresent()) {
            boolean hasCustomPot;
            int count = category.get().getAmount();
            class_2487 fluidTag = new class_2487();
            class_2487 itemTag = itemStack.method_7969();
            class_1842 potion = class_1844.method_8063((class_1799)itemStack);
            boolean bl = hasCustomPot = itemTag != null && itemTag.method_10545("CustomPotionEffects");
            if (potion == class_1847.field_8991 && !hasCustomPot) {
                fluid = BuiltInSoftFluids.WATER.getHolder();
            } else if (potion != class_1847.field_8984 || hasCustomPot) {
                PotionNBTHelper.Type type = PotionNBTHelper.getPotionType(filledContainer);
                if (type == null) {
                    type = PotionNBTHelper.Type.REGULAR;
                }
                type.applyToTag(fluidTag);
            }
            if (itemTag != null) {
                for (String k : ((SoftFluid)fluid.comp_349()).getNbtKeyFromItem()) {
                    class_2520 c = itemTag.method_10580(k);
                    if (c == null) continue;
                    fluidTag.method_10566(k, c);
                }
            }
            if (fluidTag.method_33133()) {
                fluidTag = null;
            }
            return Pair.of((Object)SoftFluidStack.of(fluid, count, fluidTag), (Object)category.get());
        }
        return null;
    }

    @Nullable
    public Pair<class_1799, FluidContainerList.Category> toItem(class_1799 emptyContainer, boolean dontModifyStack) {
        FluidContainerList.Category category;
        int shrinkAmount;
        Optional<FluidContainerList.Category> opt = this.fluid().getContainerList().getCategoryFromEmpty(emptyContainer.method_7909());
        if (opt.isPresent() && (shrinkAmount = (category = opt.get()).getAmount()) <= this.getCount()) {
            PotionNBTHelper.Type type;
            class_1799 filledStack = new class_1799((class_1935)category.getFirstFilled().get());
            if (this.is(BuiltInSoftFluids.POTION.getHolder()) && this.tag != null && (type = PotionNBTHelper.getPotionType(this.tag)) != null && !Utils.getID(emptyContainer.method_7909()).method_12836().equals("inspirations") && type != PotionNBTHelper.Type.REGULAR) {
                filledStack = type.getDefaultItem();
            }
            if (emptyContainer.method_31574(class_1802.field_8469) && this.is(BuiltInSoftFluids.WATER)) {
                filledStack = class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991);
            }
            this.applyNBTtoItemStack(filledStack);
            if (!dontModifyStack) {
                this.shrink(shrinkAmount);
            }
            return Pair.of((Object)filledStack, (Object)category);
        }
        return null;
    }

    protected void applyNBTtoItemStack(class_1799 stack) {
        List<String> nbtKey = this.fluid().getNbtKeyFromItem();
        if (this.tag != null && !this.tag.method_33133()) {
            class_2487 newCom = new class_2487();
            for (String s : nbtKey) {
                class_2520 c = this.tag.method_10580(s);
                if (c == null || s.equals("Bottle")) continue;
                newCom.method_10566(s, c);
            }
            if (!newCom.method_33133()) {
                stack.method_7980(newCom);
            }
        }
    }

    public FluidContainerList getContainerList() {
        return this.fluid().getContainerList();
    }

    public FoodProvider getFoodProvider() {
        return this.fluid().getFoodProvider();
    }

    public boolean isEquivalent(class_3611 fluid) {
        return this.fluid().isEquivalent(fluid);
    }

    public class_3611 getVanillaFluid() {
        return this.fluid().getVanillaFluid();
    }

    public int getStillColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        SoftFluid fluid = this.fluid();
        SoftFluid.TintMethod method = fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) {
            return -1;
        }
        int specialColor = SoftFluidColors.getSpecialColor(this, world, pos);
        if (specialColor != 0) {
            return specialColor;
        }
        return fluid.getTintColor();
    }

    public int getFlowingColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        SoftFluid.TintMethod method = this.fluid().getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) {
            return this.getParticleColor(world, pos);
        }
        return this.getStillColor(world, pos);
    }

    public int getParticleColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        int tintColor = this.getStillColor(world, pos);
        if (tintColor == -1) {
            return this.fluid().getAverageTextureTintColor();
        }
        return tintColor;
    }
}

