/*
 * Decompiled with CFR 0.152.
 */
package de.kxmischesdomi.more_axolotl.common;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import de.kxmischesdomi.more_axolotl.common.CustomAxolotlVariant;
import de.kxmischesdomi.more_axolotl.mixin.server.AxolotlVariantAccessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_5762;
import net.minecraft.class_5819;

public class AxolotlVariantManager {
    private static final Supplier<Map<Integer, class_5762.class_5767>> ID_TO_VARIANT = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (class_5762.class_5767 variant : class_5762.class_5767.values()) {
            builder.put((Object)variant.method_33233(), (Object)variant);
        }
        return builder.build();
    });
    public static Supplier<Map<class_5762.class_5767[], class_5762.class_5767[]>> BREEDS = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)new class_5762.class_5767[]{class_5762.class_5767.field_28343, CustomAxolotlVariant.BLACK.getVariant()}, (Object)new class_5762.class_5767[]{CustomAxolotlVariant.ENIGMA.getVariant()}).put((Object)new class_5762.class_5767[]{class_5762.class_5767.field_28341, class_5762.class_5767.field_28342}, (Object)new class_5762.class_5767[]{CustomAxolotlVariant.CHIMERA.getVariant()}).put((Object)new class_5762.class_5767[]{CustomAxolotlVariant.ALBINO.getVariant(), CustomAxolotlVariant.BLACK.getVariant()}, (Object)new class_5762.class_5767[]{CustomAxolotlVariant.FIREFLY.getVariant(), CustomAxolotlVariant.PIEBALD.getVariant(), CustomAxolotlVariant.FIREFLY_INVERTED.getVariant()}).put((Object)new class_5762.class_5767[]{CustomAxolotlVariant.LAPIS.getVariant(), class_5762.class_5767.field_28341}, (Object)new class_5762.class_5767[]{CustomAxolotlVariant.MOSAIC_WILD.getVariant(), CustomAxolotlVariant.MOSAIC_BLACK.getVariant()}).build());
    public static Supplier<Map<class_5762.class_5767[], class_5762.class_5767[]>> BREED_PARENTS = Suppliers.memoize(() -> ((BiMap)BREEDS.get()).inverse());
    public static Supplier<Map<String, class_5762.class_5767>> CUSTOM_NAME_VARIANTS = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)"skelotl", (Object)CustomAxolotlVariant.SKELETON.getVariant()).put((Object)"drownelotl", (Object)CustomAxolotlVariant.DROWNED.getVariant()).build());
    public static Supplier<HashSet<class_5762.class_5767>> RARE_BREEDS = Suppliers.memoize(() -> {
        HashSet<class_5762.class_5767> variants = new HashSet<class_5762.class_5767>(Arrays.asList(class_5762.class_5767.values()));
        variants.addAll(Arrays.stream(CustomAxolotlVariant.values()).map(CustomAxolotlVariant::getVariant).collect(Collectors.toList()));
        variants.removeIf(variant -> ((AxolotlVariantAccessor)variant).isCommon());
        for (class_5762.class_5767 class_57672 : CUSTOM_NAME_VARIANTS.get().values()) {
            variants.remove(class_57672);
        }
        Iterator<class_5762.class_5767> iterator = BREEDS.get().values().iterator();
        while (iterator.hasNext()) {
            class_5762.class_5767[] class_5767Array;
            for (class_5762.class_5767 variant2 : class_5767Array = (class_5762.class_5767[])iterator.next()) {
                variants.remove(variant2);
            }
        }
        return variants;
    });

    public static class_5762.class_5767 getRandomBreed(class_5819 random) {
        class_5762.class_5767[] variants = RARE_BREEDS.get().toArray(new class_5762.class_5767[0]);
        return variants[random.method_43048(variants.length)];
    }

    public static class_5762.class_5767 getBreed(class_5762.class_5767 parent1, class_5762.class_5767 parent2, class_5819 random) {
        for (Map.Entry<class_5762.class_5767[], class_5762.class_5767[]> entry : BREEDS.get().entrySet()) {
            List<class_5762.class_5767> variants = Arrays.asList(entry.getKey());
            if (!variants.contains(parent1) || !variants.contains(parent2)) continue;
            return entry.getValue()[random.method_43048(entry.getValue().length)];
        }
        return null;
    }
}

