/*
 * Decompiled with CFR 0.152.
 */
package de.kxmischesdomi.more_axolotl.mixin.common;

import de.kxmischesdomi.more_axolotl.common.AxolotlAccessor;
import de.kxmischesdomi.more_axolotl.common.AxolotlVariantManager;
import de.kxmischesdomi.more_axolotl.common.CustomAxolotlVariant;
import de.kxmischesdomi.more_axolotl.mixin.server.AxolotlVariantAccessor;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_5762;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_5762.class})
public abstract class AxolotlMixin
extends class_1429
implements AxolotlAccessor {
    @Shadow
    @Final
    private static class_2940<Integer> field_28335;
    private static final UUID AXOLOTL_ARMOR_BONUS_ID;
    private static final class_2940<Float> LEAF_DURABILITY;
    private static final class_2940<Boolean> HAS_LEAF;
    private static final class_2940<Integer> MOUTH_OPEN_TICKS;
    public int guiAge = 0;

    @Shadow
    public abstract class_1269 method_5992(class_1657 var1, class_1268 var2);

    @Shadow
    public abstract void method_6454(boolean var1);

    @Shadow
    public abstract class_5762.class_5767 method_33225();

    @Shadow
    public abstract class_1310 method_6046();

    public AxolotlMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyArgs(method={"getBreedOffspring"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/axolotl/Axolotl;setVariant(Lnet/minecraft/world/entity/animal/axolotl/Axolotl$Variant;)V"))
    public void getBreedOffspring(Args args, class_3218 world, class_1296 entity) {
        class_5762.class_5767 result;
        class_5762.class_5767 variant2;
        if (args.get(0) != null && !((AxolotlVariantAccessor)args.get(0)).isCommon()) {
            return;
        }
        class_5762 thisEntity = this.getEntity();
        class_5762.class_5767 variant1 = thisEntity.method_33225();
        if (variant1 != (variant2 = ((class_5762)entity).method_33225()) && entity.method_6051().method_43048(10) < 4 && (result = AxolotlVariantManager.getBreed(variant1, variant2, world.method_8409())) != null) {
            args.set(0, (Object)result);
        }
    }

    @Inject(method={"useRareVariant"}, at={@At(value="HEAD")}, cancellable=true)
    private static void useRareVariant(class_5819 random, CallbackInfoReturnable<Boolean> cir) {
        boolean b;
        boolean bl = b = random.method_43048(1200) < AxolotlVariantManager.RARE_BREEDS.get().size() - 1;
        if (b) {
            cir.setReturnValue((Object)true);
        }
    }

    public void method_6480(@Nullable class_1657 player) {
        this.setMouthOpenTicks(10);
        super.method_6480(player);
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_31574(class_1802.field_28657) && !this.hasLeaf()) {
            this.setLeaf(true);
            if (!player.method_7337()) {
                stackInHand.method_7934(1);
            }
            cir.setReturnValue((Object)class_1269.field_5812);
        } else if (stackInHand.method_31574(class_1802.field_8324) && this.hasLeaf() && this.getLeafDurability() <= 10.0f) {
            this.setLeafDurability(this.getLeafDurability() + 5.0f);
            if (!player.method_7337()) {
                stackInHand.method_7934(1);
            }
            cir.setReturnValue((Object)class_1269.field_5812);
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void defineSynchedData(CallbackInfo ci) {
        this.field_6011.method_12784(HAS_LEAF, (Object)false);
        this.field_6011.method_12784(LEAF_DURABILITY, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(MOUTH_OPEN_TICKS, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("HasLeaf", ((Boolean)this.field_6011.method_12789(HAS_LEAF)).booleanValue());
        nbt.method_10548("LeafDurability", ((Float)this.field_6011.method_12789(LEAF_DURABILITY)).floatValue());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    public void readAdditionalSaveData(class_2487 nbt, CallbackInfo ci) {
        this.method_6454(nbt.method_10577("FromBucket"));
        this.field_6011.method_12778(HAS_LEAF, (Object)nbt.method_10577("HasLeaf"));
        this.field_6011.method_12778(LEAF_DURABILITY, (Object)Float.valueOf(nbt.method_10583("LeafDurability")));
    }

    @Inject(method={"saveToBucketTag"}, at={@At(value="HEAD")})
    public void saveToBucketTag(class_1799 itemStack, CallbackInfo ci) {
        class_2487 compoundTag = itemStack.method_7948();
        compoundTag.method_10556("HasLeaf", ((Boolean)this.field_6011.method_12789(HAS_LEAF)).booleanValue());
        compoundTag.method_10548("LeafDurability", ((Float)this.field_6011.method_12789(LEAF_DURABILITY)).floatValue());
    }

    @Inject(method={"loadFromBucketTag"}, at={@At(value="HEAD")}, cancellable=true)
    public void loadFromBucketTag(class_2487 nbt, CallbackInfo ci) {
        this.field_6011.method_12778(HAS_LEAF, (Object)nbt.method_10577("HasLeaf"));
        this.field_6011.method_12778(LEAF_DURABILITY, (Object)Float.valueOf(nbt.method_10583("LeafDurability")));
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    public void baseTick(CallbackInfo ci) {
        if (this.method_37908().field_9236 && this.getMouthOpenTicks() > 0) {
            this.setMouthOpenTicks(this.getMouthOpenTicks() - 1);
        }
        if (this.method_33225() == CustomAxolotlVariant.GLOW.getVariant() && this.field_5974.method_43048(7) == 0) {
            this.method_37908().method_8406((class_2394)class_2398.field_28479, this.method_23322(0.6), this.method_23319(), this.method_23325(0.6), 0.0, 0.0, 0.0);
        }
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD")})
    public void doHurtTarget(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        this.setMouthOpenTicks(Math.max(this.getMouthOpenTicks(), 10));
    }

    @Inject(method={"usePlayerItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void usePlayerItem(class_1657 player, class_1268 interactionHand, class_1799 itemStack, CallbackInfo ci) {
        if (itemStack.method_31574(class_1802.field_8478) && player.method_31549().field_7477) {
            ci.cancel();
        }
    }

    @Override
    public int getVariantId() {
        return (Integer)this.field_6011.method_12789(field_28335);
    }

    @Override
    public void setLeaf(boolean leaf) {
        this.field_6011.method_12778(HAS_LEAF, (Object)leaf);
        if (leaf) {
            this.setLeafDurability(15.0f);
        } else {
            this.setLeafDurability(0.0f);
        }
        if (!this.method_37908().field_9236) {
            this.method_5996(class_5134.field_23724).method_6200(AXOLOTL_ARMOR_BONUS_ID);
            if (this.hasLeaf()) {
                this.method_5996(class_5134.field_23724).method_26835(new class_1322(AXOLOTL_ARMOR_BONUS_ID, "Axolotl armor bonus", 15.0, class_1322.class_1323.field_6328));
            }
        }
    }

    public void method_6105(class_1282 source, float amount) {
        this.setLeafDurability(this.getLeafDurability() - amount);
        super.method_6105(source, amount);
    }

    @Override
    public boolean hasLeaf() {
        return (Boolean)this.field_6011.method_12789(HAS_LEAF);
    }

    @Override
    public float getLeafDurability() {
        return ((Float)this.field_6011.method_12789(LEAF_DURABILITY)).floatValue();
    }

    @Override
    public void setLeafDurability(float damage) {
        this.field_6011.method_12778(LEAF_DURABILITY, (Object)Float.valueOf(damage));
        if (this.hasLeaf() && this.getLeafDurability() < 0.0f) {
            this.setLeaf(false);
            this.setLeafDurability(0.0f);
            this.method_5783(class_3417.field_15075, 0.5f, 1.0f);
        }
    }

    @Override
    public int getMouthOpenTicks() {
        return (Integer)this.field_6011.method_12789(MOUTH_OPEN_TICKS);
    }

    @Override
    public void setMouthOpenTicks(int ticks) {
        this.field_6011.method_12778(MOUTH_OPEN_TICKS, (Object)ticks);
    }

    @Override
    public void setGuiAge(int guiAge) {
        this.guiAge = guiAge;
    }

    @Override
    public int getGuiAge() {
        return this.guiAge;
    }

    public class_5762 getEntity() {
        return (class_5762)this;
    }

    static {
        AXOLOTL_ARMOR_BONUS_ID = UUID.fromString("0b66fd1e-2b86-11ec-8d3d-0242ac130003");
        HAS_LEAF = class_2945.method_12791(class_5762.class, (class_2941)class_2943.field_13323);
        LEAF_DURABILITY = class_2945.method_12791(class_5762.class, (class_2941)class_2943.field_13320);
        MOUTH_OPEN_TICKS = class_2945.method_12791(class_5762.class, (class_2941)class_2943.field_13327);
    }
}

