/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.datagen;

import java.util.HashMap;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.hibiscus.naturespirit.registration.FlowerSet;
import net.hibiscus.naturespirit.registration.HibiscusRegistryHelper;
import net.hibiscus.naturespirit.registration.StoneSet;
import net.hibiscus.naturespirit.registration.WoodSet;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusColoredBlocks;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusMiscBlocks;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusWoods;
import net.minecraft.class_116;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_182;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_192;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_212;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3489;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_8169;
import net.minecraft.class_85;
import net.minecraft.class_94;

class NatureSpiritBlockLootTableProvider
extends FabricBlockLootTableProvider {
    private static final class_5341.class_210 WITH_SILK_TOUCH_OR_SHEARS = field_40604.method_893(field_40602);
    private static final class_5341.class_210 WITHOUT_SILK_TOUCH_NOR_SHEARS = WITH_SILK_TOUCH_OR_SHEARS.method_16780();
    private final float[] SAPLING_DROP_CHANCE_2 = new float[]{0.4f, 0.45333335f, 0.625f, 0.758f};

    protected NatureSpiritBlockLootTableProvider(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    private void addWoodTable(HashMap<String, WoodSet> woods) {
        for (WoodSet woodSet : woods.values()) {
            if (woodSet.hasBark()) {
                this.method_46025(woodSet.getWood());
                this.method_46025(woodSet.getStrippedWood());
            }
            if (woodSet.hasMosaic()) {
                this.method_46025(woodSet.getMosaic());
                this.method_46025(woodSet.getMosaicStairs());
                this.method_45994(woodSet.getMosaicSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
            }
            if (woodSet.getWoodPreset() == WoodSet.WoodPreset.JOSHUA) {
                this.method_46025(woodSet.getBundle());
                this.method_46025(woodSet.getStrippedBundle());
            }
            this.method_46025(woodSet.getLog());
            this.method_46025(woodSet.getStrippedLog());
            this.method_46025(woodSet.getPlanks());
            this.method_46025(woodSet.getButton());
            this.method_45994(woodSet.getDoor(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46022(arg_0));
            this.method_46025(woodSet.getStairs());
            this.method_45994(woodSet.getSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
            this.method_46025(woodSet.getFence());
            this.method_46025(woodSet.getTrapDoor());
            this.method_46025(woodSet.getSign());
            this.method_46025(woodSet.getHangingSign());
            this.method_46025(woodSet.getPressurePlate());
            this.method_46025(woodSet.getFenceGate());
        }
    }

    private void addStoneTable(HashMap<String, StoneSet> stones) {
        for (StoneSet stoneSet : stones.values()) {
            if (stoneSet.hasTiles()) {
                this.method_46025(stoneSet.getTiles());
                this.method_46025(stoneSet.getTilesStairs());
                this.method_45994(stoneSet.getTilesSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
                this.method_46025(stoneSet.getTilesWall());
            }
            if (stoneSet.hasMossy()) {
                this.method_46025(stoneSet.getMossyBricks());
                this.method_46025(stoneSet.getMossyBricksStairs());
                this.method_45994(stoneSet.getMossyBricksSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
                this.method_46025(stoneSet.getMossyBricksWall());
            }
            if (stoneSet.hasCracked()) {
                this.method_46025(stoneSet.getCrackedBricks());
            }
            if (stoneSet.hasCobbled()) {
                this.method_46025(stoneSet.getCobbled());
                this.method_46025(stoneSet.getCobbledStairs());
                this.method_45994(stoneSet.getCobbledSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
                this.method_46025(stoneSet.getCobbledWall());
                this.method_45994(stoneSet.getBase(), block -> this.method_45983((class_2248)block, (class_1935)stoneSet.getCobbled()));
                if (stoneSet.hasMossy()) {
                    this.method_46025(stoneSet.getMossyCobbled());
                    this.method_46025(stoneSet.getMossyCobbledStairs());
                    this.method_45994(stoneSet.getMossyCobbledSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
                    this.method_46025(stoneSet.getMossyCobbledWall());
                }
            } else {
                this.method_46025(stoneSet.getBase());
            }
            this.method_46025(stoneSet.getBaseStairs());
            this.method_45994(stoneSet.getBaseSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
            this.method_46025(stoneSet.getBricks());
            this.method_46025(stoneSet.getBricksStairs());
            this.method_45994(stoneSet.getBricksSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
            this.method_46025(stoneSet.getBricksWall());
            this.method_46025(stoneSet.getPolished());
            this.method_46025(stoneSet.getPolishedStairs());
            this.method_45994(stoneSet.getPolishedSlab(), arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
            this.method_46025(stoneSet.getPolishedWall());
        }
    }

    private void addFlowerTable(HashMap<String, FlowerSet> flowers) {
        for (FlowerSet flowerSet : flowers.values()) {
            if (flowerSet.isTall()) {
                this.method_45994(flowerSet.getFlowerBlock(), block -> this.method_45987((class_2248)block, (class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607));
                continue;
            }
            this.method_46025(flowerSet.getFlowerBlock());
            this.method_46023(flowerSet.getPottedFlowerBlock());
        }
    }

    public class_52.class_53 blackOlivesDrop(class_2248 leaves, class_2248 drop, float ... chance) {
        return this.method_45986(leaves, drop, chance).method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(WITHOUT_SILK_TOUCH_NOR_SHEARS).method_351(((class_85.class_86)this.method_45978((class_1935)leaves, (class_192)class_77.method_411((class_1935)HibiscusMiscBlocks.BLACK_OLIVES))).method_421(class_182.method_800((class_1887)class_1893.field_9130, (float[])new float[]{0.01f, 0.011111111f, 0.0125f, 0.016666668f, 0.05f}))));
    }

    public class_52.class_53 greenOlivesDrop(class_2248 leaves, class_2248 drop, float ... chance) {
        return this.blackOlivesDrop(leaves, drop, chance).method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(WITHOUT_SILK_TOUCH_NOR_SHEARS).method_351(((class_85.class_86)this.method_45978((class_1935)leaves, (class_192)class_77.method_411((class_1935)HibiscusMiscBlocks.GREEN_OLIVES))).method_421(class_182.method_800((class_1887)class_1893.field_9130, (float[])new float[]{0.01f, 0.011111111f, 0.0125f, 0.016666668f, 0.05f}))));
    }

    public class_52.class_53 noSaplingLeavesDrop(class_2248 leaves) {
        class_1792 drop = class_1802.field_8600;
        return NatureSpiritBlockLootTableProvider.method_46008((class_2248)leaves, (class_79.class_80)((class_85.class_86)this.method_45978((class_1935)leaves, (class_192)class_77.method_411((class_1935)drop))).method_421(class_182.method_800((class_1887)class_1893.field_9130, (float[])field_40605))).method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(WITHOUT_SILK_TOUCH_NOR_SHEARS).method_351(((class_85.class_86)this.method_45977((class_1935)leaves, (class_116)class_77.method_411((class_1935)class_1802.field_8600).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)2.0f))))).method_421(class_182.method_800((class_1887)class_1893.field_9130, (float[])field_40611))));
    }

    private void addTreeTable(HashMap<String, class_2248[]> saplings, HashMap<String, class_2248> leaves) {
        for (String i : leaves.keySet()) {
            class_2248 leavesType = leaves.get(i);
            if (saplings.get(i) != null) {
                class_2248[] saplingType = saplings.get(i);
                this.method_46025(saplingType[0]);
                this.method_46023(saplingType[1]);
                switch (i) {
                    case "olive": {
                        this.method_45994(leavesType, block -> this.greenOlivesDrop((class_2248)block, saplingType[0], field_40605));
                        break;
                    }
                    case "joshua": {
                        this.method_45994(leavesType, block -> this.method_45986((class_2248)block, saplingType[0], this.SAPLING_DROP_CHANCE_2));
                        break;
                    }
                    default: {
                        this.method_45994(leavesType, block -> this.method_45986((class_2248)block, saplingType[0], field_40605));
                        break;
                    }
                }
                continue;
            }
            this.method_45994(leavesType, this::noSaplingLeavesDrop);
        }
    }

    public class_52.class_53 flowerbedDropsWithShears(class_2248 flowerbed) {
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)this.method_45977((class_1935)flowerbed, class_77.method_411((class_1935)flowerbed).method_43739(IntStream.rangeClosed(1, 4).boxed().toList(), flowerAmount -> class_141.method_621((class_5658)class_44.method_32448((float)flowerAmount.intValue())).method_524((class_5341.class_210)class_212.method_900((class_2248)flowerbed).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)class_8169.field_42765, flowerAmount.intValue()))).method_524(WITH_SILK_TOUCH_OR_SHEARS)))));
    }

    public void method_10379() {
        this.addFlowerTable(HibiscusRegistryHelper.FlowerHashMap);
        this.addStoneTable(HibiscusRegistryHelper.StoneHashMap);
        this.addWoodTable(HibiscusRegistryHelper.WoodHashMap);
        this.addTreeTable(HibiscusRegistryHelper.SaplingHashMap, HibiscusRegistryHelper.LeavesHashMap);
        this.method_45994(HibiscusMiscBlocks.CALCITE_CLUSTER, block -> NatureSpiritBlockLootTableProvider.method_45989((class_2248)block, (class_79.class_80)((class_85.class_86)class_77.method_411((class_1935)HibiscusMiscBlocks.CALCITE_SHARD).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)4.0f))).method_438((class_117.class_118)class_94.method_455((class_1887)class_1893.field_9130)).method_421(class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8975(class_3489.field_29544)))).method_417((class_79.class_80)this.method_45977((class_1935)block, (class_116)class_77.method_411((class_1935)HibiscusMiscBlocks.CALCITE_SHARD).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)2.0f)))))));
        this.method_46024(HibiscusMiscBlocks.SMALL_CALCITE_BUD);
        this.method_46024(HibiscusMiscBlocks.LARGE_CALCITE_BUD);
        this.method_45999(HibiscusWoods.WISTERIA.getWhiteWisteriaVines(), HibiscusWoods.WISTERIA.getWhiteWisteriaVinesPlant());
        this.method_45999(HibiscusWoods.WISTERIA.getBlueWisteriaVines(), HibiscusWoods.WISTERIA.getBlueWisteriaVinesPlant());
        this.method_45999(HibiscusWoods.WISTERIA.getPurpleWisteriaVines(), HibiscusWoods.WISTERIA.getPurpleWisteriaVinesPlant());
        this.method_45999(HibiscusWoods.WISTERIA.getPinkWisteriaVines(), HibiscusWoods.WISTERIA.getPinkWisteriaVinesPlant());
        this.method_45999(HibiscusWoods.WILLOW.getWillowVines(), HibiscusWoods.WILLOW.getWillowVinesPlant());
        this.method_45988(HibiscusWoods.FIR.getFrostyLeaves(), this.method_45986(HibiscusWoods.FIR.getFrostyLeaves(), HibiscusWoods.FIR.getSapling(), field_40605));
        this.method_46025(HibiscusMiscBlocks.ALLUAUDIA);
        this.method_46025(HibiscusMiscBlocks.ALLUAUDIA_BUNDLE);
        this.method_46025(HibiscusMiscBlocks.STRIPPED_ALLUAUDIA);
        this.method_46025(HibiscusMiscBlocks.STRIPPED_ALLUAUDIA_BUNDLE);
        this.method_45994(HibiscusMiscBlocks.CHERT_COAL_ORE, block -> this.method_45981((class_2248)block, class_1802.field_8713));
        this.method_45994(HibiscusMiscBlocks.CHERT_EMERALD_ORE, block -> this.method_45981((class_2248)block, class_1802.field_8687));
        this.method_45994(HibiscusMiscBlocks.CHERT_DIAMOND_ORE, block -> this.method_45981((class_2248)block, class_1802.field_8477));
        this.method_45994(HibiscusMiscBlocks.CHERT_COPPER_ORE, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46010(arg_0));
        this.method_45994(HibiscusMiscBlocks.CHERT_REDSTONE_ORE, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46012(arg_0));
        this.method_45994(HibiscusMiscBlocks.CHERT_IRON_ORE, block -> this.method_45981((class_2248)block, class_1802.field_33400));
        this.method_45994(HibiscusMiscBlocks.CHERT_GOLD_ORE, block -> this.method_45981((class_2248)block, class_1802.field_33402));
        this.method_45994(HibiscusMiscBlocks.CHERT_LAPIS_ORE, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46011(arg_0));
        this.method_45994(HibiscusMiscBlocks.CATTAIL, block -> this.method_45987((class_2248)block, (class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607));
        this.method_45999(HibiscusMiscBlocks.LOTUS_STEM, HibiscusMiscBlocks.LOTUS_STEM);
        this.method_46006(HibiscusMiscBlocks.LOTUS_FLOWER, (class_1935)HibiscusMiscBlocks.LOTUS_FLOWER_ITEM);
        this.method_45994(HibiscusMiscBlocks.AZOLLA, this::flowerbedDropsWithShears);
        this.method_46025(HibiscusMiscBlocks.SHIITAKE_MUSHROOM);
        this.method_45988(HibiscusMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, this.method_45998(HibiscusMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, (class_1935)HibiscusMiscBlocks.SHIITAKE_MUSHROOM));
        this.method_46025(HibiscusMiscBlocks.GRAY_POLYPORE);
        this.method_45988(HibiscusMiscBlocks.GRAY_POLYPORE_BLOCK, this.method_45998(HibiscusMiscBlocks.GRAY_POLYPORE_BLOCK, (class_1935)HibiscusMiscBlocks.GRAY_POLYPORE));
        this.method_46025(HibiscusWoods.COCONUT_THATCH);
        this.method_46025(HibiscusWoods.COCONUT_THATCH_CARPET);
        this.method_46025(HibiscusWoods.COCONUT_THATCH_STAIRS);
        this.method_45994(HibiscusWoods.COCONUT_THATCH_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(HibiscusWoods.EVERGREEN_THATCH);
        this.method_46025(HibiscusWoods.EVERGREEN_THATCH_CARPET);
        this.method_46025(HibiscusWoods.EVERGREEN_THATCH_STAIRS);
        this.method_45994(HibiscusWoods.EVERGREEN_THATCH_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(HibiscusWoods.XERIC_THATCH);
        this.method_46025(HibiscusWoods.XERIC_THATCH_CARPET);
        this.method_46025(HibiscusWoods.XERIC_THATCH_STAIRS);
        this.method_45994(HibiscusWoods.XERIC_THATCH_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusMiscBlocks.PAPER_DOOR, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46022(arg_0));
        this.method_46025(HibiscusMiscBlocks.PAPER_TRAPDOOR);
        this.method_45994(HibiscusMiscBlocks.FRAMED_PAPER_DOOR, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46022(arg_0));
        this.method_46025(HibiscusMiscBlocks.FRAMED_PAPER_TRAPDOOR);
        this.method_45994(HibiscusMiscBlocks.BLOOMING_PAPER_DOOR, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46022(arg_0));
        this.method_46025(HibiscusMiscBlocks.BLOOMING_PAPER_TRAPDOOR);
        this.method_46025(HibiscusMiscBlocks.PAPER_BLOCK);
        this.method_46025(HibiscusMiscBlocks.BLOOMING_PAPER_BLOCK);
        this.method_46025(HibiscusMiscBlocks.FRAMED_PAPER_BLOCK);
        this.method_46025(HibiscusMiscBlocks.PAPER_SIGN);
        this.method_46025(HibiscusMiscBlocks.PAPER_HANGING_SIGN);
        this.method_46025(HibiscusMiscBlocks.PAPER_PANEL);
        this.method_46025(HibiscusMiscBlocks.BLOOMING_PAPER_PANEL);
        this.method_46025(HibiscusMiscBlocks.FRAMED_PAPER_PANEL);
        this.method_46025(HibiscusMiscBlocks.RED_MOSS_BLOCK);
        this.method_46025(HibiscusMiscBlocks.RED_MOSS_CARPET);
        this.method_46025(HibiscusMiscBlocks.SANDY_SOIL);
        this.method_46025(HibiscusMiscBlocks.ORNATE_SUCCULENT);
        this.method_46025(HibiscusMiscBlocks.DROWSY_SUCCULENT);
        this.method_46025(HibiscusMiscBlocks.AUREATE_SUCCULENT);
        this.method_46025(HibiscusMiscBlocks.SAGE_SUCCULENT);
        this.method_46025(HibiscusMiscBlocks.FOAMY_SUCCULENT);
        this.method_46025(HibiscusMiscBlocks.IMPERIAL_SUCCULENT);
        this.method_46025(HibiscusMiscBlocks.REGAL_SUCCULENT);
        this.method_46023(HibiscusMiscBlocks.POTTED_ORNATE_SUCCULENT);
        this.method_46023(HibiscusMiscBlocks.POTTED_DROWSY_SUCCULENT);
        this.method_46023(HibiscusMiscBlocks.POTTED_AUREATE_SUCCULENT);
        this.method_46023(HibiscusMiscBlocks.POTTED_SAGE_SUCCULENT);
        this.method_46023(HibiscusMiscBlocks.POTTED_FOAMY_SUCCULENT);
        this.method_46023(HibiscusMiscBlocks.POTTED_IMPERIAL_SUCCULENT);
        this.method_46023(HibiscusMiscBlocks.POTTED_REGAL_SUCCULENT);
        this.method_46025(HibiscusMiscBlocks.PINK_SAND);
        this.method_46025(HibiscusMiscBlocks.PINK_SANDSTONE);
        this.method_45994(HibiscusMiscBlocks.PINK_SANDSTONE_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(HibiscusMiscBlocks.PINK_SANDSTONE_STAIRS);
        this.method_46025(HibiscusMiscBlocks.PINK_SANDSTONE_WALL);
        this.method_46025(HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE);
        this.method_45994(HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS);
        this.method_46025(HibiscusMiscBlocks.CUT_PINK_SANDSTONE);
        this.method_45994(HibiscusMiscBlocks.CUT_PINK_SANDSTONE_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(HibiscusMiscBlocks.CHISELED_PINK_SANDSTONE);
        this.method_46025(HibiscusColoredBlocks.KAOLIN);
        this.method_46025(HibiscusColoredBlocks.WHITE_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.GRAY_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.BLACK_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.BROWN_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.RED_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.ORANGE_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.YELLOW_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.LIME_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.GREEN_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.CYAN_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.BLUE_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.PURPLE_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.MAGENTA_KAOLIN);
        this.method_46025(HibiscusColoredBlocks.PINK_KAOLIN);
        this.method_45994(HibiscusColoredBlocks.KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.WHITE_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.GRAY_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BLACK_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BROWN_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.RED_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.ORANGE_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.YELLOW_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIME_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.GREEN_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.CYAN_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BLUE_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.PURPLE_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.MAGENTA_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.PINK_KAOLIN_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(HibiscusColoredBlocks.KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.WHITE_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.GRAY_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BLACK_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BROWN_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.RED_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.ORANGE_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.YELLOW_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIME_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.GREEN_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.CYAN_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BLUE_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.PURPLE_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.MAGENTA_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.PINK_KAOLIN_STAIRS);
        this.method_46025(HibiscusColoredBlocks.KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.WHITE_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.GRAY_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.BLACK_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.BROWN_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.RED_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.ORANGE_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.YELLOW_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.LIME_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.GREEN_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.CYAN_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.BLUE_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.PURPLE_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.MAGENTA_KAOLIN_BRICKS);
        this.method_46025(HibiscusColoredBlocks.PINK_KAOLIN_BRICKS);
        this.method_45994(HibiscusColoredBlocks.KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.WHITE_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.GRAY_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BLACK_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BROWN_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.RED_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.ORANGE_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.YELLOW_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIME_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.GREEN_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.CYAN_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BLUE_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.PURPLE_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.MAGENTA_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.PINK_KAOLIN_BRICK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(HibiscusColoredBlocks.KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.WHITE_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.GRAY_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BLACK_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BROWN_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.RED_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.ORANGE_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.YELLOW_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIME_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.GREEN_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.CYAN_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BLUE_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.PURPLE_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.MAGENTA_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.PINK_KAOLIN_BRICK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.WHITE_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.LIGHT_GRAY_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.GRAY_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.BLACK_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.BROWN_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.RED_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.ORANGE_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.YELLOW_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.LIME_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.GREEN_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.CYAN_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.LIGHT_BLUE_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.BLUE_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.PURPLE_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.MAGENTA_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.PINK_PAPER_LANTERN);
        this.method_46025(HibiscusColoredBlocks.WHITE_CHALK);
        this.method_46025(HibiscusColoredBlocks.LIGHT_GRAY_CHALK);
        this.method_46025(HibiscusColoredBlocks.GRAY_CHALK);
        this.method_46025(HibiscusColoredBlocks.BLACK_CHALK);
        this.method_46025(HibiscusColoredBlocks.BROWN_CHALK);
        this.method_46025(HibiscusColoredBlocks.RED_CHALK);
        this.method_46025(HibiscusColoredBlocks.ORANGE_CHALK);
        this.method_46025(HibiscusColoredBlocks.YELLOW_CHALK);
        this.method_46025(HibiscusColoredBlocks.LIME_CHALK);
        this.method_46025(HibiscusColoredBlocks.GREEN_CHALK);
        this.method_46025(HibiscusColoredBlocks.CYAN_CHALK);
        this.method_46025(HibiscusColoredBlocks.LIGHT_BLUE_CHALK);
        this.method_46025(HibiscusColoredBlocks.BLUE_CHALK);
        this.method_46025(HibiscusColoredBlocks.PURPLE_CHALK);
        this.method_46025(HibiscusColoredBlocks.MAGENTA_CHALK);
        this.method_46025(HibiscusColoredBlocks.PINK_CHALK);
        this.method_45994(HibiscusColoredBlocks.WHITE_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIGHT_GRAY_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.GRAY_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BLACK_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BROWN_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.RED_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.ORANGE_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.YELLOW_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIME_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.GREEN_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.CYAN_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.LIGHT_BLUE_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.BLUE_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.PURPLE_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.MAGENTA_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(HibiscusColoredBlocks.PINK_CHALK_SLAB, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(HibiscusColoredBlocks.WHITE_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIGHT_GRAY_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.GRAY_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BLACK_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BROWN_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.RED_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.ORANGE_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.YELLOW_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIME_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.GREEN_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.CYAN_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.LIGHT_BLUE_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.BLUE_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.PURPLE_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.MAGENTA_CHALK_STAIRS);
        this.method_46025(HibiscusColoredBlocks.PINK_CHALK_STAIRS);
        this.method_46025(HibiscusMiscBlocks.DESERT_TURNIP_ROOT_BLOCK);
        this.method_46025(HibiscusWoods.COCONUT_SPROUT);
        this.method_46025(HibiscusWoods.COCONUT_BLOCK);
        this.method_46025(HibiscusWoods.YOUNG_COCONUT_BLOCK);
        this.method_45994(HibiscusMiscBlocks.FRIGID_GRASS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.SCORCHED_GRASS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.BEACH_GRASS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.SEDGE_GRASS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.FLAXEN_FERN, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.OAT_GRASS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.LUSH_FERN, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.MELIC_GRASS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.RED_BEARBERRIES, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.RED_BITTER_SPROUTS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.GREEN_BEARBERRIES, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.GREEN_BITTER_SPROUTS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.PURPLE_BEARBERRIES, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(HibiscusMiscBlocks.PURPLE_BITTER_SPROUTS, arg_0 -> ((NatureSpiritBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45988(HibiscusMiscBlocks.TALL_FRIGID_GRASS, this.method_45985(HibiscusMiscBlocks.TALL_FRIGID_GRASS, HibiscusMiscBlocks.FRIGID_GRASS));
        this.method_45988(HibiscusMiscBlocks.TALL_SCORCHED_GRASS, this.method_45985(HibiscusMiscBlocks.TALL_SCORCHED_GRASS, HibiscusMiscBlocks.SCORCHED_GRASS));
        this.method_45988(HibiscusMiscBlocks.TALL_BEACH_GRASS, this.method_45985(HibiscusMiscBlocks.TALL_BEACH_GRASS, HibiscusMiscBlocks.BEACH_GRASS));
        this.method_45988(HibiscusMiscBlocks.TALL_SEDGE_GRASS, this.method_45985(HibiscusMiscBlocks.TALL_SEDGE_GRASS, HibiscusMiscBlocks.SEDGE_GRASS));
        this.method_45988(HibiscusMiscBlocks.LARGE_FLAXEN_FERN, this.method_45985(HibiscusMiscBlocks.LARGE_FLAXEN_FERN, HibiscusMiscBlocks.FLAXEN_FERN));
        this.method_45988(HibiscusMiscBlocks.TALL_OAT_GRASS, this.method_45985(HibiscusMiscBlocks.TALL_OAT_GRASS, HibiscusMiscBlocks.OAT_GRASS));
        this.method_45988(HibiscusMiscBlocks.LARGE_LUSH_FERN, this.method_45985(HibiscusMiscBlocks.LARGE_LUSH_FERN, HibiscusMiscBlocks.LUSH_FERN));
        this.method_45988(HibiscusMiscBlocks.TALL_MELIC_GRASS, this.method_45985(HibiscusMiscBlocks.TALL_MELIC_GRASS, HibiscusMiscBlocks.MELIC_GRASS));
        this.method_46023(HibiscusMiscBlocks.POTTED_PURPLE_BEARBERRIES);
        this.method_46023(HibiscusMiscBlocks.POTTED_GREEN_BEARBERRIES);
        this.method_46023(HibiscusMiscBlocks.POTTED_RED_BEARBERRIES);
        this.method_46023(HibiscusMiscBlocks.POTTED_MELIC_GRASS);
        this.method_46023(HibiscusMiscBlocks.POTTED_OAT_GRASS);
        this.method_46023(HibiscusMiscBlocks.POTTED_LUSH_FERN);
        this.method_46023(HibiscusMiscBlocks.POTTED_FLAXEN_FERN);
        this.method_46023(HibiscusMiscBlocks.POTTED_SEDGE_GRASS);
        this.method_46023(HibiscusMiscBlocks.POTTED_SCORCHED_GRASS);
        this.method_46023(HibiscusMiscBlocks.POTTED_FRIGID_GRASS);
        this.method_46023(HibiscusMiscBlocks.POTTED_BEACH_GRASS);
    }
}

