/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.datagen;

import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.hibiscus.naturespirit.registration.FlowerSet;
import net.hibiscus.naturespirit.registration.HibiscusRegistryHelper;
import net.hibiscus.naturespirit.registration.StoneSet;
import net.hibiscus.naturespirit.registration.WoodSet;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusMiscBlocks;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusWoods;
import net.hibiscus.naturespirit.util.HibiscusTags;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_7225;

public class NatureSpiritBlockTagGenerator
extends FabricTagProvider.BlockTagProvider {
    public NatureSpiritBlockTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    private void addWoodTags(HashMap<String, WoodSet> woods) {
        for (WoodSet woodSet : woods.values()) {
            this.getOrCreateTagBuilder(class_3481.field_15471).add((Object[])new class_2248[]{woodSet.getPlanks()});
            this.getOrCreateTagBuilder(class_3481.field_15499).add((Object[])new class_2248[]{woodSet.getButton()});
            this.getOrCreateTagBuilder(class_3481.field_15494).add((Object[])new class_2248[]{woodSet.getDoor()});
            this.getOrCreateTagBuilder(class_3481.field_15502).add((Object[])new class_2248[]{woodSet.getStairs()});
            this.getOrCreateTagBuilder(class_3481.field_15468).add((Object[])new class_2248[]{woodSet.getSlab()});
            this.getOrCreateTagBuilder(class_3481.field_17619).add((Object[])new class_2248[]{woodSet.getFence()});
            this.getOrCreateTagBuilder(woodSet.getBlockLogsTag()).add((Object[])new class_2248[]{woodSet.getStrippedLog(), woodSet.getLog()});
            this.getOrCreateTagBuilder(HibiscusTags.Blocks.STRIPPED_LOGS).add((Object)woodSet.getStrippedLog());
            if (woodSet.hasBark()) {
                this.getOrCreateTagBuilder(woodSet.getBlockLogsTag()).add((Object[])new class_2248[]{woodSet.getStrippedWood(), woodSet.getWood()});
                this.getOrCreateTagBuilder(HibiscusTags.Blocks.STRIPPED_LOGS).add((Object)woodSet.getStrippedWood());
            }
            if (woodSet.hasMosaic()) {
                this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)woodSet.getMosaicSlab());
                this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)woodSet.getMosaicStairs());
                this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])new class_2248[]{woodSet.getMosaic(), woodSet.getMosaicSlab(), woodSet.getMosaicStairs()});
            }
            this.getOrCreateTagBuilder(class_3481.field_39030).add((Object[])new class_2248[]{woodSet.getLog()});
            this.getOrCreateTagBuilder(class_3481.field_23210).addTag(woodSet.getBlockLogsTag());
            this.getOrCreateTagBuilder(class_3481.field_15491).add((Object[])new class_2248[]{woodSet.getTrapDoor()});
            this.getOrCreateTagBuilder(class_3481.field_15472).add((Object[])new class_2248[]{woodSet.getSign()});
            this.getOrCreateTagBuilder(class_3481.field_15492).add((Object[])new class_2248[]{woodSet.getWallSign()});
            this.getOrCreateTagBuilder(class_3481.field_15477).add((Object[])new class_2248[]{woodSet.getPressurePlate()});
            this.getOrCreateTagBuilder(class_3481.field_25147).add((Object[])new class_2248[]{woodSet.getFenceGate()});
            this.getOrCreateTagBuilder(class_3481.field_40103).add((Object)woodSet.getHangingSign());
            this.getOrCreateTagBuilder(class_3481.field_40104).add((Object)woodSet.getHangingWallSign());
        }
    }

    private void addStoneTags(HashMap<String, StoneSet> stones) {
        for (StoneSet stoneSet : stones.values()) {
            this.getOrCreateTagBuilder(class_3481.field_33715).add((Object[])stoneSet.getRegisteredBlocksList().toArray(new class_2248[0]));
            if (stoneSet.hasTiles()) {
                this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getTilesSlab());
                this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getTilesStairs());
                this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getTilesWall());
            }
            if (stoneSet.hasCobbled()) {
                this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getCobbledSlab());
                this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getCobbledStairs());
                this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getCobbledWall());
                if (stoneSet.hasMossy()) {
                    this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getMossyCobbledSlab());
                    this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getMossyCobbledStairs());
                    this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getMossyCobbledWall());
                }
            }
            if (stoneSet.hasMossy()) {
                this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getMossyBricksSlab());
                this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getMossyBricksStairs());
                this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getMossyBricksWall());
            }
            this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getPolishedSlab());
            this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getPolishedStairs());
            this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getPolishedWall());
            this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getBricksSlab());
            this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getBricksStairs());
            this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getBricksWall());
            this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getBaseSlab());
            this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getBaseStairs());
        }
    }

    private void addTreeTags(HashMap<String, class_2248[]> saplings, HashMap<String, class_2248> leaves) {
        for (String i : leaves.keySet()) {
            class_2248 leavesType = leaves.get(i);
            this.getOrCreateTagBuilder(class_3481.field_33714).add((Object)leavesType);
            this.getOrCreateTagBuilder(class_3481.field_15503).add((Object)leavesType);
            if (Objects.equals(i, "wisteria") || Objects.equals(i, "coconut") || i.startsWith("part") || i.startsWith("frosty")) continue;
            class_2248[] saplingType = saplings.get(i);
            this.getOrCreateTagBuilder(class_3481.field_15462).add((Object[])new class_2248[]{saplingType[0]});
            this.getOrCreateTagBuilder(class_3481.field_15470).add((Object[])new class_2248[]{saplingType[1]});
        }
    }

    protected void method_10514(class_7225.class_7874 arg) {
        this.addWoodTags(HibiscusRegistryHelper.WoodHashMap);
        this.addStoneTags(HibiscusRegistryHelper.StoneHashMap);
        this.addTreeTags(HibiscusRegistryHelper.SaplingHashMap, HibiscusRegistryHelper.LeavesHashMap);
        for (FlowerSet flowerSet : HibiscusRegistryHelper.FlowerHashMap.values()) {
            if (flowerSet.isTall()) {
                this.getOrCreateTagBuilder(class_3481.field_20338).add((Object)flowerSet.getFlowerBlock());
                continue;
            }
            this.getOrCreateTagBuilder(class_3481.field_15470).add((Object)flowerSet.getPottedFlowerBlock());
            this.getOrCreateTagBuilder(class_3481.field_15480).add((Object)flowerSet.getFlowerBlock());
        }
        this.getOrCreateTagBuilder(class_3481.field_44471).add((Object)HibiscusMiscBlocks.AZOLLA);
        this.getOrCreateTagBuilder(class_3481.field_20338).add((Object)HibiscusMiscBlocks.CATTAIL);
        this.getOrCreateTagBuilder(class_3481.field_15480).add((Object)HibiscusMiscBlocks.LOTUS_FLOWER);
        this.getOrCreateTagBuilder(HibiscusTags.Blocks.ALLUAUDIA_BUNDLES).add((Object[])new class_2248[]{HibiscusMiscBlocks.STRIPPED_ALLUAUDIA_BUNDLE, HibiscusMiscBlocks.ALLUAUDIA_BUNDLE});
        this.getOrCreateTagBuilder(class_3481.field_23210).addTag(HibiscusTags.Blocks.ALLUAUDIA_BUNDLES);
        this.getOrCreateTagBuilder(class_3481.field_15494).add((Object[])new class_2248[]{HibiscusMiscBlocks.PAPER_DOOR, HibiscusMiscBlocks.FRAMED_PAPER_DOOR, HibiscusMiscBlocks.BLOOMING_PAPER_DOOR});
        this.getOrCreateTagBuilder(class_3481.field_15491).add((Object[])new class_2248[]{HibiscusMiscBlocks.PAPER_TRAPDOOR, HibiscusMiscBlocks.FRAMED_PAPER_TRAPDOOR, HibiscusMiscBlocks.BLOOMING_PAPER_TRAPDOOR});
        Object[] objectArray = new class_2248[10];
        objectArray[0] = HibiscusWoods.WISTERIA.getBlueWisteriaVines();
        objectArray[1] = HibiscusWoods.WISTERIA.getBlueWisteriaVinesPlant();
        objectArray[2] = HibiscusWoods.WISTERIA.getWhiteWisteriaVines();
        objectArray[3] = HibiscusWoods.WISTERIA.getWhiteWisteriaVinesPlant();
        objectArray[4] = HibiscusWoods.WISTERIA.getPinkWisteriaVines();
        objectArray[5] = HibiscusWoods.WISTERIA.getPinkWisteriaVinesPlant();
        objectArray[6] = HibiscusWoods.WISTERIA.getPurpleWisteriaVines();
        objectArray[7] = HibiscusWoods.WISTERIA.getPurpleWisteriaVinesPlant();
        objectArray[8] = HibiscusWoods.WILLOW.getWillowVinesPlant();
        objectArray[9] = HibiscusWoods.WILLOW.getWillowVines();
        this.getOrCreateTagBuilder(class_3481.field_22414).add(objectArray);
        this.getOrCreateTagBuilder(class_3481.field_20342).add((Object[])new class_2248[]{HibiscusWoods.WISTERIA.getBlueWisteriaVines(), HibiscusWoods.WISTERIA.getBlueWisteriaVinesPlant(), HibiscusWoods.WISTERIA.getWhiteWisteriaVines(), HibiscusWoods.WISTERIA.getWhiteWisteriaVinesPlant(), HibiscusWoods.WISTERIA.getPinkWisteriaVines(), HibiscusWoods.WISTERIA.getPinkWisteriaVinesPlant(), HibiscusWoods.WISTERIA.getPurpleWisteriaVines(), HibiscusWoods.WISTERIA.getPurpleWisteriaVinesPlant(), HibiscusMiscBlocks.LOTUS_FLOWER});
        this.getOrCreateTagBuilder(class_3481.field_20341).add((Object)HibiscusMiscBlocks.DESERT_TURNIP_STEM);
        this.getOrCreateTagBuilder(class_3481.field_44589).add((Object)HibiscusMiscBlocks.DESERT_TURNIP_STEM);
        this.getOrCreateTagBuilder(class_3481.field_33714).add((Object[])new class_2248[]{HibiscusMiscBlocks.SCORCHED_GRASS, HibiscusMiscBlocks.TALL_SCORCHED_GRASS, HibiscusMiscBlocks.BEACH_GRASS, HibiscusMiscBlocks.TALL_BEACH_GRASS, HibiscusMiscBlocks.SEDGE_GRASS, HibiscusMiscBlocks.TALL_SEDGE_GRASS, HibiscusMiscBlocks.LARGE_FLAXEN_FERN, HibiscusMiscBlocks.FLAXEN_FERN, HibiscusMiscBlocks.LARGE_LUSH_FERN, HibiscusMiscBlocks.LUSH_FERN, HibiscusMiscBlocks.TALL_MELIC_GRASS, HibiscusMiscBlocks.MELIC_GRASS, HibiscusMiscBlocks.FRIGID_GRASS, HibiscusMiscBlocks.TALL_FRIGID_GRASS, HibiscusMiscBlocks.OAT_GRASS, HibiscusMiscBlocks.TALL_OAT_GRASS, HibiscusMiscBlocks.RED_BEARBERRIES, HibiscusMiscBlocks.GREEN_BEARBERRIES, HibiscusMiscBlocks.PURPLE_BEARBERRIES, HibiscusMiscBlocks.RED_BITTER_SPROUTS, HibiscusMiscBlocks.PURPLE_BITTER_SPROUTS, HibiscusMiscBlocks.GREEN_BITTER_SPROUTS, HibiscusWoods.COCONUT_THATCH, HibiscusWoods.COCONUT_THATCH_STAIRS, HibiscusWoods.COCONUT_THATCH_CARPET, HibiscusWoods.COCONUT_THATCH_SLAB, HibiscusWoods.EVERGREEN_THATCH, HibiscusWoods.EVERGREEN_THATCH_STAIRS, HibiscusWoods.EVERGREEN_THATCH_CARPET, HibiscusWoods.EVERGREEN_THATCH_SLAB, HibiscusWoods.XERIC_THATCH, HibiscusWoods.XERIC_THATCH_STAIRS, HibiscusWoods.XERIC_THATCH_CARPET, HibiscusWoods.XERIC_THATCH_SLAB, HibiscusMiscBlocks.RED_MOSS_BLOCK, HibiscusMiscBlocks.RED_MOSS_CARPET, HibiscusMiscBlocks.ORNATE_SUCCULENT, HibiscusMiscBlocks.AUREATE_SUCCULENT, HibiscusMiscBlocks.SAGE_SUCCULENT, HibiscusMiscBlocks.FOAMY_SUCCULENT, HibiscusMiscBlocks.IMPERIAL_SUCCULENT, HibiscusMiscBlocks.REGAL_SUCCULENT});
        this.getOrCreateTagBuilder(class_3481.field_44469).add((Object[])new class_2248[]{HibiscusMiscBlocks.SCORCHED_GRASS, HibiscusMiscBlocks.TALL_SCORCHED_GRASS, HibiscusMiscBlocks.BEACH_GRASS, HibiscusMiscBlocks.TALL_BEACH_GRASS, HibiscusMiscBlocks.SEDGE_GRASS, HibiscusMiscBlocks.TALL_SEDGE_GRASS, HibiscusMiscBlocks.LARGE_FLAXEN_FERN, HibiscusMiscBlocks.FLAXEN_FERN, HibiscusMiscBlocks.SHIITAKE_MUSHROOM, HibiscusMiscBlocks.GRAY_POLYPORE, HibiscusMiscBlocks.FRIGID_GRASS, HibiscusMiscBlocks.TALL_FRIGID_GRASS, HibiscusMiscBlocks.OAT_GRASS, HibiscusMiscBlocks.TALL_OAT_GRASS, HibiscusMiscBlocks.LARGE_LUSH_FERN, HibiscusMiscBlocks.LUSH_FERN, HibiscusMiscBlocks.TALL_MELIC_GRASS, HibiscusMiscBlocks.MELIC_GRASS, HibiscusMiscBlocks.RED_BEARBERRIES, HibiscusMiscBlocks.GREEN_BEARBERRIES, HibiscusMiscBlocks.PURPLE_BEARBERRIES, HibiscusMiscBlocks.RED_BITTER_SPROUTS, HibiscusMiscBlocks.PURPLE_BITTER_SPROUTS, HibiscusMiscBlocks.GREEN_BITTER_SPROUTS});
        this.getOrCreateTagBuilder(class_3481.field_44470).add((Object[])new class_2248[]{HibiscusMiscBlocks.SCORCHED_GRASS, HibiscusMiscBlocks.TALL_SCORCHED_GRASS, HibiscusMiscBlocks.BEACH_GRASS, HibiscusMiscBlocks.TALL_BEACH_GRASS, HibiscusMiscBlocks.SEDGE_GRASS, HibiscusMiscBlocks.TALL_SEDGE_GRASS, HibiscusMiscBlocks.LARGE_FLAXEN_FERN, HibiscusMiscBlocks.FLAXEN_FERN, HibiscusMiscBlocks.FRIGID_GRASS, HibiscusMiscBlocks.TALL_FRIGID_GRASS, HibiscusMiscBlocks.OAT_GRASS, HibiscusMiscBlocks.TALL_OAT_GRASS, HibiscusMiscBlocks.LARGE_LUSH_FERN, HibiscusMiscBlocks.LUSH_FERN, HibiscusMiscBlocks.TALL_MELIC_GRASS, HibiscusMiscBlocks.MELIC_GRASS, HibiscusMiscBlocks.AUREATE_SUCCULENT, HibiscusMiscBlocks.SAGE_SUCCULENT, HibiscusMiscBlocks.FOAMY_SUCCULENT, HibiscusMiscBlocks.IMPERIAL_SUCCULENT, HibiscusMiscBlocks.REGAL_SUCCULENT});
        this.getOrCreateTagBuilder(class_3481.field_15466).add((Object[])new class_2248[]{HibiscusMiscBlocks.PINK_SAND, HibiscusMiscBlocks.SANDY_SOIL});
        this.getOrCreateTagBuilder(class_3481.field_42968).add((Object)HibiscusMiscBlocks.PINK_SAND);
        this.getOrCreateTagBuilder(class_3481.field_33716).add((Object[])new class_2248[]{HibiscusMiscBlocks.PINK_SAND, HibiscusMiscBlocks.SANDY_SOIL});
        this.getOrCreateTagBuilder(class_3481.field_33715).forceAddTag(HibiscusTags.Blocks.KAOLIN).forceAddTag(HibiscusTags.Blocks.KAOLIN_STAIRS).forceAddTag(HibiscusTags.Blocks.KAOLIN_SLABS).forceAddTag(HibiscusTags.Blocks.KAOLIN_BRICKS).forceAddTag(HibiscusTags.Blocks.KAOLIN_BRICK_STAIRS).forceAddTag(HibiscusTags.Blocks.KAOLIN_BRICK_SLABS).forceAddTag(HibiscusTags.Blocks.CHALK).forceAddTag(HibiscusTags.Blocks.CHALK_STAIRS).forceAddTag(HibiscusTags.Blocks.CHALK_SLABS).add((Object[])new class_2248[]{HibiscusMiscBlocks.CHERT_COAL_ORE, HibiscusMiscBlocks.CHERT_COPPER_ORE, HibiscusMiscBlocks.CHERT_DIAMOND_ORE, HibiscusMiscBlocks.CHERT_GOLD_ORE, HibiscusMiscBlocks.CHERT_EMERALD_ORE, HibiscusMiscBlocks.CHERT_IRON_ORE, HibiscusMiscBlocks.CHERT_LAPIS_ORE, HibiscusMiscBlocks.CHERT_REDSTONE_ORE, HibiscusMiscBlocks.PINK_SANDSTONE, HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE, HibiscusMiscBlocks.CUT_PINK_SANDSTONE, HibiscusMiscBlocks.PINK_SANDSTONE_STAIRS, HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS, HibiscusMiscBlocks.PINK_SANDSTONE_SLAB, HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, HibiscusMiscBlocks.CUT_PINK_SANDSTONE_SLAB, HibiscusMiscBlocks.PINK_SANDSTONE_WALL, HibiscusMiscBlocks.CHISELED_PINK_SANDSTONE});
        this.getOrCreateTagBuilder(class_3481.field_15459).add((Object[])new class_2248[]{HibiscusMiscBlocks.PINK_SANDSTONE_STAIRS, HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS, HibiscusWoods.EVERGREEN_THATCH_STAIRS, HibiscusWoods.COCONUT_THATCH_STAIRS});
        this.getOrCreateTagBuilder(class_3481.field_15469).add((Object[])new class_2248[]{HibiscusMiscBlocks.PINK_SANDSTONE_SLAB, HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, HibiscusMiscBlocks.CUT_PINK_SANDSTONE_SLAB, HibiscusWoods.EVERGREEN_THATCH_SLAB, HibiscusWoods.COCONUT_THATCH_SLAB});
        this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)HibiscusMiscBlocks.PINK_SANDSTONE_WALL);
        this.getOrCreateTagBuilder(class_3481.field_26985).add((Object[])new class_2248[]{HibiscusMiscBlocks.CHEESE_CAULDRON, HibiscusMiscBlocks.MILK_CAULDRON});
        this.getOrCreateTagBuilder(class_3481.field_15470).add((Object[])new class_2248[]{HibiscusMiscBlocks.POTTED_MELIC_GRASS, HibiscusMiscBlocks.POTTED_FLAXEN_FERN, HibiscusMiscBlocks.POTTED_FRIGID_GRASS, HibiscusMiscBlocks.POTTED_SHIITAKE_MUSHROOM, HibiscusMiscBlocks.POTTED_BEACH_GRASS, HibiscusMiscBlocks.POTTED_SEDGE_GRASS, HibiscusMiscBlocks.POTTED_SCORCHED_GRASS, HibiscusMiscBlocks.POTTED_OAT_GRASS, HibiscusMiscBlocks.POTTED_LUSH_FERN, HibiscusMiscBlocks.POTTED_ORNATE_SUCCULENT, HibiscusMiscBlocks.POTTED_DROWSY_SUCCULENT, HibiscusMiscBlocks.POTTED_AUREATE_SUCCULENT, HibiscusMiscBlocks.POTTED_SAGE_SUCCULENT, HibiscusMiscBlocks.POTTED_FOAMY_SUCCULENT, HibiscusMiscBlocks.POTTED_IMPERIAL_SUCCULENT});
        this.getOrCreateTagBuilder(class_3481.field_15460).add((Object)HibiscusMiscBlocks.SHIITAKE_MUSHROOM);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])new class_2248[]{HibiscusMiscBlocks.SHIITAKE_MUSHROOM, HibiscusMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, HibiscusMiscBlocks.GRAY_POLYPORE, HibiscusMiscBlocks.GRAY_POLYPORE_BLOCK, HibiscusMiscBlocks.DESERT_TURNIP_BLOCK, HibiscusMiscBlocks.DESERT_TURNIP_ROOT_BLOCK, HibiscusMiscBlocks.DESERT_TURNIP_STEM, HibiscusMiscBlocks.PAPER_BLOCK, HibiscusMiscBlocks.PAPER_PANEL, HibiscusMiscBlocks.PAPER_DOOR, HibiscusMiscBlocks.PAPER_SIGN, HibiscusMiscBlocks.PAPER_WALL_SIGN, HibiscusMiscBlocks.PAPER_HANGING_SIGN, HibiscusMiscBlocks.PAPER_WALL_HANGING_SIGN, HibiscusMiscBlocks.FRAMED_PAPER_BLOCK, HibiscusMiscBlocks.FRAMED_PAPER_PANEL, HibiscusMiscBlocks.FRAMED_PAPER_DOOR, HibiscusMiscBlocks.FRAMED_PAPER_TRAPDOOR, HibiscusMiscBlocks.BLOOMING_PAPER_BLOCK, HibiscusMiscBlocks.BLOOMING_PAPER_DOOR, HibiscusMiscBlocks.BLOOMING_PAPER_TRAPDOOR, HibiscusMiscBlocks.BLOOMING_PAPER_PANEL});
        this.getOrCreateTagBuilder(class_3481.field_40103).add((Object)HibiscusMiscBlocks.PAPER_HANGING_SIGN);
        this.getOrCreateTagBuilder(class_3481.field_40104).add((Object)HibiscusMiscBlocks.PAPER_WALL_HANGING_SIGN);
        this.getOrCreateTagBuilder(class_3481.field_15472).add((Object[])new class_2248[]{HibiscusMiscBlocks.PAPER_SIGN});
        this.getOrCreateTagBuilder(class_3481.field_15492).add((Object[])new class_2248[]{HibiscusMiscBlocks.PAPER_WALL_SIGN});
        this.getOrCreateTagBuilder(class_3481.field_29193).add((Object)HibiscusMiscBlocks.CHERT_COAL_ORE);
        this.getOrCreateTagBuilder(class_3481.field_29195).add((Object)HibiscusMiscBlocks.CHERT_COPPER_ORE);
        this.getOrCreateTagBuilder(class_3481.field_28989).add((Object)HibiscusMiscBlocks.CHERT_DIAMOND_ORE);
        this.getOrCreateTagBuilder(class_3481.field_23062).add((Object)HibiscusMiscBlocks.CHERT_GOLD_ORE);
        this.getOrCreateTagBuilder(class_3481.field_29194).add((Object)HibiscusMiscBlocks.CHERT_EMERALD_ORE);
        this.getOrCreateTagBuilder(class_3481.field_28988).add((Object)HibiscusMiscBlocks.CHERT_IRON_ORE);
        this.getOrCreateTagBuilder(class_3481.field_28991).add((Object)HibiscusMiscBlocks.CHERT_LAPIS_ORE);
        this.getOrCreateTagBuilder(class_3481.field_28990).add((Object)HibiscusMiscBlocks.CHERT_REDSTONE_ORE);
        this.getOrCreateTagBuilder(class_3481.field_33718).add((Object[])new class_2248[]{HibiscusMiscBlocks.CHERT_EMERALD_ORE, HibiscusMiscBlocks.CHERT_DIAMOND_ORE, HibiscusMiscBlocks.CHERT_GOLD_ORE, HibiscusMiscBlocks.CHERT_REDSTONE_ORE});
        this.getOrCreateTagBuilder(class_3481.field_33719).add((Object[])new class_2248[]{HibiscusMiscBlocks.CHERT_COPPER_ORE, HibiscusMiscBlocks.CHERT_IRON_ORE, HibiscusMiscBlocks.CHERT_LAPIS_ORE});
        this.getOrCreateTagBuilder(class_3481.field_28992).add((Object)HibiscusMiscBlocks.TRAVERTINE.getBase());
        this.getOrCreateTagBuilder(class_3481.field_25806).add((Object)HibiscusMiscBlocks.TRAVERTINE.getBase());
        this.getOrCreateTagBuilder(class_3481.field_25806).add((Object)HibiscusMiscBlocks.CHERT.getBase());
        this.getOrCreateTagBuilder(class_3481.field_15459).forceAddTag(HibiscusTags.Blocks.CHALK_STAIRS).forceAddTag(HibiscusTags.Blocks.KAOLIN_STAIRS).forceAddTag(HibiscusTags.Blocks.KAOLIN_BRICK_STAIRS).add((Object[])new class_2248[]{HibiscusMiscBlocks.PINK_SANDSTONE_STAIRS, HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS});
        this.getOrCreateTagBuilder(class_3481.field_15469).forceAddTag(HibiscusTags.Blocks.CHALK_SLABS).forceAddTag(HibiscusTags.Blocks.KAOLIN_SLABS).forceAddTag(HibiscusTags.Blocks.KAOLIN_SLABS).add((Object[])new class_2248[]{HibiscusMiscBlocks.PINK_SANDSTONE_SLAB, HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, HibiscusMiscBlocks.CUT_PINK_SANDSTONE_SLAB});
        this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)HibiscusMiscBlocks.PINK_SANDSTONE_WALL);
    }
}

