/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.datagen;

import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalEntityTypeTags;
import net.hibiscus.naturespirit.datagen.HibiscusConfiguredFeatures;
import net.hibiscus.naturespirit.datagen.HibiscusPlacedFeatures;
import net.hibiscus.naturespirit.datagen.NatureSpiritBlockLootTableProvider;
import net.hibiscus.naturespirit.datagen.NatureSpiritBlockTagGenerator;
import net.hibiscus.naturespirit.datagen.NatureSpiritItemTagGenerator;
import net.hibiscus.naturespirit.datagen.NatureSpiritLangGenerator;
import net.hibiscus.naturespirit.datagen.NatureSpiritModelGenerator;
import net.hibiscus.naturespirit.datagen.NatureSpiritRecipeGenerator;
import net.hibiscus.naturespirit.datagen.NatureSpiritWorldGenerator;
import net.hibiscus.naturespirit.registration.HibiscusRegistryHelper;
import net.hibiscus.naturespirit.registration.WoodSet;
import net.minecraft.class_1299;
import net.minecraft.class_7225;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class NatureSpiritDataGen
implements DataGeneratorEntrypoint {
    public static final String[] DYE_COLORS = new String[]{"white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink"};

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(NatureSpiritWorldGenerator::new);
        pack.addProvider(NatureSpiritModelGenerator::new);
        pack.addProvider(NatureSpiritLangGenerator::new);
        pack.addProvider(NatureSpiritRecipeGenerator::new);
        pack.addProvider(NatureSpiritBlockLootTableProvider::new);
        NatureSpiritBlockTagGenerator blockTagProvider = (NatureSpiritBlockTagGenerator)pack.addProvider(NatureSpiritBlockTagGenerator::new);
        pack.addProvider((output, registries) -> new NatureSpiritItemTagGenerator(output, registries, blockTagProvider));
        pack.addProvider(NatureSpiritEntityTypeGenerator::new);
        System.out.println("Initialized Data Generator");
    }

    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, HibiscusConfiguredFeatures::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, HibiscusPlacedFeatures::bootstrap);
        System.out.println("Built Registry");
    }

    public String getEffectiveModId() {
        return "natures_spirit";
    }

    public static class NatureSpiritEntityTypeGenerator
    extends FabricTagProvider.EntityTypeTagProvider {
        public NatureSpiritEntityTypeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
            super(output, completableFuture);
        }

        protected void method_10514(class_7225.class_7874 arg) {
            for (WoodSet woodSet : HibiscusRegistryHelper.WoodHashMap.values()) {
                this.getOrCreateTagBuilder(ConventionalEntityTypeTags.BOATS).add((Object[])new class_1299[]{woodSet.getBoatEntityType(), woodSet.getChestBoatEntityType()});
            }
        }
    }
}

