/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.datagen;

import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.hibiscus.naturespirit.datagen.NatureSpiritDataGen;
import net.hibiscus.naturespirit.registration.FlowerSet;
import net.hibiscus.naturespirit.registration.HibiscusItemGroups;
import net.hibiscus.naturespirit.registration.HibiscusRegistryHelper;
import net.hibiscus.naturespirit.registration.StoneSet;
import net.hibiscus.naturespirit.registration.WoodSet;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusColoredBlocks;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusMiscBlocks;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusWoods;
import net.hibiscus.naturespirit.world.HibiscusBiomes;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

class NatureSpiritLangGenerator
extends FabricLanguageProvider {
    protected NatureSpiritLangGenerator(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    public static String capitalizeString(String string) {
        char[] chars = string.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '.' && chars[i] != '\'') continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    private void generateBlockTranslations(class_2248 block, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        String temp = NatureSpiritLangGenerator.capitalizeString(class_7923.field_41175.method_10221((Object)block).method_12832().replace("_", " "));
        translationBuilder.add(block, temp);
    }

    private void generateItemTranslations(class_1792 item, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        String temp = NatureSpiritLangGenerator.capitalizeString(class_7923.field_41178.method_10221((Object)item).method_12832().replace("_", " "));
        translationBuilder.add(item, temp);
    }

    private void generateWoodTranslations(HashMap<String, WoodSet> woods, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (WoodSet woodSet : woods.values()) {
            for (class_2248 block : woodSet.getRegisteredBlocksList()) {
                this.generateBlockTranslations(block, translationBuilder);
            }
            this.generateBlockTranslations(woodSet.getSign(), translationBuilder);
            this.generateBlockTranslations(woodSet.getHangingSign(), translationBuilder);
            translationBuilder.add(woodSet.getBoatItem(), NatureSpiritLangGenerator.capitalizeString(woodSet.getName().replace("_", " ")) + " Boat");
            translationBuilder.add(woodSet.getChestBoatItem(), NatureSpiritLangGenerator.capitalizeString(woodSet.getName().replace("_", " ")) + " Boat with Chest");
            translationBuilder.add(woodSet.getChestBoatEntityType(), "Boat with Chest");
            translationBuilder.add(woodSet.getBoatEntityType(), "Boat");
            this.generateArchExTranslations(woodSet.getName(), translationBuilder);
        }
    }

    private void generateStoneTranslations(HashMap<String, StoneSet> stones, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (StoneSet stoneSet : stones.values()) {
            for (class_2248 block : stoneSet.getRegisteredBlocksList()) {
                this.generateBlockTranslations(block, translationBuilder);
            }
        }
    }

    private void generateFlowerTranslations(HashMap<String, FlowerSet> flowers, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (FlowerSet flowerSet : flowers.values()) {
            for (class_2248 block : flowerSet.getRegisteredBlocksList()) {
                this.generateBlockTranslations(block, translationBuilder);
            }
        }
    }

    private void generateBiomeTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (String name : HibiscusBiomes.BiomesHashMap.keySet()) {
            class_5321<class_1959> biome = HibiscusBiomes.BiomesHashMap.get(name);
            translationBuilder.add(biome.toString().replace("ResourceKey[minecraft:worldgen/biome / natures_spirit:", "biome.natures_spirit.").replace("]", ""), NatureSpiritLangGenerator.capitalizeString(name.replace("_", " ")));
        }
    }

    private void generateArchExTranslations(String group, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add("architecture_extensions.grouped_block.natures_spirit." + group, NatureSpiritLangGenerator.capitalizeString(group.replace("_", " ")));
    }

    private void generateColoredTranslations(String group, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add("block.natures_spirit." + group, NatureSpiritLangGenerator.capitalizeString(group.replace("_", " ")));
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.generateBiomeTranslations(translationBuilder);
        this.generateWoodTranslations(HibiscusRegistryHelper.WoodHashMap, translationBuilder);
        this.generateStoneTranslations(HibiscusRegistryHelper.StoneHashMap, translationBuilder);
        this.generateFlowerTranslations(HibiscusRegistryHelper.FlowerHashMap, translationBuilder);
        translationBuilder.add(HibiscusItemGroups.NS_ITEM_GROUP, "Nature's Spirit");
        translationBuilder.add("stat.minecraft.eat_pizza_slice", "Pizza Slices Eaten");
        translationBuilder.add("advancements.adventure.kaolin_kill.description", "Kill a Zombie with a Kaolin block");
        translationBuilder.add("advancements.adventure.kaolin_kill.title", "You're Kaolin This!");
        translationBuilder.add("advancements.adventure.shoot_coconut.description", "Hit a Coconut with a projectile");
        translationBuilder.add("advancements.adventure.shoot_coconut.title", "Tropical Blast!");
        translationBuilder.add("advancements.adventure.collect_all_flowers.description", "Collect all flowers.");
        translationBuilder.add("advancements.adventure.collect_all_flowers.title", "Flower Power");
        translationBuilder.add("advancements.adventure.sandy_forage.description", "Follow the Roots of a Turnip to a Turnip block");
        translationBuilder.add("advancements.adventure.sandy_forage.title", "Sandy Forage");
        translationBuilder.add(HibiscusMiscBlocks.CHALK_POWDER, "Chalk Powder");
        translationBuilder.add(HibiscusMiscBlocks.GREEN_OLIVES, "Green Olives");
        translationBuilder.add(HibiscusMiscBlocks.BLACK_OLIVES, "Black Olives");
        translationBuilder.add(HibiscusMiscBlocks.DESERT_TURNIP, "Desert Turnip");
        translationBuilder.add(HibiscusMiscBlocks.CALCITE_SHARD, "Calcite Shard");
        translationBuilder.add(HibiscusMiscBlocks.SMALL_CALCITE_BUD, "Small Calcite Bud");
        translationBuilder.add(HibiscusMiscBlocks.LARGE_CALCITE_BUD, "Large Calcite Bud");
        translationBuilder.add(HibiscusMiscBlocks.CALCITE_CLUSTER, "Calcite Cluster");
        this.generateBlockTranslations(HibiscusMiscBlocks.TALL_SCORCHED_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PURPLE_BEARBERRIES, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.RED_BEARBERRIES, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.GREEN_BEARBERRIES, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.RED_BITTER_SPROUTS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PURPLE_BITTER_SPROUTS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.GREEN_BITTER_SPROUTS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SCORCHED_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.TALL_BEACH_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.BEACH_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.TALL_SEDGE_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SEDGE_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.TALL_FRIGID_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.FRIGID_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.LARGE_FLAXEN_FERN, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.FLAXEN_FERN, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.TALL_OAT_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.OAT_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.LARGE_LUSH_FERN, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.LUSH_FERN, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.TALL_MELIC_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.MELIC_GRASS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SHIITAKE_MUSHROOM, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.GRAY_POLYPORE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.GRAY_POLYPORE_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PAPER_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.FRAMED_PAPER_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.BLOOMING_PAPER_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PAPER_DOOR, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.FRAMED_PAPER_DOOR, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.BLOOMING_PAPER_DOOR, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PAPER_TRAPDOOR, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.BLOOMING_PAPER_TRAPDOOR, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.FRAMED_PAPER_TRAPDOOR, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PAPER_SIGN, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PAPER_HANGING_SIGN, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PAPER_PANEL, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.FRAMED_PAPER_PANEL, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.BLOOMING_PAPER_PANEL, translationBuilder);
        this.generateBlockTranslations(HibiscusColoredBlocks.PAPER_LANTERN, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CATTAIL, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.DESERT_TURNIP_ROOT_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.DESERT_TURNIP_BLOCK, translationBuilder);
        translationBuilder.add(HibiscusMiscBlocks.HELVOLA_PAD_ITEM, "Helvola Pad");
        this.generateItemTranslations(HibiscusMiscBlocks.HELVOLA_FLOWER_ITEM, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.LOTUS_FLOWER, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.LOTUS_STEM, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.AZOLLA, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.RED_MOSS_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.RED_MOSS_CARPET, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.ALLUAUDIA, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.ALLUAUDIA_BUNDLE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.STRIPPED_ALLUAUDIA, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.STRIPPED_ALLUAUDIA_BUNDLE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHERT_COAL_ORE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHERT_COPPER_ORE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHERT_DIAMOND_ORE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHERT_GOLD_ORE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHERT_EMERALD_ORE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHERT_IRON_ORE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHERT_LAPIS_ORE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHERT_REDSTONE_ORE, translationBuilder);
        this.generateBlockTranslations(HibiscusColoredBlocks.KAOLIN, translationBuilder);
        this.generateBlockTranslations(HibiscusColoredBlocks.KAOLIN_BRICKS, translationBuilder);
        this.generateBlockTranslations(HibiscusColoredBlocks.KAOLIN_SLAB, translationBuilder);
        this.generateBlockTranslations(HibiscusColoredBlocks.KAOLIN_BRICK_SLAB, translationBuilder);
        this.generateBlockTranslations(HibiscusColoredBlocks.KAOLIN_STAIRS, translationBuilder);
        this.generateBlockTranslations(HibiscusColoredBlocks.KAOLIN_BRICK_STAIRS, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.COCONUT_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.YOUNG_COCONUT_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.COCONUT_SPROUT, translationBuilder);
        this.generateItemTranslations(HibiscusWoods.COCONUT_SHELL, translationBuilder);
        this.generateItemTranslations(HibiscusWoods.YOUNG_COCONUT_SHELL, translationBuilder);
        this.generateItemTranslations(HibiscusWoods.COCONUT_HALF, translationBuilder);
        this.generateItemTranslations(HibiscusWoods.YOUNG_COCONUT_HALF, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.COCONUT_THATCH, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.COCONUT_THATCH_SLAB, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.COCONUT_THATCH_STAIRS, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.COCONUT_THATCH_CARPET, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.EVERGREEN_THATCH, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.EVERGREEN_THATCH_SLAB, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.EVERGREEN_THATCH_STAIRS, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.EVERGREEN_THATCH_CARPET, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.XERIC_THATCH, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.XERIC_THATCH_SLAB, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.XERIC_THATCH_STAIRS, translationBuilder);
        this.generateBlockTranslations(HibiscusWoods.XERIC_THATCH_CARPET, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.ORNATE_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.DROWSY_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.AUREATE_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SAGE_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.FOAMY_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.IMPERIAL_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.REGAL_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PINK_SAND, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PINK_SANDSTONE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PINK_SANDSTONE_SLAB, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PINK_SANDSTONE_STAIRS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.PINK_SANDSTONE_WALL, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHISELED_PINK_SANDSTONE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CUT_PINK_SANDSTONE, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CUT_PINK_SANDSTONE_SLAB, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.SANDY_SOIL, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHEESE_BLOCK, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.CHEESE_CAULDRON, translationBuilder);
        this.generateBlockTranslations(HibiscusMiscBlocks.MILK_CAULDRON, translationBuilder);
        translationBuilder.add(HibiscusMiscBlocks.CHEESE_BUCKET, "Cheese Bucket");
        translationBuilder.add(HibiscusMiscBlocks.CHEESE_ARROW, "Cheese Arrow");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.cooked_chicken", "With Cooked Chicken");
        translationBuilder.add("block.natures_spirit.pizza.natures_spirit.green_olives", "With Green Olives");
        translationBuilder.add("block.natures_spirit.pizza.natures_spirit.black_olives", "With Black Olives");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.brown_mushroom", "With Mushrooms");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.beetroot", "With Beetroots");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.carrot", "With Carrots");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.cooked_cod", "With Cooked Cod");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.cooked_porkchop", "With Cooked Porkchop");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.cooked_rabbit", "With Cooked Rabbit");
        translationBuilder.add(HibiscusMiscBlocks.HALF_PIZZA, "Half of a Pizza");
        translationBuilder.add(HibiscusMiscBlocks.THREE_QUARTERS_PIZZA, "Three Quarters of a Pizza");
        translationBuilder.add(HibiscusMiscBlocks.QUARTER_PIZZA, "Quarter of a Pizza");
        translationBuilder.add(HibiscusMiscBlocks.WHOLE_PIZZA, "Pizza");
        translationBuilder.add("pack.natures_spirit.bushy_leaves_compatibility", "Bushy Leaves Compat");
        translationBuilder.add("pack.natures_spirit.plank_consistency", "Plank Consistency");
        translationBuilder.add("pack.natures_spirit.emissive_ores_compatibility", "Emissive Ores Compat");
        translationBuilder.add("pack.natures_spirit.modified_swamp", "Modified Swamp");
        translationBuilder.add("pack.natures_spirit.modified_desert", "Modified Desert");
        translationBuilder.add("pack.natures_spirit.modified_birch_forest", "Modified Birch Forest");
        translationBuilder.add("pack.natures_spirit.modified_badlands", "Modified Badlands");
        translationBuilder.add("pack.natures_spirit.modified_savannas", "Modified Savannas");
        translationBuilder.add("pack.natures_spirit.modified_dark_forest", "Modified Dark Forests");
        translationBuilder.add("pack.natures_spirit.modified_mountain_biomes", "Modified Mountain Biomes");
        translationBuilder.add("pack.natures_spirit.modified_vanilla_trees", "Modified Vanilla Trees");
        translationBuilder.add("pack.natures_spirit.modified_jungle", "Modified Jungles");
        translationBuilder.add("pack.natures_spirit.modified_windswept_hills", "Modified Windswept Hills");
        translationBuilder.add("pack.natures_spirit.dye_depot_compatibility", "Dye Depot Compatibility");
        translationBuilder.add("pack.natures_spirit.mint_compatibility", "El's and L's Dyes Compatibility");
        this.generateArchExTranslations("kaolin", translationBuilder);
        this.generateArchExTranslations("kaolin_bricks", translationBuilder);
        for (String color : List.of(NatureSpiritDataGen.DYE_COLORS)) {
            this.generateArchExTranslations(color + "_kaolin", translationBuilder);
            this.generateArchExTranslations(color + "_kaolin_bricks", translationBuilder);
            this.generateArchExTranslations(color + "_chalk", translationBuilder);
            this.generateColoredTranslations(color + "_paper_lantern", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_bricks", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_slab", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_brick_slab", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_stairs", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_brick_stairs", translationBuilder);
            this.generateColoredTranslations(color + "_chalk", translationBuilder);
            this.generateColoredTranslations(color + "_chalk_slab", translationBuilder);
            this.generateColoredTranslations(color + "_chalk_stairs", translationBuilder);
        }
        this.generateArchExTranslations("pink_sandstone", translationBuilder);
        this.generateArchExTranslations("smooth_pink_sandstone", translationBuilder);
        this.generateArchExTranslations("travertine", translationBuilder);
        this.generateArchExTranslations("travertine_bricks", translationBuilder);
        this.generateArchExTranslations("travertine_tiles", translationBuilder);
        this.generateArchExTranslations("cobbled_travertine", translationBuilder);
        this.generateArchExTranslations("mossy_cobbled_travertine", translationBuilder);
        this.generateArchExTranslations("mossy_travertine_bricks", translationBuilder);
    }
}

