/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.datagen;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.hibiscus.naturespirit.blocks.DesertPlantBlock;
import net.hibiscus.naturespirit.entity.HibiscusBoatEntity;
import net.hibiscus.naturespirit.registration.FlowerSet;
import net.hibiscus.naturespirit.registration.HibiscusRegistryHelper;
import net.hibiscus.naturespirit.registration.StoneSet;
import net.hibiscus.naturespirit.registration.WoodSet;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusColoredBlocks;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusMiscBlocks;
import net.hibiscus.naturespirit.registration.block_registration.HibiscusWoods;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_7923;

class NatureSpiritModelGenerator
extends FabricModelProvider {
    private static final class_4942 TALL_LARGE_CROSS = NatureSpiritModelGenerator.block("tall_large_cross", class_4945.field_23025);
    private static final class_4942 TINTED_TALL_LARGE_CROSS = NatureSpiritModelGenerator.block("tinted_tall_large_cross", class_4945.field_23025);
    private static final class_4942 LARGE_CROSS = NatureSpiritModelGenerator.block("large_cross", class_4945.field_23025);
    private static final class_4942 TINTED_LARGE_CROSS = NatureSpiritModelGenerator.block("tinted_large_cross", class_4945.field_23025);
    private static final class_4942 TALL_CROSS = NatureSpiritModelGenerator.block("tall_cross", class_4945.field_23025);
    private static final class_4942 FLOWER_POT_TALL_CROSS = NatureSpiritModelGenerator.block("flower_pot_tall_cross", class_4945.field_23026);
    private static final class_4942 FLOWER_POT_LARGE_CROSS = NatureSpiritModelGenerator.block("flower_pot_large_cross", class_4945.field_23026);
    private static final class_4942 POLYPORE = NatureSpiritModelGenerator.block("polypore", class_4945.field_23026);
    private static final class_4942 SUCCULENT = NatureSpiritModelGenerator.block("succulent", class_4945.field_23026);
    private static final class_4942 SUCCULENT_WALL = NatureSpiritModelGenerator.block("succulent_wall", class_4945.field_23026);
    private static final class_4942 FLOWER_POT_SUCCULENT = NatureSpiritModelGenerator.block("flower_pot_succulent", class_4945.field_23026);
    private static final class_4942 FLOWER_POT_TINTED_LARGE_CROSS = NatureSpiritModelGenerator.block("tinted_flower_pot_large_cross", class_4945.field_23026);
    private static final class_4942 CROP = NatureSpiritModelGenerator.block("crop", class_4945.field_22999);
    private static final class_4942 PAPER_LANTERN = NatureSpiritModelGenerator.block("template_paper_lantern", class_4945.field_23015, class_4945.field_23018);
    private static final class_4942 HANGING_PAPER_LANTERN = NatureSpiritModelGenerator.block("template_hanging_paper_lantern", "_hanging", class_4945.field_23015, class_4945.field_23018);
    private static final class_4942 AZOLLA_1 = NatureSpiritModelGenerator.block("template_azolla_1", "_1", class_4945.field_23026);
    private static final class_4942 AZOLLA_2 = NatureSpiritModelGenerator.block("template_azolla_2", "_2", class_4945.field_23026);
    private static final class_4942 AZOLLA_3 = NatureSpiritModelGenerator.block("template_azolla_3", "_3", class_4945.field_23026);
    private static final class_4942 AZOLLA_4 = NatureSpiritModelGenerator.block("template_azolla_4", "_4", class_4945.field_23026);
    public static final class_4946.class_4947 TEXTURED_SUCCULENT = class_4946.method_25918(class_4944::method_25881, (class_4942)SUCCULENT);
    public static final class_4946.class_4947 TEXTURED_POLYPORE = class_4946.method_25918(class_4944::method_25881, (class_4942)POLYPORE);
    public static final class_4946.class_4947 TEMPLATE_PAPER_LANTERN = class_4946.method_25918(NatureSpiritModelGenerator::paperLantern, (class_4942)PAPER_LANTERN);
    public static final class_4946.class_4947 TEMPLATE_HANGING_PAPER_LANTERN = class_4946.method_25918(NatureSpiritModelGenerator::paperLantern, (class_4942)HANGING_PAPER_LANTERN);
    public static final class_4946.class_4947 TEXTURED_AZOLLA_1 = class_4946.method_25918(class_4944::method_25881, (class_4942)AZOLLA_1);
    public static final class_4946.class_4947 TEXTURED_AZOLLA_2 = class_4946.method_25918(class_4944::method_25881, (class_4942)AZOLLA_2);
    public static final class_4946.class_4947 TEXTURED_AZOLLA_3 = class_4946.method_25918(class_4944::method_25881, (class_4942)AZOLLA_3);
    public static final class_4946.class_4947 TEXTURED_AZOLLA_4 = class_4946.method_25918(class_4944::method_25881, (class_4942)AZOLLA_4);

    public static class_4944 paperLantern(class_2248 block) {
        return new class_4944().method_25868(class_4945.field_23018, NatureSpiritModelGenerator.getId(block)).method_25868(class_4945.field_23015, NatureSpiritModelGenerator.getId(block).method_48331("_top"));
    }

    public NatureSpiritModelGenerator(FabricDataOutput output) {
        super(output);
    }

    private static class_4942 block(String parent, class_4945 ... requiredTextureKeys) {
        return new class_4942(Optional.of(new class_2960("natures_spirit", "block/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    private static class_4942 block(String parent, String variant, class_4945 ... requiredTextureKeys) {
        return new class_4942(Optional.of(new class_2960("natures_spirit", "block/" + parent)), Optional.of(variant), requiredTextureKeys);
    }

    public static class_2960 getId(class_2248 block) {
        class_2960 identifier = class_7923.field_41175.method_10221((Object)block);
        return identifier.method_45138("block/");
    }

    private void createSlab(class_2248 block, class_2248 slab, class_4910 blockStateModelGenerator) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        class_4946 texturedModel = class_4946.field_23036.get(block);
        class_2960 resourceLocation2 = class_4943.field_22909.method_25846(slab, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 resourceLocation3 = class_4943.field_22910.method_25846(slab, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25668((class_2248)slab, (class_2960)resourceLocation2, (class_2960)resourceLocation3, (class_2960)resourceLocation));
    }

    private void createStairs(class_2248 block, class_2248 stairs, class_4910 blockStateModelGenerator) {
        class_4946 texturedModel = class_4946.field_23036.get(block);
        class_2960 resourceLocation = class_4943.field_22913.method_25846(stairs, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22912.method_25846(stairs, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 resourceLocation3 = class_4943.field_22914.method_25846(stairs, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25646((class_2248)stairs, (class_2960)resourceLocation, (class_2960)resourceLocation2, (class_2960)resourceLocation3));
        blockStateModelGenerator.method_25623(stairs, resourceLocation2);
    }

    public void createWoodDoor(class_2248 doorBlock, class_4910 blockStateModelGenerator) {
        class_4944 textureMapping = class_4944.method_25900((class_2248)doorBlock);
        class_2960 resourceLocation = class_4943.field_38016.method_25846(doorBlock, textureMapping, blockStateModelGenerator.field_22831);
        class_2960 resourceLocation2 = class_4943.field_38017.method_25846(doorBlock, textureMapping, blockStateModelGenerator.field_22831);
        class_2960 resourceLocation3 = class_4943.field_38018.method_25846(doorBlock, textureMapping, blockStateModelGenerator.field_22831);
        class_2960 resourceLocation4 = class_4943.field_38019.method_25846(doorBlock, textureMapping, blockStateModelGenerator.field_22831);
        class_2960 resourceLocation5 = class_4943.field_38020.method_25846(doorBlock, textureMapping, blockStateModelGenerator.field_22831);
        class_2960 resourceLocation6 = class_4943.field_38021.method_25846(doorBlock, textureMapping, blockStateModelGenerator.field_22831);
        class_2960 resourceLocation7 = class_4943.field_38022.method_25846(doorBlock, textureMapping, blockStateModelGenerator.field_22831);
        class_2960 resourceLocation8 = class_4943.field_38023.method_25846(doorBlock, textureMapping, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.method_25537(doorBlock.method_8389());
        blockStateModelGenerator.field_22830.accept(class_4910.method_25609((class_2248)doorBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2, (class_2960)resourceLocation3, (class_2960)resourceLocation4, (class_2960)resourceLocation5, (class_2960)resourceLocation6, (class_2960)resourceLocation7, (class_2960)resourceLocation8));
    }

    public void createWoodTrapdoor(class_2248 orientableTrapdoorBlock, class_4910 blockStateModelGenerators) {
        class_4944 textureMapping = class_4944.method_25872((class_2248)orientableTrapdoorBlock);
        class_2960 resourceLocation = class_4943.field_22918.method_25846(orientableTrapdoorBlock, textureMapping, blockStateModelGenerators.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22919.method_25846(orientableTrapdoorBlock, textureMapping, blockStateModelGenerators.field_22831);
        class_2960 resourceLocation3 = class_4943.field_22920.method_25846(orientableTrapdoorBlock, textureMapping, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25655((class_2248)orientableTrapdoorBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2, (class_2960)resourceLocation3));
        blockStateModelGenerators.method_25623(orientableTrapdoorBlock, resourceLocation2);
    }

    public void createWoodFenceGate(class_2248 planks, class_2248 fenceGateBlock, class_4910 blockStateModelGenerator) {
        class_4946 texturedModel = class_4946.field_23036.get(planks);
        class_2960 resourceLocation = class_4943.field_22996.method_25846(fenceGateBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22995.method_25846(fenceGateBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 resourceLocation3 = class_4943.field_22905.method_25846(fenceGateBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 resourceLocation4 = class_4943.field_22904.method_25846(fenceGateBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25626((class_2248)fenceGateBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2, (class_2960)resourceLocation3, (class_2960)resourceLocation4, (boolean)true));
    }

    public void createWoodFence(class_2248 planks, class_2248 fenceBlock, class_4910 blockStateModelGenerators) {
        class_4946 texturedModel = class_4946.field_23036.get(planks);
        class_2960 resourceLocation = class_4943.field_22988.method_25846(fenceBlock, texturedModel.method_25921(), blockStateModelGenerators.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22989.method_25846(fenceBlock, texturedModel.method_25921(), blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25661((class_2248)fenceBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2));
        class_2960 resourceLocation3 = class_4943.field_22990.method_25846(fenceBlock, texturedModel.method_25921(), blockStateModelGenerators.field_22831);
        blockStateModelGenerators.method_25623(fenceBlock, resourceLocation3);
    }

    public void createWoodPressurePlate(class_2248 planks, class_2248 pressurePlateBlock, class_4910 blockStateModelGenerator) {
        class_4946 texturedModel = class_4946.field_23036.get(planks);
        class_2960 resourceLocation = class_4943.field_22906.method_25846(pressurePlateBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22907.method_25846(pressurePlateBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25673((class_2248)pressurePlateBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2));
    }

    public void createWoodSign(class_2248 signBlock, class_2248 wallSignBlock, class_4910 blockStateModelGenerator) {
        class_4944 textureMapping = class_4944.method_25872((class_2248)signBlock);
        class_2960 resourceLocation = class_4943.field_22908.method_25846(signBlock, textureMapping, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)signBlock, (class_2960)resourceLocation));
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)wallSignBlock, (class_2960)resourceLocation));
        blockStateModelGenerator.method_25537(signBlock.method_8389());
        blockStateModelGenerator.method_25540(wallSignBlock);
    }

    public void createWall(class_2248 block, class_2248 wallBlock, class_4910 blockStateModelGenerator) {
        class_4946 texturedModel = class_4946.field_23036.get(block);
        class_2960 identifier = class_4943.field_22991.method_25846(wallBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 identifier2 = class_4943.field_22992.method_25846(wallBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 identifier3 = class_4943.field_22993.method_25846(wallBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25636((class_2248)wallBlock, (class_2960)identifier, (class_2960)identifier2, (class_2960)identifier3));
        class_2960 identifier4 = class_4943.field_22994.method_25846(wallBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.method_25623(wallBlock, identifier4);
    }

    public void createWoodButton(class_2248 planks, class_2248 buttonBlock, class_4910 blockStateModelGenerators) {
        class_4946 texturedModel = class_4946.field_23036.get(planks);
        class_2960 resourceLocation = class_4943.field_22981.method_25846(buttonBlock, texturedModel.method_25921(), blockStateModelGenerators.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22982.method_25846(buttonBlock, texturedModel.method_25921(), blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25654((class_2248)buttonBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2));
        class_2960 resourceLocation3 = class_4943.field_22983.method_25846(buttonBlock, texturedModel.method_25921(), blockStateModelGenerators.field_22831);
        blockStateModelGenerators.method_25623(buttonBlock, resourceLocation3);
    }

    public void createHangingSign(class_2248 strippedLog, class_2248 hangingSign, class_2248 wallHangingSign, class_4910 blockStateModelGenerator) {
        class_4944 textureMap = class_4944.method_25901((class_2248)strippedLog);
        class_2960 identifier = class_4943.field_22908.method_25846(hangingSign, textureMap, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)hangingSign, (class_2960)identifier));
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)wallHangingSign, (class_2960)identifier));
        blockStateModelGenerator.method_25537(hangingSign.method_8389());
        blockStateModelGenerator.method_25540(wallHangingSign);
    }

    private void generateWoodBlockStateModels(HashMap<String, WoodSet> woods, class_4910 blockStateModelGenerator) {
        for (WoodSet woodSet : woods.values()) {
            if (woodSet.getWoodPreset() == WoodSet.WoodPreset.BAMBOO) {
                blockStateModelGenerator.method_25676(woodSet.getLog()).method_25730(woodSet.getLog());
                blockStateModelGenerator.method_25676(woodSet.getStrippedLog()).method_25730(woodSet.getStrippedLog());
            } else if (woodSet.getWoodPreset() == WoodSet.WoodPreset.JOSHUA) {
                blockStateModelGenerator.method_25676(woodSet.getBundle()).method_25730(woodSet.getBundle());
                blockStateModelGenerator.method_25676(woodSet.getStrippedBundle()).method_25730(woodSet.getStrippedBundle());
            } else if (woodSet.hasBark()) {
                blockStateModelGenerator.method_25676(woodSet.getLog()).method_25730(woodSet.getLog()).method_25728(woodSet.getWood());
                blockStateModelGenerator.method_25676(woodSet.getStrippedLog()).method_25730(woodSet.getStrippedLog()).method_25728(woodSet.getStrippedWood());
            }
            if (woodSet.hasMosaic()) {
                blockStateModelGenerator.method_25622(woodSet.getMosaic(), class_4946.field_23036);
                this.createSlab(woodSet.getMosaic(), woodSet.getMosaicSlab(), blockStateModelGenerator);
                this.createStairs(woodSet.getMosaic(), woodSet.getMosaicStairs(), blockStateModelGenerator);
            }
            blockStateModelGenerator.method_25622(woodSet.getPlanks(), class_4946.field_23036);
            this.createSlab(woodSet.getPlanks(), woodSet.getSlab(), blockStateModelGenerator);
            this.createStairs(woodSet.getPlanks(), woodSet.getStairs(), blockStateModelGenerator);
            this.createWoodDoor(woodSet.getDoor(), blockStateModelGenerator);
            this.createWoodTrapdoor(woodSet.getTrapDoor(), blockStateModelGenerator);
            this.createWoodFenceGate(woodSet.getPlanks(), woodSet.getFenceGate(), blockStateModelGenerator);
            this.createWoodFence(woodSet.getPlanks(), woodSet.getFence(), blockStateModelGenerator);
            this.createWoodButton(woodSet.getPlanks(), woodSet.getButton(), blockStateModelGenerator);
            this.createWoodPressurePlate(woodSet.getPlanks(), woodSet.getPressurePlate(), blockStateModelGenerator);
            this.createWoodSign(woodSet.getSign(), woodSet.getWallSign(), blockStateModelGenerator);
            this.createHangingSign(woodSet.getStrippedLog(), woodSet.getHangingSign(), woodSet.getHangingWallSign(), blockStateModelGenerator);
        }
    }

    private void generateFlowerSetBlockStateModels(HashMap<String, FlowerSet> flowers, class_4910 blockStateModelGenerator) {
        for (FlowerSet flowerSet : flowers.values()) {
            if (Objects.equals(flowerSet.getName(), "protea")) continue;
            if (flowerSet.getPreset() == FlowerSet.FlowerPreset.SMALL) {
                this.generateFlowerBlockStateModels(flowerSet.getFlowerBlock(), flowerSet.getPottedFlowerBlock(), blockStateModelGenerator);
            }
            if (flowerSet.getPreset() == FlowerSet.FlowerPreset.ANEMONE) {
                this.generatePottedAnemone(flowerSet.getFlowerBlock(), flowerSet.getPottedFlowerBlock(), blockStateModelGenerator);
            }
            if (flowerSet.getPreset() == FlowerSet.FlowerPreset.TALL) {
                blockStateModelGenerator.method_25621(flowerSet.getFlowerBlock(), class_4910.class_4913.field_22840);
            }
            if (flowerSet.getPreset() == FlowerSet.FlowerPreset.BIG_TALL) {
                this.generateTallLargeFlower(flowerSet.getFlowerBlock(), blockStateModelGenerator);
            }
            if (flowerSet.getPreset() != FlowerSet.FlowerPreset.BIG_SMALL) continue;
            this.generateLargeFlower(flowerSet.getFlowerBlock(), flowerSet.getPottedFlowerBlock(), blockStateModelGenerator);
        }
    }

    private void generateStoneBlockStateModels(HashMap<String, StoneSet> stones, class_4910 blockStateModelGenerator) {
        for (StoneSet stoneSet : stones.values()) {
            if (stoneSet.hasTiles()) {
                this.createWall(stoneSet.getTiles(), stoneSet.getTilesWall(), blockStateModelGenerator);
                this.createSlab(stoneSet.getTiles(), stoneSet.getTilesSlab(), blockStateModelGenerator);
                this.createStairs(stoneSet.getTiles(), stoneSet.getTilesStairs(), blockStateModelGenerator);
                blockStateModelGenerator.method_25641(stoneSet.getTiles());
            }
            if (stoneSet.hasCobbled()) {
                this.createWall(stoneSet.getCobbled(), stoneSet.getCobbledWall(), blockStateModelGenerator);
                this.createSlab(stoneSet.getCobbled(), stoneSet.getCobbledSlab(), blockStateModelGenerator);
                this.createStairs(stoneSet.getCobbled(), stoneSet.getCobbledStairs(), blockStateModelGenerator);
                blockStateModelGenerator.method_25641(stoneSet.getCobbled());
                if (stoneSet.hasMossy()) {
                    this.createWall(stoneSet.getMossyCobbled(), stoneSet.getMossyCobbledWall(), blockStateModelGenerator);
                    this.createSlab(stoneSet.getMossyCobbled(), stoneSet.getMossyCobbledSlab(), blockStateModelGenerator);
                    this.createStairs(stoneSet.getMossyCobbled(), stoneSet.getMossyCobbledStairs(), blockStateModelGenerator);
                    blockStateModelGenerator.method_25641(stoneSet.getMossyCobbled());
                }
            }
            if (stoneSet.hasMossy()) {
                this.createWall(stoneSet.getMossyBricks(), stoneSet.getMossyBricksWall(), blockStateModelGenerator);
                this.createSlab(stoneSet.getMossyBricks(), stoneSet.getMossyBricksSlab(), blockStateModelGenerator);
                this.createStairs(stoneSet.getMossyBricks(), stoneSet.getMossyBricksStairs(), blockStateModelGenerator);
                blockStateModelGenerator.method_25641(stoneSet.getMossyBricks());
            }
            if (stoneSet.hasCracked()) {
                blockStateModelGenerator.method_25641(stoneSet.getCrackedBricks());
            }
            this.createWall(stoneSet.getBricks(), stoneSet.getBricksWall(), blockStateModelGenerator);
            this.createSlab(stoneSet.getBricks(), stoneSet.getBricksSlab(), blockStateModelGenerator);
            this.createStairs(stoneSet.getBricks(), stoneSet.getBricksStairs(), blockStateModelGenerator);
            blockStateModelGenerator.method_25641(stoneSet.getBricks());
            this.createWall(stoneSet.getPolished(), stoneSet.getPolishedWall(), blockStateModelGenerator);
            this.createSlab(stoneSet.getPolished(), stoneSet.getPolishedSlab(), blockStateModelGenerator);
            this.createStairs(stoneSet.getPolished(), stoneSet.getPolishedStairs(), blockStateModelGenerator);
            blockStateModelGenerator.method_25641(stoneSet.getPolished());
            this.createSlab(stoneSet.getBase(), stoneSet.getBaseSlab(), blockStateModelGenerator);
            this.createStairs(stoneSet.getBase(), stoneSet.getBaseStairs(), blockStateModelGenerator);
            if (stoneSet.isRotatable()) {
                blockStateModelGenerator.method_25676(stoneSet.getBase()).method_25730(stoneSet.getBase());
            } else {
                blockStateModelGenerator.method_25641(stoneSet.getBase());
            }
            blockStateModelGenerator.method_25641(stoneSet.getChiseled());
        }
    }

    private void generateTreeBlockStateModels(HashMap<String, class_2248[]> saplings, HashMap<String, class_2248> leaves, class_4910 blockStateModelGenerator) {
        for (String i : leaves.keySet()) {
            class_2248[] saplingType = saplings.get(i);
            class_2248 leavesType = leaves.get(i);
            if (Objects.equals(i, "coconut")) continue;
            blockStateModelGenerator.method_25622(leavesType, class_4946.field_23049);
            if (i.equals("redwood")) {
                this.generatePottedAnemone(saplingType[0], saplingType[1], blockStateModelGenerator);
                continue;
            }
            if (Objects.equals(i, "wisteria") || i.startsWith("part") || i.startsWith("frosty")) continue;
            blockStateModelGenerator.method_25545(saplingType[0], saplingType[1], class_4910.class_4913.field_22840);
        }
    }

    public final void registerTallCrossBlockState(class_2248 block, class_4944 crossTexture, class_4910 blockStateModelGenerators) {
        class_2960 identifier = TALL_CROSS.method_25846(block, crossTexture, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)identifier));
    }

    public final void registerPaperLantern(class_2248 lantern, class_4910 blockStateModelGenerator) {
        class_2960 identifier = TEMPLATE_PAPER_LANTERN.method_25923(lantern, blockStateModelGenerator.field_22831);
        class_2960 identifier2 = TEMPLATE_HANGING_PAPER_LANTERN.method_25923(lantern, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.method_25537(lantern.method_8389());
        blockStateModelGenerator.field_22830.accept(class_4925.method_25769((class_2248)lantern).method_25775(class_4910.method_25565((class_2746)class_2741.field_16561, (class_2960)identifier2, (class_2960)identifier)));
    }

    public final void registerVineBlockState(class_2248 block, class_4944 crossTexture, class_4910 blockStateModelGenerators) {
        class_2960 identifier = CROP.method_25846(block, crossTexture, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)identifier));
    }

    public final void registerTallLargeBlockState(class_2248 block, class_4944 crossTexture, class_4910 blockStateModelGenerators) {
        class_2960 identifier = TALL_LARGE_CROSS.method_25846(block, crossTexture, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)identifier));
    }

    public final void registerTintedTallLargeBlockState(class_2248 block, class_4944 crossTexture, class_4910 blockStateModelGenerators) {
        class_2960 identifier = TINTED_TALL_LARGE_CROSS.method_25846(block, crossTexture, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)identifier));
    }

    public final void registerSpecificFlowerItemModel(class_2248 block, class_4910 blockStateModelGenerators) {
        class_1792 item = block.method_8389();
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25871((class_1792)item), blockStateModelGenerators.field_22831);
    }

    private void generateFlowerBlockStateModels(class_2248 block, class_2248 block2, class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_25545(block, block2, class_4910.class_4913.field_22840);
    }

    private void generateTintedFlowerBlockStateModels(class_2248 block, class_2248 block2, class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_25545(block, block2, class_4910.class_4913.field_22839);
    }

    private void generatePottedAnemone(class_2248 block, class_2248 flowerPot, class_4910 blockStateModelGenerators) {
        this.registerSpecificFlowerItemModel(block, blockStateModelGenerators);
        class_4944 textureMap1 = class_4944.method_25877((class_2248)block);
        this.registerTallCrossBlockState(block, textureMap1, blockStateModelGenerators);
        class_4944 textureMap = class_4944.method_25881((class_2248)block);
        class_2960 identifier = FLOWER_POT_TALL_CROSS.method_25846(flowerPot, textureMap, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)flowerPot, (class_2960)identifier));
    }

    public final void generateVineBlockStateModels(class_2248 plant, class_2248 plantStem, class_4910 blockStateModelGenerators) {
        class_4944 textureMap1 = class_4944.method_25889((class_2960)NatureSpiritModelGenerator.getId(plant));
        this.registerVineBlockState(plant, textureMap1, blockStateModelGenerators);
        class_4944 textureMap2 = class_4944.method_25889((class_2960)NatureSpiritModelGenerator.getId(plantStem));
        this.registerVineBlockState(plantStem, textureMap2, blockStateModelGenerators);
        blockStateModelGenerators.method_25556(plant, "_plant");
    }

    public final void generateTallLargeFlower(class_2248 doubleBlock, class_4910 blockStateModelGenerators) {
        this.registerSpecificFlowerItemModel(doubleBlock, blockStateModelGenerators);
        class_2960 identifier = blockStateModelGenerators.method_25557(doubleBlock, "_top", LARGE_CROSS, class_4944::method_25880);
        class_2960 identifier2 = blockStateModelGenerators.method_25557(doubleBlock, "_bottom", LARGE_CROSS, class_4944::method_25880);
        blockStateModelGenerators.method_25678(doubleBlock, identifier, identifier2);
    }

    public final void generateTintedTallLargeFlower(class_2248 doubleBlock, class_4910 blockStateModelGenerators) {
        this.registerSpecificFlowerItemModel(doubleBlock, blockStateModelGenerators);
        class_2960 identifier = blockStateModelGenerators.method_25557(doubleBlock, "_top", TINTED_LARGE_CROSS, class_4944::method_25880);
        class_2960 identifier2 = blockStateModelGenerators.method_25557(doubleBlock, "_bottom", TINTED_LARGE_CROSS, class_4944::method_25880);
        blockStateModelGenerators.method_25678(doubleBlock, identifier, identifier2);
    }

    public final void generateLargeFlower(class_2248 block, class_2248 flowerPot, class_4910 blockStateModelGenerators) {
        this.registerSpecificFlowerItemModel(block, blockStateModelGenerators);
        this.registerTallLargeBlockState(block, class_4944.method_25877((class_2248)block), blockStateModelGenerators);
        class_4944 textureMap = class_4944.method_25881((class_2248)block);
        class_2960 identifier = FLOWER_POT_LARGE_CROSS.method_25846(flowerPot, textureMap, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)flowerPot, (class_2960)identifier));
    }

    public final void generateSucculent(class_2248 block, class_2248 wall, class_2248 flowerPot, class_4910 blockStateModelGenerators) {
        class_4946 texturedModel = TEXTURED_SUCCULENT.get(block);
        class_4944 textureMap = class_4944.method_25881((class_2248)block);
        class_2960 identifier = texturedModel.method_25916(block, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)identifier));
        class_2960 identifier2 = SUCCULENT_WALL.method_25846(wall, texturedModel.method_25921(), blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4925.method_25770((class_2248)wall, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2)).method_25775(class_4910.method_25599()));
        blockStateModelGenerators.method_25600(block);
        class_2960 identifier3 = FLOWER_POT_SUCCULENT.method_25846(flowerPot, textureMap, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)flowerPot, (class_2960)identifier3));
    }

    public final void generatePolypore(class_2248 wall, class_4910 blockStateModelGenerators) {
        class_2960 identifier2 = TEXTURED_POLYPORE.method_25923(wall, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4925.method_25770((class_2248)wall, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2)).method_25775(class_4910.method_25599()));
        blockStateModelGenerators.method_25600(wall);
    }

    public final void generateTintedLargeFlower(class_2248 block, class_2248 flowerPot, class_4910 blockStateModelGenerators) {
        this.registerSpecificFlowerItemModel(block, blockStateModelGenerators);
        this.registerTintedTallLargeBlockState(block, class_4944.method_25877((class_2248)block), blockStateModelGenerators);
        class_4944 textureMap = class_4944.method_25881((class_2248)block);
        class_2960 identifier = FLOWER_POT_TINTED_LARGE_CROSS.method_25846(flowerPot, textureMap, blockStateModelGenerators.field_22831);
        blockStateModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)flowerPot, (class_2960)identifier));
    }

    public final void generateLargeFlower(class_2248 block, class_4910 blockStateModelGenerators) {
        this.registerSpecificFlowerItemModel(block, blockStateModelGenerators);
        this.registerTallLargeBlockState(block, class_4944.method_25877((class_2248)block), blockStateModelGenerators);
    }

    public final void registerCropWithoutItem(class_2248 crop, class_2769<Integer> ageProperty, class_4910 blockStateModelGenerator, int ... ageTextureIndices) {
        if (ageProperty.method_11898().size() != ageTextureIndices.length) {
            throw new IllegalArgumentException();
        }
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        class_4926 blockStateVariantMap = class_4926.method_25783(ageProperty).method_25795(arg_0 -> NatureSpiritModelGenerator.lambda$registerCropWithoutItem$1(ageTextureIndices, (Int2ObjectMap)int2ObjectMap, blockStateModelGenerator, crop, arg_0));
        blockStateModelGenerator.field_22830.accept(class_4925.method_25769((class_2248)crop).method_25775(blockStateVariantMap));
    }

    public final void registerMushroomBlock(class_2248 mushroomBlock, class_4910 blockStateModelGenerator) {
        class_2960 identifier = class_4943.field_22937.method_25846(mushroomBlock, class_4944.method_25872((class_2248)mushroomBlock), blockStateModelGenerator.field_22831);
        class_2960 identifier2 = class_4941.method_25844((String)"mushroom_block_inside");
        blockStateModelGenerator.field_22830.accept(class_4922.method_25758((class_2248)mushroomBlock).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)false)));
        blockStateModelGenerator.method_25623(mushroomBlock, class_4946.field_23036.method_25922(mushroomBlock, "_inventory", blockStateModelGenerator.field_22831));
    }

    private void registerCheese(class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.field_22830.accept(class_4925.method_25769((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12505).method_25793((Comparable)Integer.valueOf(0), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25842((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK))).method_25793((Comparable)Integer.valueOf(1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK, (String)"_slice1"))).method_25793((Comparable)Integer.valueOf(2), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK, (String)"_slice2"))).method_25793((Comparable)Integer.valueOf(3), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK, (String)"_slice3"))).method_25793((Comparable)Integer.valueOf(4), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK, (String)"_slice4"))).method_25793((Comparable)Integer.valueOf(5), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK, (String)"_slice5"))).method_25793((Comparable)Integer.valueOf(6), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK, (String)"_slice6")))));
        blockStateModelGenerator.method_25540(HibiscusMiscBlocks.CHEESE_BLOCK);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)HibiscusMiscBlocks.CHEESE_CAULDRON, (class_2960)class_4943.field_27784.method_25846(HibiscusMiscBlocks.CHEESE_CAULDRON, class_4944.method_32232((class_2960)class_4944.method_25860((class_2248)HibiscusMiscBlocks.CHEESE_BLOCK)), blockStateModelGenerator.field_22831)));
        blockStateModelGenerator.method_25540(HibiscusMiscBlocks.CHEESE_CAULDRON);
    }

    public final void registerPaperPanels(class_2248 block, class_2248 paperPanel, class_4910 blockStateModelGenerator) {
        class_4944 textureMap = class_4944.method_25873((class_2248)block, (class_2248)paperPanel);
        class_2960 identifier = class_4943.field_22953.method_25846(paperPanel, textureMap, blockStateModelGenerator.field_22831);
        class_2960 identifier2 = class_4943.field_22954.method_25846(paperPanel, textureMap, blockStateModelGenerator.field_22831);
        class_2960 identifier3 = class_4943.field_22955.method_25846(paperPanel, textureMap, blockStateModelGenerator.field_22831);
        class_2960 identifier4 = class_4943.field_22951.method_25846(paperPanel, textureMap, blockStateModelGenerator.field_22831);
        class_2960 identifier5 = class_4943.field_22952.method_25846(paperPanel, textureMap, blockStateModelGenerator.field_22831);
        class_1792 item = paperPanel.method_8389();
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25911((class_2248)block), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4922.method_25758((class_2248)paperPanel).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier3)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier4)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier5)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier5).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)));
    }

    public final void registerNorthDefaultHorizontalFacing(class_4946.class_4947 modelFactory, class_2248 block, class_4910 blockStateModelGenerator) {
        class_2960 identifier = modelFactory.method_25923(block, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier)).method_25775(class_4910.method_25599()));
    }

    public final void registerAzolla(class_1792 item, class_2248 flowerbed, class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_25537(item);
        class_2960 identifier = TEXTURED_AZOLLA_1.method_25923(flowerbed, blockStateModelGenerator.field_22831);
        class_2960 identifier2 = TEXTURED_AZOLLA_2.method_25923(flowerbed, blockStateModelGenerator.field_22831);
        class_2960 identifier3 = TEXTURED_AZOLLA_3.method_25923(flowerbed, blockStateModelGenerator.field_22831);
        class_2960 identifier4 = TEXTURED_AZOLLA_4.method_25923(flowerbed, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4922.method_25758((class_2248)flowerbed).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(1), (Comparable[])new Integer[]{2, 3, 4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(1), (Comparable[])new Integer[]{2, 3, 4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(1), (Comparable[])new Integer[]{2, 3, 4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(1), (Comparable[])new Integer[]{2, 3, 4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(2), (Comparable[])new Integer[]{3, 4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(2), (Comparable[])new Integer[]{3, 4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(2), (Comparable[])new Integer[]{3, 4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(2), (Comparable[])new Integer[]{3, 4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(3), (Comparable[])new Integer[]{4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier3)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(3), (Comparable[])new Integer[]{4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(3), (Comparable[])new Integer[]{4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)class_4918.method_25744().method_25752((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(3), (Comparable[])new Integer[]{4}).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(4)).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier4)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(4)).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(4)).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(4)).method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)));
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        this.generateWoodBlockStateModels(HibiscusRegistryHelper.WoodHashMap, blockStateModelGenerator);
        this.generateFlowerSetBlockStateModels(HibiscusRegistryHelper.FlowerHashMap, blockStateModelGenerator);
        this.generateStoneBlockStateModels(HibiscusRegistryHelper.StoneHashMap, blockStateModelGenerator);
        this.generateTreeBlockStateModels(HibiscusRegistryHelper.SaplingHashMap, HibiscusRegistryHelper.LeavesHashMap, blockStateModelGenerator);
        blockStateModelGenerator.method_32229(HibiscusMiscBlocks.CALCITE_CLUSTER);
        blockStateModelGenerator.method_32229(HibiscusMiscBlocks.SMALL_CALCITE_BUD);
        blockStateModelGenerator.method_32229(HibiscusMiscBlocks.LARGE_CALCITE_BUD);
        this.registerCheese(blockStateModelGenerator);
        this.generateFlowerBlockStateModels(HibiscusMiscBlocks.FLAXEN_FERN, HibiscusMiscBlocks.POTTED_FLAXEN_FERN, blockStateModelGenerator);
        this.generateFlowerBlockStateModels(HibiscusMiscBlocks.SHIITAKE_MUSHROOM, HibiscusMiscBlocks.POTTED_SHIITAKE_MUSHROOM, blockStateModelGenerator);
        this.registerMushroomBlock(HibiscusMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, blockStateModelGenerator);
        this.generatePolypore(HibiscusMiscBlocks.GRAY_POLYPORE, blockStateModelGenerator);
        this.registerMushroomBlock(HibiscusMiscBlocks.GRAY_POLYPORE_BLOCK, blockStateModelGenerator);
        this.registerCropWithoutItem(HibiscusMiscBlocks.DESERT_TURNIP_STEM, (class_2769<Integer>)DesertPlantBlock.AGE, blockStateModelGenerator, 0, 1, 2, 3, 4, 5, 6, 7);
        this.generateTallLargeFlower(HibiscusMiscBlocks.TALL_FRIGID_GRASS, blockStateModelGenerator);
        this.generateTallLargeFlower(HibiscusMiscBlocks.TALL_SCORCHED_GRASS, blockStateModelGenerator);
        this.generateTallLargeFlower(HibiscusMiscBlocks.TALL_BEACH_GRASS, blockStateModelGenerator);
        this.generateTintedTallLargeFlower(HibiscusMiscBlocks.LARGE_LUSH_FERN, blockStateModelGenerator);
        this.generateTallLargeFlower(HibiscusMiscBlocks.TALL_SEDGE_GRASS, blockStateModelGenerator);
        this.generateTallLargeFlower(HibiscusMiscBlocks.TALL_OAT_GRASS, blockStateModelGenerator);
        this.generateTallLargeFlower(HibiscusMiscBlocks.TALL_MELIC_GRASS, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.SCORCHED_GRASS, HibiscusMiscBlocks.POTTED_SCORCHED_GRASS, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.RED_BEARBERRIES, HibiscusMiscBlocks.POTTED_RED_BEARBERRIES, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.PURPLE_BEARBERRIES, HibiscusMiscBlocks.POTTED_PURPLE_BEARBERRIES, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.GREEN_BEARBERRIES, HibiscusMiscBlocks.POTTED_GREEN_BEARBERRIES, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.GREEN_BITTER_SPROUTS, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.RED_BITTER_SPROUTS, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.PURPLE_BITTER_SPROUTS, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.FRIGID_GRASS, HibiscusMiscBlocks.POTTED_FRIGID_GRASS, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.BEACH_GRASS, HibiscusMiscBlocks.POTTED_BEACH_GRASS, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.SEDGE_GRASS, HibiscusMiscBlocks.POTTED_SEDGE_GRASS, blockStateModelGenerator);
        this.generateLargeFlower(HibiscusMiscBlocks.OAT_GRASS, HibiscusMiscBlocks.POTTED_OAT_GRASS, blockStateModelGenerator);
        this.generateTintedLargeFlower(HibiscusMiscBlocks.LUSH_FERN, HibiscusMiscBlocks.POTTED_LUSH_FERN, blockStateModelGenerator);
        this.generateTintedLargeFlower(HibiscusMiscBlocks.MELIC_GRASS, HibiscusMiscBlocks.POTTED_MELIC_GRASS, blockStateModelGenerator);
        this.generateVineBlockStateModels(HibiscusWoods.WISTERIA.getBlueWisteriaVines(), HibiscusWoods.WISTERIA.getBlueWisteriaVinesPlant(), blockStateModelGenerator);
        this.generateVineBlockStateModels(HibiscusWoods.WISTERIA.getWhiteWisteriaVines(), HibiscusWoods.WISTERIA.getWhiteWisteriaVinesPlant(), blockStateModelGenerator);
        this.generateVineBlockStateModels(HibiscusWoods.WISTERIA.getPurpleWisteriaVines(), HibiscusWoods.WISTERIA.getPurpleWisteriaVinesPlant(), blockStateModelGenerator);
        this.generateVineBlockStateModels(HibiscusWoods.WISTERIA.getPinkWisteriaVines(), HibiscusWoods.WISTERIA.getPinkWisteriaVinesPlant(), blockStateModelGenerator);
        this.generateVineBlockStateModels(HibiscusWoods.WILLOW.getWillowVines(), HibiscusWoods.WILLOW.getWillowVinesPlant(), blockStateModelGenerator);
        this.registerAzolla(HibiscusMiscBlocks.AZOLLA_ITEM, HibiscusMiscBlocks.AZOLLA, blockStateModelGenerator);
        blockStateModelGenerator.method_25676(HibiscusMiscBlocks.ALLUAUDIA_BUNDLE).method_25730(HibiscusMiscBlocks.ALLUAUDIA_BUNDLE);
        blockStateModelGenerator.method_25676(HibiscusMiscBlocks.STRIPPED_ALLUAUDIA_BUNDLE).method_25730(HibiscusMiscBlocks.STRIPPED_ALLUAUDIA_BUNDLE);
        this.createWoodDoor(HibiscusMiscBlocks.PAPER_DOOR, blockStateModelGenerator);
        this.createWoodTrapdoor(HibiscusMiscBlocks.PAPER_TRAPDOOR, blockStateModelGenerator);
        this.createWoodDoor(HibiscusMiscBlocks.FRAMED_PAPER_DOOR, blockStateModelGenerator);
        this.createWoodTrapdoor(HibiscusMiscBlocks.FRAMED_PAPER_TRAPDOOR, blockStateModelGenerator);
        this.createWoodDoor(HibiscusMiscBlocks.BLOOMING_PAPER_DOOR, blockStateModelGenerator);
        this.createWoodTrapdoor(HibiscusMiscBlocks.BLOOMING_PAPER_TRAPDOOR, blockStateModelGenerator);
        this.createWoodSign(HibiscusMiscBlocks.PAPER_SIGN, HibiscusMiscBlocks.PAPER_WALL_SIGN, blockStateModelGenerator);
        this.createHangingSign(HibiscusMiscBlocks.PAPER_BLOCK, HibiscusMiscBlocks.PAPER_HANGING_SIGN, HibiscusMiscBlocks.PAPER_WALL_HANGING_SIGN, blockStateModelGenerator);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.PAPER_BLOCK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.FRAMED_PAPER_BLOCK, class_4946.field_23036);
        this.registerNorthDefaultHorizontalFacing(class_4946.field_23045, HibiscusMiscBlocks.BLOOMING_PAPER_BLOCK, blockStateModelGenerator);
        this.registerPaperPanels(HibiscusMiscBlocks.PAPER_BLOCK, HibiscusMiscBlocks.PAPER_PANEL, blockStateModelGenerator);
        this.registerPaperPanels(HibiscusMiscBlocks.FRAMED_PAPER_BLOCK, HibiscusMiscBlocks.FRAMED_PAPER_PANEL, blockStateModelGenerator);
        this.registerPaperPanels(HibiscusMiscBlocks.BLOOMING_PAPER_BLOCK, HibiscusMiscBlocks.BLOOMING_PAPER_PANEL, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.WHITE_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.LIGHT_GRAY_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.GRAY_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.BLACK_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.BROWN_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.RED_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.ORANGE_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.YELLOW_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.LIME_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.GREEN_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.CYAN_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.LIGHT_BLUE_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.BLUE_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.PURPLE_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.MAGENTA_PAPER_LANTERN, blockStateModelGenerator);
        this.registerPaperLantern(HibiscusColoredBlocks.PINK_PAPER_LANTERN, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.KAOLIN, HibiscusColoredBlocks.KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.WHITE_KAOLIN, HibiscusColoredBlocks.WHITE_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN, HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.GRAY_KAOLIN, HibiscusColoredBlocks.GRAY_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BLACK_KAOLIN, HibiscusColoredBlocks.BLACK_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BROWN_KAOLIN, HibiscusColoredBlocks.BROWN_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.RED_KAOLIN, HibiscusColoredBlocks.RED_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.ORANGE_KAOLIN, HibiscusColoredBlocks.ORANGE_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.YELLOW_KAOLIN, HibiscusColoredBlocks.YELLOW_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIME_KAOLIN, HibiscusColoredBlocks.LIME_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.GREEN_KAOLIN, HibiscusColoredBlocks.GREEN_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.CYAN_KAOLIN, HibiscusColoredBlocks.CYAN_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN, HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BLUE_KAOLIN, HibiscusColoredBlocks.BLUE_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.PURPLE_KAOLIN, HibiscusColoredBlocks.PURPLE_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.MAGENTA_KAOLIN, HibiscusColoredBlocks.MAGENTA_KAOLIN_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.PINK_KAOLIN, HibiscusColoredBlocks.PINK_KAOLIN_SLAB, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.KAOLIN, HibiscusColoredBlocks.KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.WHITE_KAOLIN, HibiscusColoredBlocks.WHITE_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN, HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.GRAY_KAOLIN, HibiscusColoredBlocks.GRAY_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BLACK_KAOLIN, HibiscusColoredBlocks.BLACK_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BROWN_KAOLIN, HibiscusColoredBlocks.BROWN_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.RED_KAOLIN, HibiscusColoredBlocks.RED_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.ORANGE_KAOLIN, HibiscusColoredBlocks.ORANGE_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.YELLOW_KAOLIN, HibiscusColoredBlocks.YELLOW_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIME_KAOLIN, HibiscusColoredBlocks.LIME_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.GREEN_KAOLIN, HibiscusColoredBlocks.GREEN_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.CYAN_KAOLIN, HibiscusColoredBlocks.CYAN_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN, HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BLUE_KAOLIN, HibiscusColoredBlocks.BLUE_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.PURPLE_KAOLIN, HibiscusColoredBlocks.PURPLE_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.MAGENTA_KAOLIN, HibiscusColoredBlocks.MAGENTA_KAOLIN_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.PINK_KAOLIN, HibiscusColoredBlocks.PINK_KAOLIN_STAIRS, blockStateModelGenerator);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.WHITE_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.GRAY_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BLACK_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BROWN_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.RED_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.ORANGE_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.YELLOW_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIME_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.GREEN_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.CYAN_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BLUE_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.PURPLE_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.MAGENTA_KAOLIN, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.PINK_KAOLIN, class_4946.field_23036);
        this.createSlab(HibiscusColoredBlocks.KAOLIN_BRICKS, HibiscusColoredBlocks.KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.WHITE_KAOLIN_BRICKS, HibiscusColoredBlocks.WHITE_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_BRICKS, HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.GRAY_KAOLIN_BRICKS, HibiscusColoredBlocks.GRAY_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BLACK_KAOLIN_BRICKS, HibiscusColoredBlocks.BLACK_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BROWN_KAOLIN_BRICKS, HibiscusColoredBlocks.BROWN_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.RED_KAOLIN_BRICKS, HibiscusColoredBlocks.RED_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.ORANGE_KAOLIN_BRICKS, HibiscusColoredBlocks.ORANGE_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.YELLOW_KAOLIN_BRICKS, HibiscusColoredBlocks.YELLOW_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIME_KAOLIN_BRICKS, HibiscusColoredBlocks.LIME_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.GREEN_KAOLIN_BRICKS, HibiscusColoredBlocks.GREEN_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.CYAN_KAOLIN_BRICKS, HibiscusColoredBlocks.CYAN_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_BRICKS, HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BLUE_KAOLIN_BRICKS, HibiscusColoredBlocks.BLUE_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.PURPLE_KAOLIN_BRICKS, HibiscusColoredBlocks.PURPLE_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.MAGENTA_KAOLIN_BRICKS, HibiscusColoredBlocks.MAGENTA_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.PINK_KAOLIN_BRICKS, HibiscusColoredBlocks.PINK_KAOLIN_BRICK_SLAB, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.KAOLIN_BRICKS, HibiscusColoredBlocks.KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.WHITE_KAOLIN_BRICKS, HibiscusColoredBlocks.WHITE_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_BRICKS, HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.GRAY_KAOLIN_BRICKS, HibiscusColoredBlocks.GRAY_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BLACK_KAOLIN_BRICKS, HibiscusColoredBlocks.BLACK_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BROWN_KAOLIN_BRICKS, HibiscusColoredBlocks.BROWN_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.RED_KAOLIN_BRICKS, HibiscusColoredBlocks.RED_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.ORANGE_KAOLIN_BRICKS, HibiscusColoredBlocks.ORANGE_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.YELLOW_KAOLIN_BRICKS, HibiscusColoredBlocks.YELLOW_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIME_KAOLIN_BRICKS, HibiscusColoredBlocks.LIME_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.GREEN_KAOLIN_BRICKS, HibiscusColoredBlocks.GREEN_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.CYAN_KAOLIN_BRICKS, HibiscusColoredBlocks.CYAN_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_BRICKS, HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BLUE_KAOLIN_BRICKS, HibiscusColoredBlocks.BLUE_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.PURPLE_KAOLIN_BRICKS, HibiscusColoredBlocks.PURPLE_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.MAGENTA_KAOLIN_BRICKS, HibiscusColoredBlocks.MAGENTA_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.PINK_KAOLIN_BRICKS, HibiscusColoredBlocks.PINK_KAOLIN_BRICK_STAIRS, blockStateModelGenerator);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.WHITE_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIGHT_GRAY_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.GRAY_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BLACK_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BROWN_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.RED_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.ORANGE_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.YELLOW_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIME_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.GREEN_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.CYAN_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIGHT_BLUE_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BLUE_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.PURPLE_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.MAGENTA_KAOLIN_BRICKS, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.PINK_KAOLIN_BRICKS, class_4946.field_23036);
        this.createSlab(HibiscusColoredBlocks.WHITE_CHALK, HibiscusColoredBlocks.WHITE_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIGHT_GRAY_CHALK, HibiscusColoredBlocks.LIGHT_GRAY_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.GRAY_CHALK, HibiscusColoredBlocks.GRAY_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BLACK_CHALK, HibiscusColoredBlocks.BLACK_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BROWN_CHALK, HibiscusColoredBlocks.BROWN_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.RED_CHALK, HibiscusColoredBlocks.RED_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.ORANGE_CHALK, HibiscusColoredBlocks.ORANGE_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.YELLOW_CHALK, HibiscusColoredBlocks.YELLOW_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIME_CHALK, HibiscusColoredBlocks.LIME_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.GREEN_CHALK, HibiscusColoredBlocks.GREEN_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.CYAN_CHALK, HibiscusColoredBlocks.CYAN_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.LIGHT_BLUE_CHALK, HibiscusColoredBlocks.LIGHT_BLUE_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.BLUE_CHALK, HibiscusColoredBlocks.BLUE_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.PURPLE_CHALK, HibiscusColoredBlocks.PURPLE_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.MAGENTA_CHALK, HibiscusColoredBlocks.MAGENTA_CHALK_SLAB, blockStateModelGenerator);
        this.createSlab(HibiscusColoredBlocks.PINK_CHALK, HibiscusColoredBlocks.PINK_CHALK_SLAB, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.WHITE_CHALK, HibiscusColoredBlocks.WHITE_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIGHT_GRAY_CHALK, HibiscusColoredBlocks.LIGHT_GRAY_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.GRAY_CHALK, HibiscusColoredBlocks.GRAY_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BLACK_CHALK, HibiscusColoredBlocks.BLACK_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BROWN_CHALK, HibiscusColoredBlocks.BROWN_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.RED_CHALK, HibiscusColoredBlocks.RED_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.ORANGE_CHALK, HibiscusColoredBlocks.ORANGE_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.YELLOW_CHALK, HibiscusColoredBlocks.YELLOW_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIME_CHALK, HibiscusColoredBlocks.LIME_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.GREEN_CHALK, HibiscusColoredBlocks.GREEN_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.CYAN_CHALK, HibiscusColoredBlocks.CYAN_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.LIGHT_BLUE_CHALK, HibiscusColoredBlocks.LIGHT_BLUE_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.BLUE_CHALK, HibiscusColoredBlocks.BLUE_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.PURPLE_CHALK, HibiscusColoredBlocks.PURPLE_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.MAGENTA_CHALK, HibiscusColoredBlocks.MAGENTA_CHALK_STAIRS, blockStateModelGenerator);
        this.createStairs(HibiscusColoredBlocks.PINK_CHALK, HibiscusColoredBlocks.PINK_CHALK_STAIRS, blockStateModelGenerator);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.WHITE_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIGHT_GRAY_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.GRAY_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BLACK_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BROWN_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.RED_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.ORANGE_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.YELLOW_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIME_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.GREEN_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.CYAN_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.LIGHT_BLUE_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.BLUE_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.PURPLE_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.MAGENTA_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusColoredBlocks.PINK_CHALK, class_4946.field_23036);
        blockStateModelGenerator.method_25554(HibiscusMiscBlocks.DESERT_TURNIP_ROOT_BLOCK, class_4946.field_23055, class_4946.field_23056);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.CHERT_COAL_ORE, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.CHERT_COPPER_ORE, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.CHERT_DIAMOND_ORE, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.CHERT_GOLD_ORE, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.CHERT_EMERALD_ORE, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.CHERT_IRON_ORE, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.CHERT_LAPIS_ORE, class_4946.field_23036);
        blockStateModelGenerator.method_25622(HibiscusMiscBlocks.CHERT_REDSTONE_ORE, class_4946.field_23036);
        this.generateSucculent(HibiscusMiscBlocks.ORNATE_SUCCULENT, HibiscusMiscBlocks.ORNATE_WALL_SUCCULENT, HibiscusMiscBlocks.POTTED_ORNATE_SUCCULENT, blockStateModelGenerator);
        this.generateSucculent(HibiscusMiscBlocks.DROWSY_SUCCULENT, HibiscusMiscBlocks.DROWSY_WALL_SUCCULENT, HibiscusMiscBlocks.POTTED_DROWSY_SUCCULENT, blockStateModelGenerator);
        this.generateSucculent(HibiscusMiscBlocks.AUREATE_SUCCULENT, HibiscusMiscBlocks.AUREATE_WALL_SUCCULENT, HibiscusMiscBlocks.POTTED_AUREATE_SUCCULENT, blockStateModelGenerator);
        this.generateSucculent(HibiscusMiscBlocks.SAGE_SUCCULENT, HibiscusMiscBlocks.SAGE_WALL_SUCCULENT, HibiscusMiscBlocks.POTTED_SAGE_SUCCULENT, blockStateModelGenerator);
        this.generateSucculent(HibiscusMiscBlocks.FOAMY_SUCCULENT, HibiscusMiscBlocks.FOAMY_WALL_SUCCULENT, HibiscusMiscBlocks.POTTED_FOAMY_SUCCULENT, blockStateModelGenerator);
        this.generateSucculent(HibiscusMiscBlocks.IMPERIAL_SUCCULENT, HibiscusMiscBlocks.IMPERIAL_WALL_SUCCULENT, HibiscusMiscBlocks.POTTED_IMPERIAL_SUCCULENT, blockStateModelGenerator);
        this.generateSucculent(HibiscusMiscBlocks.REGAL_SUCCULENT, HibiscusMiscBlocks.REGAL_WALL_SUCCULENT, HibiscusMiscBlocks.POTTED_REGAL_SUCCULENT, blockStateModelGenerator);
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_25733(HibiscusMiscBlocks.GREEN_OLIVES, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusMiscBlocks.BLACK_OLIVES, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusMiscBlocks.DESERT_TURNIP, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusWoods.COCONUT_SHELL, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusWoods.YOUNG_COCONUT_SHELL, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusWoods.YOUNG_COCONUT_HALF, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusWoods.COCONUT_HALF, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusMiscBlocks.CALCITE_SHARD, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusMiscBlocks.CHALK_POWDER, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusMiscBlocks.CHEESE_BUCKET, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusMiscBlocks.HELVOLA_FLOWER_ITEM, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusMiscBlocks.HELVOLA_PAD_ITEM, class_4943.field_22938);
        itemModelGenerator.method_25733(HibiscusMiscBlocks.CHEESE_ARROW, class_4943.field_22938);
        for (HibiscusBoatEntity.HibiscusBoat boat : HibiscusBoatEntity.HibiscusBoat.values()) {
            itemModelGenerator.method_25733(boat.boat().method_8389(), class_4943.field_22938);
            itemModelGenerator.method_25733(boat.chestBoat().method_8389(), class_4943.field_22938);
        }
    }

    private static /* synthetic */ class_4935 lambda$registerCropWithoutItem$1(int[] ageTextureIndices, Int2ObjectMap int2ObjectMap, class_4910 blockStateModelGenerator, class_2248 crop, Integer integer) {
        int i = ageTextureIndices[integer];
        class_2960 identifier = (class_2960)int2ObjectMap.computeIfAbsent(i, j -> blockStateModelGenerator.method_25557(crop, "_stage" + i, class_4943.field_22960, class_4944::method_25889));
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier);
    }
}

