/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.hibiscus.naturespirit.blocks.LargeFlowerBlock;
import net.hibiscus.naturespirit.blocks.LargeTallFlowerBlock;
import net.hibiscus.naturespirit.blocks.MidFlowerBlock;
import net.hibiscus.naturespirit.registration.HibiscusItemGroups;
import net.hibiscus.naturespirit.registration.HibiscusRegistryHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2356;
import net.minecraft.class_2498;
import net.minecraft.class_2521;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class FlowerSet {
    private String name;
    private class_1792 dyeColor;
    private class_1291 statusEffect;
    private class_1792 itemBefore;
    private FlowerPreset preset;
    private class_2248 flowerBlock;
    private class_2248 pottedFlowerBlock;
    private List<class_2248> registeredBlocksList = new ArrayList<class_2248>();
    private List<class_1792> registeredItemsList = new ArrayList<class_1792>();

    public FlowerSet(String name, class_1792 dyeColor, class_1291 statusEffect, class_1792 itemBefore, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = dyeColor;
        this.statusEffect = statusEffect;
        this.itemBefore = itemBefore;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, class_1792 dyeColor, class_1792 itemBefore, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = dyeColor;
        this.statusEffect = null;
        this.itemBefore = itemBefore;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, class_1291 statusEffect, class_1792 itemBefore, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = null;
        this.statusEffect = statusEffect;
        this.itemBefore = itemBefore;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, class_1792 itemBefore, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = null;
        this.statusEffect = null;
        this.itemBefore = itemBefore;
        this.preset = preset;
        this.registerFlower();
    }

    private void registerFlower() {
        if (this.preset == FlowerPreset.BIG_TALL) {
            this.flowerBlock = HibiscusRegistryHelper.registerPlantBlock(this.name, (class_2248)new LargeTallFlowerBlock((class_4970.class_2251)FabricBlockSettings.create().noCollision().breakInstantly().sounds(class_2498.field_11535).burnable().offset(class_4970.class_2250.field_10657).pistonBehavior(class_3619.field_15971)), HibiscusItemGroups.NS_ITEM_GROUP, (class_1935)this.itemBefore, 0.4f);
        } else if (this.preset == FlowerPreset.TALL) {
            this.flowerBlock = HibiscusRegistryHelper.registerPlantBlock(this.name, (class_2248)new class_2521((class_4970.class_2251)FabricBlockSettings.create().noCollision().breakInstantly().sounds(class_2498.field_11535).burnable().offset(class_4970.class_2250.field_10657).pistonBehavior(class_3619.field_15971)), HibiscusItemGroups.NS_ITEM_GROUP, (class_1935)this.itemBefore, 0.4f);
        } else if (this.preset == FlowerPreset.BIG_SMALL) {
            this.flowerBlock = HibiscusRegistryHelper.registerPlantBlock(this.name, (class_2248)new LargeFlowerBlock(this.statusEffect, 7, (class_4970.class_2251)FabricBlockSettings.create().mapColor(class_3620.field_16004).noCollision().breakInstantly().sounds(class_2498.field_11535).offset(class_4970.class_2250.field_10657).pistonBehavior(class_3619.field_15971)), HibiscusItemGroups.NS_ITEM_GROUP, (class_1935)this.itemBefore, 0.4f);
        } else if (this.preset == FlowerPreset.SMALL) {
            this.flowerBlock = HibiscusRegistryHelper.registerPlantBlock(this.name, (class_2248)new class_2356(this.statusEffect, 7, (class_4970.class_2251)FabricBlockSettings.create().mapColor(class_3620.field_16004).noCollision().breakInstantly().sounds(class_2498.field_11535).offset(class_4970.class_2250.field_10657).pistonBehavior(class_3619.field_15971)), HibiscusItemGroups.NS_ITEM_GROUP, (class_1935)this.itemBefore, 0.3f);
        } else if (this.preset == FlowerPreset.ANEMONE) {
            this.flowerBlock = HibiscusRegistryHelper.registerPlantBlock(this.name, (class_2248)new MidFlowerBlock(this.statusEffect, 7, (class_4970.class_2251)FabricBlockSettings.create().mapColor(class_3620.field_16004).noCollision().breakInstantly().sounds(class_2498.field_11535).offset(class_4970.class_2250.field_10657).pistonBehavior(class_3619.field_15971)), HibiscusItemGroups.NS_ITEM_GROUP, (class_1935)this.itemBefore, 0.3f);
        }
        if (this.hasFlowerPot()) {
            this.pottedFlowerBlock = HibiscusRegistryHelper.registerPottedPlant(this.name, this.flowerBlock);
            this.registeredBlocksList.add(this.pottedFlowerBlock);
        }
        this.registeredBlocksList.add(this.flowerBlock);
        HibiscusRegistryHelper.FlowerHashMap.put(this.name, this);
    }

    public int getDyeNumber() {
        switch (this.preset.ordinal()) {
            default: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
        }
        return 4;
    }

    public List<class_2248> getRegisteredBlocksList() {
        return this.registeredBlocksList;
    }

    public FlowerPreset getPreset() {
        return this.preset;
    }

    public boolean hasFlowerPot() {
        return this.getPreset() == FlowerPreset.SMALL || this.getPreset() == FlowerPreset.BIG_SMALL || this.getPreset() == FlowerPreset.ANEMONE;
    }

    public boolean isTall() {
        return this.getPreset() == FlowerPreset.TALL || this.getPreset() == FlowerPreset.BIG_TALL;
    }

    public class_1792 getDyeColor() {
        return this.dyeColor;
    }

    public class_2248 getFlowerBlock() {
        return this.flowerBlock;
    }

    public class_2248 getPottedFlowerBlock() {
        return this.pottedFlowerBlock;
    }

    public String getName() {
        return this.name;
    }

    public static enum FlowerPreset {
        SMALL,
        ANEMONE,
        TALL,
        BIG_SMALL,
        BIG_TALL;

    }
}

