/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.world.HibiscusWorldGen;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public class BirchFoliagePlacer
extends class_4647 {
    public static final Codec<BirchFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> BirchFoliagePlacer.createCodec(instance).apply((Applicative)instance, BirchFoliagePlacer::new));
    protected final int height;

    protected static <P extends BirchFoliagePlacer> Products.P3<RecordCodecBuilder.Mu<P>, class_6017, class_6017, Integer> createCodec(RecordCodecBuilder.Instance<P> builder) {
        return BirchFoliagePlacer.method_30411(builder).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(placer -> placer.height));
    }

    public BirchFoliagePlacer(class_6017 radius, class_6017 offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    protected class_4648<?> method_28843() {
        return HibiscusWorldGen.BIRCH_FOLIAGE_PLACER_TYPE;
    }

    protected void method_23448(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, int trunkHeight, class_4647.class_5208 treeNode, int foliageHeight, int radius, int offset) {
        for (int i = offset; i >= offset - foliageHeight; --i) {
            int j = Math.max(Math.min(radius + treeNode.method_27389() - 1 - i / 2, 3), 0);
            if (i == offset - foliageHeight) {
                this.generateDiagonal(world, placer, random, config, treeNode.method_27388(), radius, i, treeNode.method_27390());
                continue;
            }
            if (j == 2 && Math.max(Math.min(radius + treeNode.method_27389() - 2 - i / 2, 3), 0) == 1) {
                this.generateCircle(world, placer, random, config, treeNode.method_27388(), j, i, treeNode.method_27390());
                continue;
            }
            if (j == 3) {
                this.generateCircularSquare(world, placer, random, config, treeNode.method_27388(), j, i, treeNode.method_27390());
                continue;
            }
            this.method_23449(world, placer, random, config, treeNode.method_27388(), j, i, treeNode.method_27390());
        }
    }

    protected void generateDiagonal(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateDiagonal(random, j, y, k, radius, giantTrunk)) continue;
                mutable.method_25504((class_2382)centerPos, j, y, k);
                BirchFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutable);
            }
        }
    }

    protected void generateCircularSquare(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCircularSquare(random, j, y, k, radius, giantTrunk)) continue;
                mutable.method_25504((class_2382)centerPos, j, y, k);
                BirchFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutable);
            }
        }
    }

    protected void generateCircle(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCircle(random, j, y, k, radius, giantTrunk)) continue;
                mutable.method_25504((class_2382)centerPos, j, y, k);
                BirchFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutable);
            }
        }
    }

    protected boolean validateCircularSquare(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        dx = Math.abs(dx);
        dz = Math.abs(dz);
        return (dx == radius || dz == radius) && (dx != 0 && dz != 0 || random.method_43048(3) == 0) || dx == radius - 1 && dz == radius - 1 && random.method_43048(2) == 0;
    }

    protected boolean validateCircle(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        dx = Math.abs(dx);
        dz = Math.abs(dz);
        return dx == radius && dz == radius && radius > 0 && random.method_43057() < 0.7f;
    }

    protected boolean validateDiagonal(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        dx = Math.abs(dx);
        dz = Math.abs(dz);
        return (dx > 1 || dz > 1) && dx != 0 && dz != 0;
    }

    public int method_26989(class_5819 random, int trunkHeight, class_4643 config) {
        return this.height;
    }

    protected boolean method_23451(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return dx == radius && dz == radius && (random.method_43048(2) == 0 || y == 0);
    }
}

