/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.world.HibiscusWorldGen;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public class RedwoodFoliagePlacer
extends class_4647 {
    public static final Codec<RedwoodFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> RedwoodFoliagePlacer.method_30411((RecordCodecBuilder.Instance)instance).and((App)class_6017.method_35004((int)0, (int)32).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, RedwoodFoliagePlacer::new));
    private final class_6017 trunkHeight;

    public RedwoodFoliagePlacer(class_6017 intProvider, class_6017 intProvider2, class_6017 trunkHeight) {
        super(intProvider, intProvider2);
        this.trunkHeight = trunkHeight;
    }

    protected class_4648<?> method_28843() {
        return HibiscusWorldGen.REDWOOD_FOLIAGE_PLACER_TYPE;
    }

    protected void method_23448(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, int trunkHeight, class_4647.class_5208 treeNode, int foliageHeight, int radius, int offset) {
        int a;
        class_2338 blockPos = treeNode.method_27388();
        class_2338.class_2339 mutable = blockPos.method_25503();
        int layers = random.method_39332(1, 6);
        int middleLayers = layers / 2;
        int largeLayers = layers - middleLayers;
        mutable.method_25504((class_2382)blockPos, 0, ++offset, 0);
        this.method_23449(world, placer, random, config, (class_2338)mutable, 0, 0, treeNode.method_27390());
        mutable.method_25504((class_2382)blockPos, 0, offset - 1, 0);
        this.method_23449(world, placer, random, config, (class_2338)mutable, 0, 0, treeNode.method_27390());
        mutable.method_25504((class_2382)blockPos, 0, offset - 2, 0);
        this.method_23449(world, placer, random, config, (class_2338)mutable, 0, 0, treeNode.method_27390());
        this.generateCross(world, placer, random, config, blockPos, 2, offset - 3, treeNode.method_27390());
        this.generateCross(world, placer, random, config, blockPos, 1, offset - 4, treeNode.method_27390());
        int middeY = offset - 5;
        for (a = middleLayers; a > 0; --a) {
            this.generateCircle(world, placer, random, config, blockPos, 2, middeY, treeNode.method_27390());
            this.generateCross(world, placer, random, config, blockPos, 1, --middeY, treeNode.method_27390());
            --middeY;
        }
        for (a = largeLayers; a > 0; --a) {
            this.generateBigCircularSquare(world, placer, random, config, blockPos, 3, middeY, treeNode.method_27390());
            --middeY;
            if (a - 1 != 0) {
                this.generateCross(world, placer, random, config, blockPos, 2, middeY, treeNode.method_27390());
            } else {
                this.generateCircularSquare(world, placer, random, config, blockPos, 3, middeY, treeNode.method_27390());
                this.generateBigCircularSquare(world, placer, random, config, blockPos, 4, --middeY, treeNode.method_27390());
                this.generateCross(world, placer, random, config, blockPos, 1, --middeY, treeNode.method_27390());
                this.generateCircle(world, placer, random, config, blockPos, 2, --middeY, treeNode.method_27390());
            }
            --middeY;
        }
    }

    protected void generateCircle(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCircle(random, j, y, k, radius, giantTrunk)) continue;
                mutable.method_25504((class_2382)centerPos, j, y, k);
                RedwoodFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutable);
            }
        }
    }

    protected void generateCross(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCross(random, j, y, k, radius, giantTrunk)) continue;
                mutable.method_25504((class_2382)centerPos, j, y, k);
                RedwoodFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutable);
            }
        }
    }

    protected void generateCircularSquare(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCircularSquare(random, j, y, k, radius, giantTrunk)) continue;
                mutable.method_25504((class_2382)centerPos, j, y, k);
                RedwoodFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutable);
            }
        }
    }

    protected void generateBigCircularSquare(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateBigCircularSquare(random, j, y, k, radius, giantTrunk)) continue;
                mutable.method_25504((class_2382)centerPos, j, y, k);
                RedwoodFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutable);
            }
        }
    }

    public int method_26989(class_5819 random, int trunkHeight, class_4643 config) {
        return Math.max(8, trunkHeight - this.trunkHeight.method_35008(random));
    }

    protected boolean method_23451(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }

    protected boolean validateCircle(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (giantTrunk) {
            dx = Math.min(Math.abs(dx), Math.abs(dx - 1));
            dz = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            dx = Math.abs(dx);
            dz = Math.abs(dz);
        }
        return dx == radius && dz == radius && radius > 0;
    }

    protected boolean validateCircularSquare(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (giantTrunk) {
            dx = Math.min(Math.abs(dx), Math.abs(dx - 1));
            dz = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            dx = Math.abs(dx);
            dz = Math.abs(dz);
        }
        return (dx == radius || dz == radius) && dx > 0 && dz > 0;
    }

    protected boolean validateBigCircularSquare(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (giantTrunk) {
            dx = Math.min(Math.abs(dx), Math.abs(dx - 1));
            dz = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            dx = Math.abs(dx);
            dz = Math.abs(dz);
        }
        return (dx == radius || dz == radius) && dx > 1 && dz > 1;
    }

    protected boolean validateCross(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (giantTrunk) {
            dx = Math.min(Math.abs(dx), Math.abs(dx - 1));
            dz = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            dx = Math.abs(dx);
            dz = Math.abs(dz);
        }
        return (dx > 0 || dz > 0) && dx != 0 && dz != 0;
    }
}

